# Pediatric BMI Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pediatric BMI Example**

## Example Observation: Pediatric BMI Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Pediatric BMI for Age Observation Profileversion: null8.0.1)](StructureDefinition-pediatric-bmi-for-age.md)

**status**: Final

**category**: Vital Signs

**code**: BMI

**subject**: [Child Example](Patient-child-example.md)

**encounter**: GP Visit

**effective**: 2019-05-04 12:12:29-0700

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 65 %(Details: UCUM code% = '%')

**note**: 

> 

CDC Males, 2-20 years Chart




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "pediatric-bmi-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-bmi-for-age|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "59576-9",
        "display" : "Body mass index (BMI) [Percentile] Per age and sex"
      }
    ],
    "text" : "BMI"
  },
  "subject" : {
    "reference" : "Patient/child-example",
    "display" : "Child Example"
  },
  "encounter" : {
    "display" : "GP Visit"
  },
  "effectiveDateTime" : "2019-05-04T12:12:29-07:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 65,
    "unit" : "%",
    "system" : "http://unitsofmeasure.org",
    "code" : "%"
  },
  "note" : [
    {
      "text" : "CDC Males, 2-20 years Chart"
    }
  ]
}

```
