# ADI Observation Presence No ADI Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ADI Observation Presence No ADI Example**

## Example Observation: ADI Observation Presence No ADI Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation ADI Documentation Profileversion: null8.0.1)](StructureDefinition-us-core-observation-adi-documentation.md)

**status**: Final

**category**: Observation ADI Documentation

**code**: Advance healthcare directive completed

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2024-05-16 01:06:06+0000

**issued**: 2024-05-16 01:06:06+0000

**performer**: [Dr Smith](Practitioner-practitioner-1.md)

**value**: No (qualifier value)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "no-ADI-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-adi-documentation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "observation-adi-documentation",
          "display" : "Observation ADI Documentation"
        }
      ],
      "text" : "Observation ADI Documentation"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "45473-6",
        "display" : "Advance healthcare directive completed"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2024-05-16T01:06:06.393Z",
  "issued" : "2024-05-16T01:06:06.393Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Smith"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "373067005",
        "display" : "No (qualifier value)"
      }
    ]
  }
}

```
