# Heart rate rhythm Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Heart rate rhythm Example**

## Example Observation: Heart rate rhythm Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Clinical Result Profileversion: null8.0.1)](StructureDefinition-us-core-observation-clinical-result.md)

**status**: Final

**category**: Exam

**code**: Heart rate rhythm

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: Cardiology Consult

**effective**: 2021-11-10 16:48:57-0800

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: Regular (R)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "heart-rate-rhythm",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam",
          "display" : "Exam"
        }
      ],
      "text" : "Exam"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8884-9",
        "display" : "Heart rate rhythm"
      }
    ],
    "text" : "Heart rate rhythm"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "display" : "Cardiology Consult"
  },
  "effectiveDateTime" : "2021-11-10T16:48:57.246958-08:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueString" : "Regular (R)"
}

```
