# Exercise Per Week Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Exercise Per Week Example**

## Example Observation: Exercise Per Week Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Simple Observation Profileversion: null8.0.1)](StructureDefinition-us-core-simple-observation.md)

**status**: Final

**category**: Social History, Physical Activity

**code**: Exercise Days Per Week

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-03

**performer**: [Amy Shaw](Patient-example.md)

**value**: 3 days per week(Details: UCUM coded/wk = 'd/wk')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "exercise-per-week",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "activity",
          "display" : "Activity"
        }
      ],
      "text" : "Physical Activity"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "89555-7",
        "display" : "How many days per week did you engage in moderate to strenuous physical activity in the last 30 days"
      }
    ],
    "text" : "Exercise Days Per Week"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2023-08-03",
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "valueQuantity" : {
    "value" : 3,
    "unit" : "days per week",
    "system" : "http://unitsofmeasure.org",
    "code" : "d/wk"
  }
}

```
