# MCV Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MCV Example**

## Example Observation: MCV Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

*This example may lack required data for laboratory results transmitted by a laboratory certified to perform testing on human specimens under the [Clinical Laboratory Improvement Amendments (CLIA)](http://www.cdc.gov/clia/).

Last updated: 2005-07-05 15:29:58+0000

Profile: [US Core Laboratory Result Observation Profileversion: null8.0.1)](StructureDefinition-us-core-observation-lab.md)

**status**: Final

**category**: Laboratory

**code**: Mean Corpuscular Volume (MCV), Red blood cells

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2005-07-05

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 85 fL(Details: UCUM codefL = 'fL')

**interpretation**: Normal

**specimen**: [Whole Blood Specimen Example](Specimen-specimen-example-whole-blood.md)

### ReferenceRanges

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Low** | **High** | **Type** |
| * | 87.3 fL(Details: UCUM codefL = 'fL') | 82.4 fL(Details: UCUM codefL = 'fL') | Normal Range |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "cbc-mcv",
  "meta" : {
    "lastUpdated" : "2005-07-05T15:29:58.597000+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ],
      "text" : "Laboratory"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "787-2",
        "display" : "Mean Corpuscular Volume (MCV), Red blood cells"
      }
    ],
    "text" : "Mean Corpuscular Volume (MCV), Red blood cells"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2005-07-05",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 85,
    "unit" : "fL",
    "system" : "http://unitsofmeasure.org",
    "code" : "fL"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ],
      "text" : "Normal"
    }
  ],
  "specimen" : {
    "reference" : "Specimen/specimen-example-whole-blood",
    "display" : "Whole Blood Specimen Example"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 87.3,
        "unit" : "fL",
        "system" : "http://unitsofmeasure.org",
        "code" : "fL"
      },
      "high" : {
        "value" : 82.4,
        "unit" : "fL",
        "system" : "http://unitsofmeasure.org",
        "code" : "fL"
      },
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/referencerange-meaning",
            "code" : "normal",
            "display" : "Normal Range"
          }
        ],
        "text" : "Normal Range"
      }
    }
  ]
}

```
