# MCH Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MCH Example**

## Example Observation: MCH Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

*This example may lack required data for laboratory results transmitted by a laboratory certified to perform testing on human specimens under the [Clinical Laboratory Improvement Amendments (CLIA)](http://www.cdc.gov/clia/).

Last updated: 2005-07-05 15:29:58+0000

Profile: [US Core Laboratory Result Observation Profileversion: null8.0.1)](StructureDefinition-us-core-observation-lab.md)

**status**: Final

**category**: Laboratory

**code**: Mean Corpuscular Hemoglobin (MCH), Red blood cells

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2005-07-05

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 30 pg(Details: UCUM codepg = 'pg')

**interpretation**: Normal

**specimen**: [Whole Blood Specimen Example](Specimen-specimen-example-whole-blood.md)

### ReferenceRanges

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Low** | **High** | **Type** |
| * | 33.2 pg(Details: UCUM codepg = 'pg') | 27.5 pg(Details: UCUM codepg = 'pg') | Normal Range |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "cbc-mch",
  "meta" : {
    "lastUpdated" : "2005-07-05T15:29:58.597000+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ],
      "text" : "Laboratory"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "785-6",
        "display" : "MCH [Entitic mass] by Automated count"
      }
    ],
    "text" : "Mean Corpuscular Hemoglobin (MCH), Red blood cells"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2005-07-05",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 30,
    "unit" : "pg",
    "system" : "http://unitsofmeasure.org",
    "code" : "pg"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ],
      "text" : "Normal"
    }
  ],
  "specimen" : {
    "reference" : "Specimen/specimen-example-whole-blood",
    "display" : "Whole Blood Specimen Example"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 33.2,
        "unit" : "pg",
        "system" : "http://unitsofmeasure.org",
        "code" : "pg"
      },
      "high" : {
        "value" : 27.5,
        "unit" : "pg",
        "system" : "http://unitsofmeasure.org",
        "code" : "pg"
      },
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/referencerange-meaning",
            "code" : "normal",
            "display" : "Normal Range"
          }
        ],
        "text" : "Normal Range"
      }
    }
  ]
}

```
