# Hematocrit Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hematocrit Example**

## Example Observation: Hematocrit Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

*This example may lack required data for laboratory results transmitted by a laboratory certified to perform testing on human specimens under the [Clinical Laboratory Improvement Amendments (CLIA)](http://www.cdc.gov/clia/).

Last updated: 2005-07-05 15:29:58+0000

Profile: [US Core Laboratory Result Observation Profileversion: null8.0.1)](StructureDefinition-us-core-observation-lab.md)

**status**: Final

**category**: Laboratory

**code**: Hematocrit, Blood

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2005-07-05

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 43 %(Details: UCUM code% = '%')

**interpretation**: Normal

**specimen**: [Whole Blood Specimen Example](Specimen-specimen-example-whole-blood.md)

### ReferenceRanges

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Low** | **High** | **Type** |
| * | 46 %(Details: UCUM code% = '%') | 38 %(Details: UCUM code% = '%') | Normal Range |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "cbc-hematocrit",
  "meta" : {
    "lastUpdated" : "2005-07-05T15:29:58.597000+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ],
      "text" : "Laboratory"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "4544-3",
        "display" : "Hematocrit [Volume Fraction] of Blood by Automated count"
      }
    ],
    "text" : "Hematocrit, Blood"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2005-07-05",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 43,
    "unit" : "%",
    "system" : "http://unitsofmeasure.org",
    "code" : "%"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ],
      "text" : "Normal"
    }
  ],
  "specimen" : {
    "reference" : "Specimen/specimen-example-whole-blood",
    "display" : "Whole Blood Specimen Example"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 46,
        "unit" : "%",
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      },
      "high" : {
        "value" : 38,
        "unit" : "%",
        "system" : "http://unitsofmeasure.org",
        "code" : "%"
      },
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/referencerange-meaning",
            "code" : "normal",
            "display" : "Normal Range"
          }
        ],
        "text" : "Normal Range"
      }
    }
  ]
}

```
