# Care Experience Preference Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Experience Preference Example**

## Example Observation: Care Experience Preference Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Care Experience Preference Profileversion: null8.0.1)](StructureDefinition-us-core-care-experience-preference.md)

**status**: Final

**category**: Care Experience Preference

**code**: Care Experience Preference

**subject**: [Amy Shaw](Patient-example.md)

**effective**: 2023-08-30

**performer**: [Amy Shaw](Patient-example.md)

**value**: For critical or end-of-life care, here are some examples of the things that I would like to have near me, music that I’d like to hear, and other details of my care that would help to keep me happy and relaxed: Like Bach, especially the cantatas. St. Martin in the Fields



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "care-experience-preference",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-care-experience-preference|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "care-experience-preference",
          "display" : "Care experience preference"
        }
      ],
      "text" : "Care Experience Preference"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "95541-9",
        "display" : "Care experience preference"
      }
    ],
    "text" : "Care Experience Preference"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2023-08-30",
  "performer" : [
    {
      "reference" : "Patient/example",
      "display" : "Amy Shaw"
    }
  ],
  "valueString" : "For critical or end-of-life care, here are some examples of the things that I would like to have near me, music that I’d like to hear, and other details of my care that would help to keep me happy and relaxed: Like Bach, especially the cantatas.  St. Martin in the Fields"
}

```
