# Capillary refill Time Nail Bed Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Capillary refill Time Nail Bed Example**

## Example Observation: Capillary refill Time Nail Bed Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Clinical Result Profileversion: null8.0.1)](StructureDefinition-us-core-observation-clinical-result.md)

**status**: Final

**category**: Exam

**code**: Capillary refill Time Nail Bed

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: Cardiology Consult

**effective**: 2021-11-10 16:48:57-0800

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

**value**: 1 s(Details: UCUM codes = 's')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "capillary-refill-time-nail-bed",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam",
          "display" : "Exam"
        }
      ],
      "text" : "Exam"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "44963-7",
        "display" : "Capillary refill Time Nail Bed"
      }
    ],
    "text" : "Capillary refill Time Nail Bed"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "display" : "Cardiology Consult"
  },
  "effectiveDateTime" : "2021-11-10T16:48:57.246958-08:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 1,
    "unit" : "s",
    "system" : "http://unitsofmeasure.org",
    "code" : "s"
  }
}

```
