# BP Data Absent Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BP Data Absent Example**

## Example Observation: BP Data Absent Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Blood Pressure Profileversion: null8.0.1)](StructureDefinition-us-core-blood-pressure.md)

**status**: Final

**category**: Vital Signs

**code**: Blood pressure systolic and diastolic

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Unknown (qualifier value)](Encounter-1036.md)

**effective**: 1999-07-02

**performer**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

> **component****code**:Systolic blood pressure**value**: 109 mmHg(Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Diastolic blood pressure**dataAbsentReason**:Unknown



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "bp-data-absent",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-blood-pressure|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "85354-9",
        "display" : "Blood pressure panel with all children optional"
      }
    ],
    "text" : "Blood pressure systolic and diastolic"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/1036"
  },
  "effectiveDateTime" : "1999-07-02",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8480-6",
            "display" : "Systolic blood pressure"
          }
        ],
        "text" : "Systolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 109,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8462-4",
            "display" : "Diastolic blood pressure"
          }
        ],
        "text" : "Diastolic blood pressure"
      },
      "dataAbsentReason" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "unknown",
            "display" : "Unknown"
          }
        ],
        "text" : "Unknown"
      }
    }
  ]
}

```
