# Taps Panel Example 96841-2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Taps Panel Example 96841-2**

## Example Observation: Taps Panel Example 96841-2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-14 20:40:49+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**hasMember**: 

* [Observation How often have you used any tobacco product in past 12 months](Observation-TAPS-item-example-96842-0.md)
* [Observation How often have you had five or more drinks in one day during the past year [Reported]](Observation-TAPS-item-example-88037-7.md)
* [Observation How often have you had four or more drinks in one day during the past year [Reported]](Observation-TAPS-item-example-75889-6.md)
* [Observation How often have you used illegal or recreational drugs in past 12 months](Observation-TAPS-item-example-96843-8.md)
* [Observation How often have you used any prescription medications just for the feeling, more than prescribed or that were not prescribed for you in past 12 months [TAPS]](Observation-TAPS-item-example-96844-6.md)

**derivedFrom**: [Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS] QuestionnaireResponse Example](QuestionnaireResponse-TAPS.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "TAPS-panel-example-96841-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "96841-2",
        "display" : "Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS]"
      }
    ],
    "text" : "Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-14T20:40:49.675000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/TAPS-item-example-96842-0"
    },
    {
      "reference" : "Observation/TAPS-item-example-88037-7"
    },
    {
      "reference" : "Observation/TAPS-item-example-75889-6"
    },
    {
      "reference" : "Observation/TAPS-item-example-96843-8"
    },
    {
      "reference" : "Observation/TAPS-item-example-96844-6"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/TAPS",
      "display" : "Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS] QuestionnaireResponse Example"
    }
  ]
}

```
