# Taps Item Example 75889-6 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Taps Item Example 75889-6**

## Example Observation: Taps Item Example 75889-6

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: How often have you had four or more drinks in one day during the past year [Reported]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-14 20:40:49+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: Never

**note**: 

> 

A question asked to determine if the patient is considered a 'risky drinker'. This term was created for, but not limited in use to, an electronic Clinical Quality Measure (eCQM) to be used in the CMS EHR Incentive Program for Meaningful Use. The eCQM allows for multiple ways to screen for alcohol misuse, including AUDIT-C [LOINC: 75626-2] or one of two questions that assess whether the patient consumes alcohol [LOINC: 75855-7] and the frequency of heavy drinking days (this LOINC). The LOINC for five (5) or more drinks per day is [LOINC: 88037-7].


**derivedFrom**: [Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS] QuestionnaireResponse Example](QuestionnaireResponse-TAPS.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "TAPS-item-example-75889-6",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "75889-6",
        "display" : "How often have you had four or more drinks in one day during the past year [Reported]"
      }
    ],
    "text" : "How often have you had four or more drinks in one day during the past year [Reported]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-14T20:40:49.675000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA6270-8",
        "display" : "Never"
      }
    ],
    "text" : "Never"
  },
  "note" : [
    {
      "text" : "A question asked to determine if the patient is considered a 'risky drinker'. This term was created for, but not limited in use to, an electronic Clinical Quality Measure (eCQM) to be used in the CMS EHR Incentive Program for Meaningful Use. The eCQM allows for multiple ways to screen for alcohol misuse, including AUDIT-C [LOINC: 75626-2] or one of two questions that assess whether the patient consumes alcohol [LOINC: 75855-7] and the frequency of heavy drinking days (this LOINC). The LOINC for five (5) or more drinks per day is [LOINC: 88037-7]."
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/TAPS",
      "display" : "Tobacco, Alcohol, Prescription medications, and other Substance use screen [TAPS] QuestionnaireResponse Example"
    }
  ]
}

```
