# Prapare Panel Example 93039-6 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Prapare Panel Example 93039-6**

## Example Observation: Prapare Panel Example 93039-6

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: Optional additional questions

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-03-28 18:30:40-0700

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**hasMember**: 

* [Observation Have you spent more than 2 nights in a row in a jail, prison, detention center, or juvenile correctional facility in past 1 year [PRAPARE]](Observation-PRAPARE-item-example-93028-9.md)
* [Observation Are you a refugee](Observation-PRAPARE-item-example-93027-1.md)
* [Observation Do you feel physically and emotionally safe where you currently live [PRAPARE]](Observation-PRAPARE-item-example-93026-3.md)
* [Observation Within the last year, have you been afraid of your partner or ex-partner](Observation-PRAPARE-item-example-76501-6.md)

**derivedFrom**: [Response to Questionnaire '->Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]' about '->Amy V. Shaw'](QuestionnaireResponse-prapare-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PRAPARE-panel-example-93039-6",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "93039-6",
        "display" : "Optional additional questions [PRAPARE]"
      }
    ],
    "text" : "Optional additional questions"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-03-28T18:30:40-07:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/PRAPARE-item-example-93028-9"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-93027-1"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-93026-3"
    },
    {
      "reference" : "Observation/PRAPARE-item-example-76501-6"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/prapare-example"
    }
  ]
}

```
