# Prapare Panel Example 93025-5 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Prapare Panel Example 93025-5**

## Example Observation: Prapare Panel Example 93025-5

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-03-28 18:30:40-0700

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**hasMember**: 

* [Observation Personal characteristics [PRAPARE]](Observation-PRAPARE-panel-example-93043-8.md)
* [Observation Family and home [PRAPARE]](Observation-PRAPARE-panel-example-93042-0.md)
* [Observation Money and resources [PRAPARE]](Observation-PRAPARE-panel-example-93041-2.md)
* [Observation Social and emotional health [PRAPARE]](Observation-PRAPARE-panel-example-93040-4.md)
* [Observation Optional additional questions [PRAPARE]](Observation-PRAPARE-panel-example-93039-6.md)

**derivedFrom**: [Response to Questionnaire '->Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]' about '->Amy V. Shaw'](QuestionnaireResponse-prapare-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PRAPARE-panel-example-93025-5",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "93025-5",
        "display" : "Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]"
      }
    ],
    "text" : "Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-03-28T18:30:40-07:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/PRAPARE-panel-example-93043-8"
    },
    {
      "reference" : "Observation/PRAPARE-panel-example-93042-0"
    },
    {
      "reference" : "Observation/PRAPARE-panel-example-93041-2"
    },
    {
      "reference" : "Observation/PRAPARE-panel-example-93040-4"
    },
    {
      "reference" : "Observation/PRAPARE-panel-example-93039-6"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/prapare-example"
    }
  ]
}

```
