# Prapare Item Example 63586-2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Prapare Item Example 63586-2**

## Example Observation: Prapare Item Example 63586-2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: What was your best estimate of the total income of all family members from all sources, before taxes, in last year [PhenX]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-03-28 18:30:40-0700

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**value**: 25000

**derivedFrom**: [Response to Questionnaire '->Protocol for Responding to and Assessing Patients' Assets, Risks, and Experiences [PRAPARE]' about '->Amy V. Shaw'](QuestionnaireResponse-prapare-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PRAPARE-item-example-63586-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "63586-2",
        "display" : "What was your best estimate of the total income of all family members from all sources, before taxes, in last year [PhenX]"
      }
    ],
    "text" : "What was your best estimate of the total income of all family members from all sources, before taxes, in last year [PhenX]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-03-28T18:30:40-07:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "valueString" : "25000",
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/prapare-example"
    }
  ]
}

```
