# PHQ9 Item Example 44261-6 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PHQ9 Item Example 44261-6**

## Example Observation: PHQ9 Item Example 44261-6

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey, Disability Status

**code**: Patient Health Questionnaire 9 item (PHQ-9) total score [Reported]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-11-29 20:50:32+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: 12

**derivedFrom**: [Response to Questionnaire '->PHQ-9 Example' about '->Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))'](QuestionnaireResponse-phq-9-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "PHQ9-item-example-44261-6",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "disability-status",
          "display" : "Disability Status"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "44261-6",
        "display" : "Patient Health Questionnaire 9 item (PHQ-9) total score [Reported]"
      }
    ],
    "text" : "Patient Health Questionnaire 9 item (PHQ-9) total score [Reported]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-11-29T20:50:32.718000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueString" : "12",
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/phq-9-example"
    }
  ]
}

```
