# HVSPanel Example 88121-9 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HVSPanel Example 88121-9**

## Example Observation: HVSPanel Example 88121-9

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: Hunger Vital Sign [HVS]

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2020-09-10 21:56:54+0000

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**value**: 2 score

**hasMember**: 

* [Observation Within the past 12 months we worried whether our food would run out before we got money to buy more](Observation-HVS-item-example-88122-7.md)
* [Observation Within the past 12 months the food we bought just didn't last and we didn't have money to get more](Observation-HVS-item-example-88123-5.md)
* [Observation Food insecurity risk [HVS]](Observation-HVS-item-example-88124-3.md)

**derivedFrom**: [Response to Questionnaire '->Hunger Vital Sign Example' about '->Amy V. Shaw'](QuestionnaireResponse-hunger-vital-sign-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "HVS-panel-example-88121-9",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "88121-9",
        "display" : "Hunger Vital Sign [HVS]"
      }
    ],
    "text" : "Hunger Vital Sign [HVS]"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2020-09-10T21:56:54.671000+00:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "valueQuantity" : {
    "value" : 2,
    "unit" : "score"
  },
  "hasMember" : [
    {
      "reference" : "Observation/HVS-item-example-88122-7"
    },
    {
      "reference" : "Observation/HVS-item-example-88123-5"
    },
    {
      "reference" : "Observation/HVS-item-example-88124-3"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/hunger-vital-sign-example"
    }
  ]
}

```
