# HVS Item Example 88124-3 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HVS Item Example 88124-3**

## Example Observation: HVS Item Example 88124-3

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: Food insecurity risk

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2020-09-10 21:56:54+0000

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**value**: At risk

**derivedFrom**: [Response to Questionnaire '->Hunger Vital Sign Example' about '->Amy V. Shaw'](QuestionnaireResponse-hunger-vital-sign-example.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "HVS-item-example-88124-3",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "88124-3",
        "display" : "Food insecurity risk [HVS]"
      }
    ],
    "text" : "Food insecurity risk"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2020-09-10T21:56:54.671000+00:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA19952-3",
        "display" : "At risk"
      }
    ],
    "text" : "At risk"
  },
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/hunger-vital-sign-example"
    }
  ]
}

```
