# Evs Panel Example 89574-8 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Evs Panel Example 89574-8**

## Example Observation: Evs Panel Example 89574-8

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: Exercise Vital Sign (EVS)

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-04 03:52:52+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**hasMember**: 

* [Observation How many days per week did you engage in moderate to strenuous physical activity in the last 30 days](Observation-EVS-item-example-89555-7.md)
* [Observation On those days that you engage in moderate to strenuous exercise, how many minutes, on average, do you exercise](Observation-EVS-item-example-68516-4.md)

**derivedFrom**: [Exercise Vital Sign QuestionnaireResponse Example](QuestionnaireResponse-exercise-vital-sign.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "EVS-panel-example-89574-8",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "89574-8",
        "display" : "Exercise Vital Sign (EVS)"
      }
    ],
    "text" : "Exercise Vital Sign (EVS)"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-04T03:52:52.685000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/EVS-item-example-89555-7"
    },
    {
      "reference" : "Observation/EVS-item-example-68516-4"
    }
  ],
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/exercise-vital-sign",
      "display" : "Exercise Vital Sign QuestionnaireResponse Example"
    }
  ]
}

```
