# Audit-C Item Example 68520-6 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Audit-C Item Example 68520-6**

## Example Observation: Audit-C Item Example 68520-6

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: How often do you have 6 or more drinks on 1 occasion?

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2023-08-14 20:40:49+0000

**performer**: [Practitioner Ronald Bone](Practitioner-practitioner-1.md)

**value**: Never

**derivedFrom**: [Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] QuestionnaireResponse Example](QuestionnaireResponse-AUDIT-C.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "AUDIT-C-item-example-68520-6",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "68520-6",
        "display" : "How often do you have 6 or more drinks on 1 occasion"
      }
    ],
    "text" : "How often do you have 6 or more drinks on 1 occasion?"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-08-14T20:40:49.675000+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA6270-8",
        "display" : "Never"
      }
    ],
    "text" : "Never"
  },
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/AUDIT-C",
      "display" : "Alcohol Use Disorder Identification Test - Consumption [AUDIT-C] QuestionnaireResponse Example"
    }
  ]
}

```
