# Ahc-Hrsn Item Observation Example 68517-2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ahc-Hrsn Item Observation Example 68517-2**

## Example Observation: Ahc-Hrsn Item Observation Example 68517-2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: SDOH, Survey

**code**: How many times in the past 12 months have you had 5 or more drinks in a day (males) or 4 or more drinks in a day (females)?

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**effective**: 2022-03-29 22:38:59+0000

**performer**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**value**: Daily or almost daily

**derivedFrom**: Questionnaire Response AHC HRSN Screening Example



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "AHC-HRSN-item-example-68517-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "68517-2",
        "display" : "How many times in the past year have you have X or more drinks in a day"
      }
    ],
    "text" : "How many times in the past 12 months have you had 5 or more drinks in a day (males) or 4 or more drinks in a day (females)?"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2022-03-29T22:38:59.084000+00:00",
  "performer" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA18934-2",
        "display" : "Daily or almost daily"
      }
    ],
    "text" : "Daily or almost daily"
  },
  "derivedFrom" : [
    {
      "display" : "Questionnaire Response AHC HRSN Screening Example"
    }
  ]
}

```
