# 10 Minute Apgar Score Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **10 Minute Apgar Score Example**

## Example Observation: 10 Minute Apgar Score Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: 10 minute Apgar Score

**subject**: [Infant Example (no stated gender), DoB: 2020-06-02 ( Medical Record Number: 1032703 (use: usual, ))](Patient-infant-example.md)

**effective**: 2016-05-18 22:33:22+0000

**performer**: [Ronald Bone](Practitioner-practitioner-1.md)

**value**: 10 score(Details: UCUM code1 = '1')

**derivedFrom**: 

* [10 minute Apgar Heart Rate Example](Observation-10-minute-apgar-heart-rate.md)
* [10 minute Apgar Muscle Tone Example](Observation-10-minute-apgar-muscle-tone.md)
* [10 minute Apgar Reflex Irritability Example](Observation-10-minute-apgar-reflex-irritability.md)
* [10 minute Apgar Respiratory Effort Example](Observation-10-minute-apgar-respiratory-effort.md)
* [10 minute Apgar Color Example](Observation-10-minute-apgar-color.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "10-minute-apgar-score",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ],
      "text" : "Survey"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "9271-8",
        "display" : "10 minute Apgar Score"
      }
    ],
    "text" : "10 minute Apgar Score"
  },
  "subject" : {
    "reference" : "Patient/infant-example"
  },
  "effectiveDateTime" : "2016-05-18T22:33:22Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Ronald Bone"
    }
  ],
  "valueQuantity" : {
    "value" : 10,
    "unit" : "score",
    "system" : "http://unitsofmeasure.org",
    "code" : "1"
  },
  "derivedFrom" : [
    {
      "reference" : "Observation/10-minute-apgar-heart-rate",
      "display" : "10 minute Apgar Heart Rate Example"
    },
    {
      "reference" : "Observation/10-minute-apgar-muscle-tone",
      "display" : "10 minute Apgar Muscle Tone Example"
    },
    {
      "reference" : "Observation/10-minute-apgar-reflex-irritability",
      "display" : "10 minute Apgar Reflex Irritability Example"
    },
    {
      "reference" : "Observation/10-minute-apgar-respiratory-effort",
      "display" : "10 minute Apgar Respiratory Effort Example"
    },
    {
      "reference" : "Observation/10-minute-apgar-color",
      "display" : "10 minute Apgar Color Example"
    }
  ]
}

```
