# 10 Minute Apgar Score Panel Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **10 Minute Apgar Score Panel Example**

## Example Observation: 10 Minute Apgar Score Panel Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: 10 minute Apgar panel

**subject**: [Infant Example (no stated gender), DoB: 2020-06-02 ( Medical Record Number: 1032703 (use: usual, ))](Patient-infant-example.md)

**effective**: 2016-05-18 22:33:22+0000

**performer**: [Ronald Bone](Practitioner-practitioner-1.md)

**hasMember**: 

* [Observation 10 minute Apgar Score](Observation-10-minute-apgar-score.md)
* [Observation 10 minute Apgar Respiratory effort](Observation-10-minute-apgar-respiratory-effort.md)
* [Observation 10 minute Apgar Muscle Tone](Observation-10-minute-apgar-muscle-tone.md)
* [Observation 10 minute Apgar Reflex Irritability](Observation-10-minute-apgar-reflex-irritability.md)
* [Observation 10 minute Apgar Color](Observation-10-minute-apgar-color.md)
* [Observation 10 minute Apgar Heart Rate](Observation-10-minute-apgar-heart-rate.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "10-minute-apgar-score-panel",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ],
      "text" : "Survey"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "48332-1",
        "display" : "10 minute Apgar panel"
      },
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "169922007",
        "display" : "Apgar at 10 minutes"
      }
    ],
    "text" : "10 minute Apgar panel"
  },
  "subject" : {
    "reference" : "Patient/infant-example"
  },
  "effectiveDateTime" : "2016-05-18T22:33:22Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Ronald Bone"
    }
  ],
  "hasMember" : [
    {
      "reference" : "Observation/10-minute-apgar-score"
    },
    {
      "reference" : "Observation/10-minute-apgar-respiratory-effort"
    },
    {
      "reference" : "Observation/10-minute-apgar-muscle-tone"
    },
    {
      "reference" : "Observation/10-minute-apgar-reflex-irritability"
    },
    {
      "reference" : "Observation/10-minute-apgar-color"
    },
    {
      "reference" : "Observation/10-minute-apgar-heart-rate"
    }
  ]
}

```
