# 10 minute Apgar Muscle Tone Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **10 minute Apgar Muscle Tone Example**

## Example Observation: 10 minute Apgar Muscle Tone Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: Apgar muscle tone score

**subject**: [Infant Example (no stated gender), DoB: 2020-06-02 ( Medical Record Number: 1032703 (use: usual, ))](Patient-infant-example.md)

**effective**: 2016-05-18 22:33:22+0000

**performer**: [Ronald Bone](Practitioner-practitioner-1.md)

**value**: 2. Active motion



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "10-minute-apgar-muscle-tone",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ],
      "text" : "Survey"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "32403-8",
        "display" : "10 minute Apgar Muscle Tone"
      }
    ],
    "text" : "Apgar muscle tone score"
  },
  "subject" : {
    "reference" : "Patient/infant-example"
  },
  "effectiveDateTime" : "2016-05-18T22:33:22Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Ronald Bone"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
            "valueDecimal" : 2
          }
        ],
        "system" : "http://loinc.org",
        "code" : "LA6715-2",
        "display" : "Active motion"
      }
    ],
    "text" : "2. Active motion"
  }
}

```
