# 10 minute Apgar Heart Rate Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **10 minute Apgar Heart Rate Example**

## Example Observation: 10 minute Apgar Heart Rate Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Observation Screening Assessment Profileversion: null8.0.1)](StructureDefinition-us-core-observation-screening-assessment.md)

**status**: Final

**category**: Survey

**code**: Apgar respiratory effort score

**subject**: [Infant Example (no stated gender), DoB: 2020-06-02 ( Medical Record Number: 1032703 (use: usual, ))](Patient-infant-example.md)

**effective**: 2016-05-18 22:33:22+0000

**performer**: [Ronald Bone](Practitioner-practitioner-1.md)

**value**: 2. At least 100 beats per minute



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "10-minute-apgar-heart-rate",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ],
      "text" : "Survey"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "32402-0",
        "display" : "10 minute Apgar Heart Rate"
      }
    ],
    "text" : "Apgar respiratory effort score"
  },
  "subject" : {
    "reference" : "Patient/infant-example"
  },
  "effectiveDateTime" : "2016-05-18T22:33:22+00:00",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Ronald Bone"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/ordinalValue",
            "valueDecimal" : 2
          }
        ],
        "system" : "http://loinc.org",
        "code" : "LA6718-6",
        "display" : "At least 100 beats per minute"
      }
    ],
    "text" : "2. At least 100 beats per minute"
  }
}

```
