# MedicationRequest Contained Oral Axid Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Contained Oral Axid Example**

## Example MedicationRequest: MedicationRequest Contained Oral Axid Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "medicationrequest-contained-oral-axid",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|8.0.1"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Medication",
      "id" : "med2",
      "code" : {
        "coding" : [
          {
            "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
            "code" : "582620",
            "display" : "Nizatidine 15 MG/ML Oral Solution [Axid]"
          }
        ],
        "text" : "Nizatidine 15 MG/ML Oral Solution [Axid]"
      }
    }
  ],
  "status" : "active",
  "intent" : "order",
  "medicationReference" : {
    "reference" : "#med2",
    "display" : "Nizatidine 15 MG/ML Oral Solution [Axid]"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "authoredOn" : "2008-04-05",
  "requester" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Ronald Bone, MD"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "51868009",
          "display" : "Ulcer of duodenum (disorder)"
        }
      ],
      "text" : "Active Duodenal Ulcer"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "10 mL bid",
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2008-04-05"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/731000124108",
            "code" : "26643006",
            "display" : "Oral route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 10,
            "unit" : "ml",
            "system" : "http://unitsofmeasure.org",
            "code" : "mL"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "numberOfRepeatsAllowed" : 1,
    "quantity" : {
      "value" : 480,
      "unit" : "mL",
      "system" : "http://unitsofmeasure.org",
      "code" : "mL"
    },
    "expectedSupplyDuration" : {
      "value" : 30,
      "unit" : "days",
      "system" : "http://unitsofmeasure.org",
      "code" : "d"
    }
  }
}

```
