# Medication Dispense Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Dispense Example**

## Example MedicationDispense: Medication Dispense Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core MedicationDispense Profileversion: null8.0.1)](StructureDefinition-us-core-medicationdispense.md)

**status**: Completed

**medication**: Nizatidine 15 MG/ML Oral Solution

**subject**: [Amy Shaw](Patient-example.md)

**context**: [Office Visit](Encounter-example-1.md)

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Holy Healthcare Pharmacy](Organization-holy-healthcare.md) |

**authorizingPrescription**: [MedicationRequest Coded Oral Axid Example](MedicationRequest-medicationrequest-coded-oral-axid.md)

**type**: First Fill - Complete

**quantity**: 480 mL(Details: UCUM codemL = 'mL')

**whenHandedOver**: 2016-12-08 06:38:52+0000

> **dosageInstruction****text**: 10 mL bid**timing**: 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 10 ml(Details: UCUM codemL = 'mL') |




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "medicationdispense-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense|8.0.1"
    ]
  },
  "status" : "completed",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "476872",
        "display" : "Nizatidine 15 MG/ML Oral Solution"
      }
    ],
    "text" : "Nizatidine 15 MG/ML Oral Solution"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "context" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Organization/holy-healthcare",
        "display" : "Holy Healthcare Pharmacy"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/medicationrequest-coded-oral-axid",
      "display" : "MedicationRequest Coded Oral Axid Example"
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "code" : "FFC",
        "display" : "First Fill - Complete"
      }
    ]
  },
  "quantity" : {
    "value" : 480,
    "unit" : "mL",
    "system" : "http://unitsofmeasure.org",
    "code" : "mL"
  },
  "whenHandedOver" : "2016-12-08T06:38:52Z",
  "dosageInstruction" : [
    {
      "text" : "10 mL bid",
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2008-04-05"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 10,
            "unit" : "ml",
            "system" : "http://unitsofmeasure.org",
            "code" : "mL"
          }
        }
      ]
    }
  ]
}

```
