# Chest Xray Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chest Xray Example**

## Example Media: Chest Xray Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**status**: Completed

**type**: Image

**modality**: Plain X-ray of chest (procedure)

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**created**: 2019-02-04 19:43:30+0000

**issued**: 2019-02-04 19:43:30+0000

> **content**
> **id**a1
**contentType**: image/jpeg**url**:[http://example.org/fhir/Binary/A12345](http://example.org/fhir/Binary/A12345)**creation**: 2019-02-04 19:43:30+0000



## Resource Content

```json
{
  "resourceType" : "Media",
  "id" : "chest-xray",
  "status" : "completed",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/media-type",
        "code" : "image",
        "display" : "Image"
      }
    ]
  },
  "modality" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "399208008",
        "display" : "Plain X-ray of chest (procedure)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "createdDateTime" : "2019-02-04T19:43:30.000Z",
  "issued" : "2019-02-04T19:43:30.000Z",
  "content" : {
    "id" : "a1",
    "contentType" : "image/jpeg",
    "url" : "http://example.org/fhir/Binary/A12345",
    "creation" : "2019-02-04T19:43:30.000Z"
  }
}

```
