# Hospital Location - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hospital Location**

## Example Location: Hospital Location

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Location Profileversion: null8.0.1)](StructureDefinition-us-core-location.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/1234567893

**status**: Active

**name**: Holy Family Hospital

**type**: Hospital

**telecom**: ph: 9786870156

**address**: 70 EAST ST METHUEN MA 01844 US 

**managingOrganization**: [Holy Healthcare](Organization-holy-healthcare.md)



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "hospital",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|8.0.1"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1234567893"
    }
  ],
  "status" : "active",
  "name" : "Holy Family Hospital",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "HOSP",
          "display" : "Hospital"
        },
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/731000124108",
          "code" : "22232009",
          "display" : "Hospital"
        },
        {
          "system" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html",
          "code" : "1120-5",
          "display" : "Medical Clinic"
        }
      ],
      "text" : "Hospital"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "9786870156"
    }
  ],
  "address" : {
    "line" : ["70 EAST ST"],
    "city" : "METHUEN",
    "state" : "MA",
    "postalCode" : "01844",
    "country" : "US"
  },
  "managingOrganization" : {
    "reference" : "Organization/holy-healthcare",
    "display" : "Holy Healthcare"
  }
}

```
