# US Core Version 3.1.1 Model Definition - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Version 3.1.1 Model Definition**

## Library: US Core Version 3.1.1 Model Definition 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/Library/uscore-3.1.1-model-definition | *Version*:8.0.1 |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:USCoreVersion311ModelDefinition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.28.1 | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | |

 
Model definition for US Core Version 3.1.1 Model 

* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Id:**
  * ?: uscore-3.1.1-model-definition
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Version:**
  * ?: 8.0.1
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Url:**
  * ?: [US Core Version 3.1.1 Model Definition](Library-uscore-3.1.1-model-definition.md)
* * **Content:**application/xml: ````Encoded data (200396 characters)````: ****
  * ?: urn:oid:2.16.840.1.113883.4.642.40.2.28.1
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Date:**
  * ?: 2025-05-07
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Publisher:**
  * ?: HL7 International / Cross-Group Projects
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Description:**
  * ?: Model definition for US Core Version 3.1.1 Model
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Jurisdiction:**
  * ?: US
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Topic:**
  * ?: 
* * **Content:**application/xml: ````Encoded data (200396 characters)````: **Copyright:**
  * ?: Used by permission of HL7 International, all rights reserved Creative Commons License



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "uscore-3.1.1-model-definition",
  "url" : "http://hl7.org/fhir/Library/uscore-3.1.1-model-definition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.28.1"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreVersion311ModelDefinition",
  "title" : "US Core Version 3.1.1 Model Definition",
  "status" : "active",
  "experimental" : false,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "model-definition"
      }
    ]
  },
  "date" : "2025-05-07",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Model definition for US Core Version 3.1.1 Model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "lastReviewDate" : "2025-05-07",
  "topic" : [
    {
      "text" : "US Core Version 3.1.1"
    }
  ],
  "content" : [
    {
      "contentType" : "application/xml",
      "data" : "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"
    }
  ]
}

```
