# US Core ImplementationGuide Resource - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **US Core ImplementationGuide Resource**

## US Core ImplementationGuide Resource

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

| | |
| :--- | :--- |
| **Official URL**: http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core | **Version**: 8.0.1 |
| **NPM package name**: hl7.fhir.us.core | **ComputableName**: USCore |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License |   |

The US Core Implementation Guide is based on FHIR Version R4 and defines the minimum conformance requirements for accessing patient data. The Argonaut pilot implementations, ONC 2015 Edition Common Clinical Data Set (CCDS), and ONC U.S. Core Data for Interoperability (USCDI) v1 provided the requirements for this guide. The prior Argonaut search and vocabulary requirements, based on FHIR DSTU2, are updated in this guide to support FHIR Version R4. This guide was used as the basis for further testing and guidance by the Argonaut Project Team to provide additional content and guidance specific to Data Query Access for purpose of ONC Certification testing. These profiles are the foundation for future US Realm FHIR implementation guides. In addition to Argonaut, they are used by DAF-Research, QI-Core, and CIMI. Under the guidance of HL7 and the HL7 US Realm Steering Committee, the content will expand in future versions to meet the needs specific to the US Realm. These requirements were originally developed, balloted, and published in FHIR DSTU2 as part of the Office of the National Coordinator for Health Information Technology (ONC) sponsored Data Access Framework (DAF) project. For more information on how DAF became US Core see the US Core change notes.

* [XML](ImplementationGuide-hl7.fhir.us.core.xml)
* [JSON](ImplementationGuide-hl7.fhir.us.core.json)

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.core.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.core.r4b)](package.r4b.tgz) are available. 

### IG Dependencies

This IG Contains the following dependencies on other IGs.





### Global Profiles

*There are no Global profiles defined*

### Copyrights

This publication includes IP covered under the following statements.

* © Copyright 2022 American Medical Association

* [NUCC Provider Taxonomy](http://tx.fhir.org/r4/ValueSet/nucc-provider-taxonomy): [Bundle/66c8856b-ba11-4876-8aa8-467aad8c11a2](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md) and [USCorePractitionerRoleProfile](StructureDefinition-us-core-practitionerrole.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.5.0/CodeSystem-ISO3166Part1.html): [AUDIT_C](Questionnaire-AUDIT-C.md), [ExerciseVitalSign](Questionnaire-exercise-vital-sign.md)...Show 216 more,[HungerVitalSignExample](Questionnaire-hunger-vital-sign-example.md),[NarrativeStatus](ValueSet-us-core-narrative-status.md),[PHQ9Example](Questionnaire-phq-9-example.md),[PRAPAREExample](Questionnaire-prapare-example.md),[TAPS](Questionnaire-TAPS.md),[USCDIRequirement](StructureDefinition-uscdi-requirement.md),[USCore](index.md),[USCoreADIDocumentReferenceProfile](StructureDefinition-us-core-adi-documentreference.md),[USCoreAllergyIntolerance](StructureDefinition-us-core-allergyintolerance.md),[USCoreAllergyintoleranceClinicalStatus](SearchParameter-us-core-allergyintolerance-clinical-status.md),[USCoreAllergyintolerancePatient](SearchParameter-us-core-allergyintolerance-patient.md),[USCoreAuthenticationTimeExtension](StructureDefinition-us-core-authentication-time.md),[USCoreAverageBloodPressureProfile](StructureDefinition-us-core-average-blood-pressure.md),[USCoreBMIProfile](StructureDefinition-us-core-bmi.md),[USCoreBirthSexExtension](StructureDefinition-us-core-birthsex.md),[USCoreBloodPressureProfile](StructureDefinition-us-core-blood-pressure.md),[USCoreBodyHeightProfile](StructureDefinition-us-core-body-height.md),[USCoreBodyTemperatureProfile](StructureDefinition-us-core-body-temperature.md),[USCoreBodyWeightProfile](StructureDefinition-us-core-body-weight.md),[USCoreCareExperiencePreferenceProfile](StructureDefinition-us-core-care-experience-preference.md),[USCoreCarePlanCategoryExtensionCodes](CodeSystem-careplan-category.md),[USCoreCarePlanProfile](StructureDefinition-us-core-careplan.md),[USCoreCareTeam](StructureDefinition-us-core-careteam.md),[USCoreCareTeamRole](SearchParameter-us-core-careteam-role.md),[USCoreCareplanCategory](SearchParameter-us-core-careplan-category.md),[USCoreCareplanDate](SearchParameter-us-core-careplan-date.md),[USCoreCareplanPatient](SearchParameter-us-core-careplan-patient.md),[USCoreCareplanStatus](SearchParameter-us-core-careplan-status.md),[USCoreCareteamPatient](SearchParameter-us-core-careteam-patient.md),[USCoreCareteamStatus](SearchParameter-us-core-careteam-status.md),[USCoreCategory](CodeSystem-us-core-category.md),[USCoreClinicalNoteType](ValueSet-us-core-clinical-note-type.md),[USCoreClinicalResultObservationCategory](ValueSet-us-core-clinical-result-observation-category.md),[USCoreConditionAbatementDate](SearchParameter-us-core-condition-abatement-date.md),[USCoreConditionAssertedDate](SearchParameter-us-core-condition-asserted-date.md),[USCoreConditionCategory](SearchParameter-us-core-condition-category.md),[USCoreConditionCategoryExtensionCodes](CodeSystem-condition-category.md),[USCoreConditionClinicalStatus](SearchParameter-us-core-condition-clinical-status.md),[USCoreConditionCode](SearchParameter-us-core-condition-code.md),[USCoreConditionCodes](ValueSet-us-core-condition-code.md),[USCoreConditionCodesCurrent](ValueSet-us-core-condition-code-current.md),[USCoreConditionEncounter](SearchParameter-us-core-condition-encounter.md),[USCoreConditionEncounterDiagnosisProfile](StructureDefinition-us-core-condition-encounter-diagnosis.md),[USCoreConditionLastUpdated](SearchParameter-us-core-condition-lastupdated.md),[USCoreConditionOnsetDate](SearchParameter-us-core-condition-onset-date.md),[USCoreConditionPatient](SearchParameter-us-core-condition-patient.md),[USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md),[USCoreConditionRecordedDate](SearchParameter-us-core-condition-recorded-date.md),[USCoreCoveragePatient](SearchParameter-us-core-coverage-patient.md),[USCoreCoverageProfile](StructureDefinition-us-core-coverage.md),[USCoreDevicePatient](SearchParameter-us-core-device-patient.md),[USCoreDeviceStatus](SearchParameter-us-core-device-status.md),[USCoreDeviceType](SearchParameter-us-core-device-type.md),[USCoreDiagnosticReportCategory](ValueSet-us-core-diagnosticreport-category.md),[USCoreDiagnosticReportProfileLaboratoryReporting](StructureDefinition-us-core-diagnosticreport-lab.md),[USCoreDiagnosticReportProfileNoteExchange](StructureDefinition-us-core-diagnosticreport-note.md),[USCoreDiagnosticreportCategory](SearchParameter-us-core-diagnosticreport-category.md),[USCoreDiagnosticreportCode](SearchParameter-us-core-diagnosticreport-code.md),[USCoreDiagnosticreportDate](SearchParameter-us-core-diagnosticreport-date.md),[USCoreDiagnosticreportLastUpdated](SearchParameter-us-core-diagnosticreport-lastupdated.md),[USCoreDiagnosticreportPatient](SearchParameter-us-core-diagnosticreport-patient.md),[USCoreDiagnosticreportStatus](SearchParameter-us-core-diagnosticreport-status.md),[USCoreDirectEmailExtension](StructureDefinition-us-core-direct.md),[USCoreDocumentReferenceCategory](ValueSet-us-core-documentreference-category.md),[USCoreDocumentReferenceProfile](StructureDefinition-us-core-documentreference.md),[USCoreDocumentReferenceType](ValueSet-us-core-documentreference-type.md),[USCoreDocumentReferencesCategoryCodes](CodeSystem-us-core-documentreference-category.md),[USCoreDocumentreferenceCategory](SearchParameter-us-core-documentreference-category.md),[USCoreDocumentreferenceDate](SearchParameter-us-core-documentreference-date.md),[USCoreDocumentreferenceId](SearchParameter-us-core-documentreference-id.md),[USCoreDocumentreferencePatient](SearchParameter-us-core-documentreference-patient.md),[USCoreDocumentreferencePeriod](SearchParameter-us-core-documentreference-period.md),[USCoreDocumentreferenceStatus](SearchParameter-us-core-documentreference-status.md),[USCoreDocumentreferenceType](SearchParameter-us-core-documentreference-type.md),[USCoreEncounterClass](SearchParameter-us-core-encounter-class.md),[USCoreEncounterDate](SearchParameter-us-core-encounter-date.md),[USCoreEncounterDischargeDisposition](SearchParameter-us-core-encounter-discharge-disposition.md),[USCoreEncounterId](SearchParameter-us-core-encounter-id.md),[USCoreEncounterIdentifier](SearchParameter-us-core-encounter-identifier.md),[USCoreEncounterLastUpdated](SearchParameter-us-core-encounter-lastupdated.md),[USCoreEncounterLocation](SearchParameter-us-core-encounter-location.md),[USCoreEncounterPatient](SearchParameter-us-core-encounter-patient.md),[USCoreEncounterProfile](StructureDefinition-us-core-encounter.md),[USCoreEncounterStatus](SearchParameter-us-core-encounter-status.md),[USCoreEncounterType](SearchParameter-us-core-encounter-type.md),[USCoreEthnicity](SearchParameter-us-core-ethnicity.md),[USCoreEthnicityExtension](StructureDefinition-us-core-ethnicity.md),[USCoreExtensionQuestionnaireUri](StructureDefinition-us-core-extension-questionnaire-uri.md),[USCoreFetchDocumentReference](OperationDefinition-docref.md),[USCoreGenderIdentityExtension](StructureDefinition-us-core-genderIdentity.md),[USCoreGoalCodes](ValueSet-us-core-goal-description.md),[USCoreGoalDescription](SearchParameter-us-core-goal-description.md),[USCoreGoalLifecycleStatus](SearchParameter-us-core-goal-lifecycle-status.md),[USCoreGoalPatient](SearchParameter-us-core-goal-patient.md),[USCoreGoalProfile](StructureDefinition-us-core-goal.md),[USCoreGoalTargetDate](SearchParameter-us-core-goal-target-date.md),[USCoreHeadCircumferenceProfile](StructureDefinition-us-core-head-circumference.md),[USCoreHeartRateProfile](StructureDefinition-us-core-heart-rate.md),[USCoreImmunizationDate](SearchParameter-us-core-immunization-date.md),[USCoreImmunizationPatient](SearchParameter-us-core-immunization-patient.md),[USCoreImmunizationProfile](StructureDefinition-us-core-immunization.md),[USCoreImmunizationStatus](SearchParameter-us-core-immunization-status.md),[USCoreImplantableDeviceProfile](StructureDefinition-us-core-implantable-device.md),[USCoreIndividualSexExtension](StructureDefinition-us-core-individual-sex.md),[USCoreInterpreterNeededExtension](StructureDefinition-us-core-interpreter-needed.md),[USCoreJurisdictionExtension](StructureDefinition-us-core-jurisdiction.md),[USCoreLaboratoryResultObservationProfile](StructureDefinition-us-core-observation-lab.md),[USCoreLaboratoryTestCodes](ValueSet-us-core-laboratory-test-codes.md),[USCoreLocationAddress](SearchParameter-us-core-location-address.md),[USCoreLocationAddressCity](SearchParameter-us-core-location-address-city.md),[USCoreLocationAddressPostalcode](SearchParameter-us-core-location-address-postalcode.md),[USCoreLocationAddressState](SearchParameter-us-core-location-address-state.md),[USCoreLocationName](SearchParameter-us-core-location-name.md),[USCoreLocationProfile](StructureDefinition-us-core-location.md),[USCoreMedicationAdherenceExtension](StructureDefinition-us-core-medication-adherence.md),[USCoreMedicationDispenseProfile](StructureDefinition-us-core-medicationdispense.md),[USCoreMedicationProfile](StructureDefinition-us-core-medication.md),[USCoreMedicationRequestProfile](StructureDefinition-us-core-medicationrequest.md),[USCoreMedicationdispensePatient](SearchParameter-us-core-medicationdispense-patient.md),[USCoreMedicationdispenseStatus](SearchParameter-us-core-medicationdispense-status.md),[USCoreMedicationdispenseType](SearchParameter-us-core-medicationdispense-type.md),[USCoreMedicationrequestAuthoredon](SearchParameter-us-core-medicationrequest-authoredon.md),[USCoreMedicationrequestEncounter](SearchParameter-us-core-medicationrequest-encounter.md),[USCoreMedicationrequestIntent](SearchParameter-us-core-medicationrequest-intent.md),[USCoreMedicationrequestPatient](SearchParameter-us-core-medicationrequest-patient.md),[USCoreMedicationrequestStatus](SearchParameter-us-core-medicationrequest-status.md),[USCoreNonLaboratoryCodes](ValueSet-us-core-diagnosticreport-report-and-note-codes.md),[USCoreObservationADIDocumentationProfile](StructureDefinition-us-core-observation-adi-documentation.md),[USCoreObservationCategory](SearchParameter-us-core-observation-category.md),[USCoreObservationClinicalResultProfile](StructureDefinition-us-core-observation-clinical-result.md),[USCoreObservationCode](SearchParameter-us-core-observation-code.md),[USCoreObservationDate](SearchParameter-us-core-observation-date.md),[USCoreObservationLastUpdated](SearchParameter-us-core-observation-lastupdated.md),[USCoreObservationOccupationProfile](StructureDefinition-us-core-observation-occupation.md),[USCoreObservationPatient](SearchParameter-us-core-observation-patient.md),[USCoreObservationPregnancyIntentProfile](StructureDefinition-us-core-observation-pregnancyintent.md),[USCoreObservationPregnancyStatusProfile](StructureDefinition-us-core-observation-pregnancystatus.md),[USCoreObservationScreeningAssessmentProfile](StructureDefinition-us-core-observation-screening-assessment.md),[USCoreObservationSexualOrientationProfile](StructureDefinition-us-core-observation-sexual-orientation.md),[USCoreObservationSmokingStatusStatus](ValueSet-us-core-observation-smoking-status-status.md),[USCoreObservationStatus](SearchParameter-us-core-observation-status.md),[USCoreOrganizationAddress](SearchParameter-us-core-organization-address.md),[USCoreOrganizationName](SearchParameter-us-core-organization-name.md),[USCoreOrganizationProfile](StructureDefinition-us-core-organization.md),[USCorePatientBirthdate](SearchParameter-us-core-patient-birthdate.md),[USCorePatientDeathDate](SearchParameter-us-core-patient-death-date.md),[USCorePatientFamily](SearchParameter-us-core-patient-family.md),[USCorePatientGiven](SearchParameter-us-core-patient-given.md),[USCorePatientId](SearchParameter-us-core-patient-id.md),[USCorePatientIdentifier](SearchParameter-us-core-patient-identifier.md),[USCorePatientName](SearchParameter-us-core-patient-name.md),[USCorePatientProfile](StructureDefinition-us-core-patient.md),[USCorePediatricBMIforAgeObservationProfile](StructureDefinition-pediatric-bmi-for-age.md),[USCorePediatricHeadOccipitalFrontalCircumferencePercentileProfile](StructureDefinition-head-occipital-frontal-circumference-percentile.md),[USCorePediatricWeightForHeightObservationProfile](StructureDefinition-pediatric-weight-for-height.md),[USCorePractitionerId](SearchParameter-us-core-practitioner-id.md),[USCorePractitionerIdentifier](SearchParameter-us-core-practitioner-identifier.md),[USCorePractitionerName](SearchParameter-us-core-practitioner-name.md),[USCorePractitionerProfile](StructureDefinition-us-core-practitioner.md),[USCorePractitionerRoleProfile](StructureDefinition-us-core-practitionerrole.md),[USCorePractitionerrolePractitioner](SearchParameter-us-core-practitionerrole-practitioner.md),[USCorePractitionerroleSpecialty](SearchParameter-us-core-practitionerrole-specialty.md),[USCoreProblemOrHealthConcern](ValueSet-us-core-problem-or-health-concern.md),[USCoreProcedureCode](SearchParameter-us-core-procedure-code.md),[USCoreProcedureCodes](ValueSet-us-core-procedure-code.md),[USCoreProcedureDate](SearchParameter-us-core-procedure-date.md),[USCoreProcedurePatient](SearchParameter-us-core-procedure-patient.md),[USCoreProcedureProfile](StructureDefinition-us-core-procedure.md),[USCoreProcedureStatus](SearchParameter-us-core-procedure-status.md),[USCoreProvenance](StructureDefinition-us-core-provenance.md),[USCoreProvenancePaticipantTypeCodes](ValueSet-us-core-provenance-participant-type.md),[USCoreProvenancePaticipantTypeExtensionCodes](CodeSystem-us-core-provenance-participant-type.md),[USCorePulseOximetryProfile](StructureDefinition-us-core-pulse-oximetry.md),[USCoreQuestionnaireResponseProfile](StructureDefinition-us-core-questionnaireresponse.md),[USCoreQuestionnaireresponseAuthored](SearchParameter-us-core-questionnaireresponse-authored.md),[USCoreQuestionnaireresponseId](SearchParameter-us-core-questionnaireresponse-id.md),[USCoreQuestionnaireresponsePatient](SearchParameter-us-core-questionnaireresponse-patient.md),[USCoreQuestionnaireresponseQuestionnaire](SearchParameter-us-core-questionnaireresponse-questionnaire.md),[USCoreQuestionnaireresponseStatus](SearchParameter-us-core-questionnaireresponse-status.md),[USCoreRace](SearchParameter-us-core-race.md),[USCoreRaceExtension](StructureDefinition-us-core-race.md),[USCoreRelatedPersonProfile](StructureDefinition-us-core-relatedperson.md),[USCoreRelatedpersonId](SearchParameter-us-core-relatedperson-id.md),[USCoreRelatedpersonName](SearchParameter-us-core-relatedperson-name.md),[USCoreRelatedpersonPatient](SearchParameter-us-core-relatedperson-patient.md),[USCoreRespiratoryRateProfile](StructureDefinition-us-core-respiratory-rate.md),[USCoreScreeningAssessmentConditionCategory](ValueSet-us-core-screening-assessment-condition-category.md),[USCoreScreeningAssessmentObservationCategory](ValueSet-us-core-screening-assessment-observation-category.md),[USCoreScreeningAssessmentObservationMaximumCategory](ValueSet-us-core-screening-assessment-observation-maximum-category.md),[USCoreServiceRequestCategoryCodes](ValueSet-us-core-servicerequest-category.md),[USCoreServiceRequestProfile](StructureDefinition-us-core-servicerequest.md),[USCoreServicerequestAuthored](SearchParameter-us-core-servicerequest-authored.md),[USCoreServicerequestCategory](SearchParameter-us-core-servicerequest-category.md),[USCoreServicerequestCode](SearchParameter-us-core-servicerequest-code.md),[USCoreServicerequestId](SearchParameter-us-core-servicerequest-id.md),[USCoreServicerequestPatient](SearchParameter-us-core-servicerequest-patient.md),[USCoreServicerequestStatus](SearchParameter-us-core-servicerequest-status.md),[USCoreSexExtension](StructureDefinition-us-core-sex.md),[USCoreSimpleObservationCategory](ValueSet-us-core-simple-observation-category.md),[USCoreSimpleObservationProfile](StructureDefinition-us-core-simple-observation.md),[USCoreSmokingStatusProfile](StructureDefinition-us-core-smokingstatus.md),[USCoreSpecimenCondition](ValueSet-us-core-specimen-condition.md),[USCoreSpecimenId](SearchParameter-us-core-specimen-id.md),[USCoreSpecimenPatient](SearchParameter-us-core-specimen-patient.md),[USCoreSpecimenProfile](StructureDefinition-us-core-specimen.md),[USCoreTreatmentInterventionPreferenceProfile](StructureDefinition-us-core-treatment-intervention-preference.md),[USCoreTribalAffiliationExtension](StructureDefinition-us-core-tribal-affiliation.md),[USCoreVersion311ModelDefinition](Library-uscore-3.1.1-model-definition.md),[USCoreVersion400ModelDefinition](Library-uscore-4.0.0-model-definition.md),[USCoreVersion501ModelDefinition](Library-uscore-5.0.1-model-definition.md),[USCoreVersion610ModelDefinition](Library-uscore-6.1.0-model-definition.md),[USCoreVersion700ModelDefinition](Library-uscore-7.0.0-model-definition.md),[USCoreVersion801ModelDefinition](Library-uscore-8.0.1-model-definition.md),[USCoreVitalSignsProfile](StructureDefinition-us-core-vital-signs.md),[UsCoreClientCapabilityStatement](CapabilityStatement-us-core-client.md)and[UsCoreServerCapabilityStatement](CapabilityStatement-us-core-server.md)


* Licensing information can be found [here](https://www.nubc.org/license) These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA’s licensing manager, Tim Carlson, at 312.893.6816 or tcarlson@aha.org

* [AHA NUBC Patient Discharge Status Codes](http://terminology.hl7.org/5.5.0/CodeSystem-AHANUBCPatientDischargeStatus.html): [USCoreEncounterProfile](StructureDefinition-us-core-encounter.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission. For information and exceptions regarding use of CDC material please see [[https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html)](https://www.cdc.gov/other/agencymaterials.html) 

* [Vaccine Administered Code Set (CVX)](http://terminology.hl7.org/5.5.0/CodeSystem-CVX.html): [Immunization/imm-1](Immunization-imm-1.md) and [USCoreImmunizationProfile](StructureDefinition-us-core-immunization.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.For information and exceptions regarding use of CDC material please see [https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html).

* [CDC Race and Ethnicity](http://terminology.hl7.org/5.5.0/CodeSystem-CDCREC.html): [Patient/child-example](Patient-child-example.md), [Patient/deceased-example](Patient-deceased-example.md)...Show 4 more,[Patient/example](Patient-example.md),[Patient/infant-example](Patient-infant-example.md),[USCoreEthnicityExtension](StructureDefinition-us-core-ethnicity.md)and[USCoreRaceExtension](StructureDefinition-us-core-race.md)


* Some content from IHE® Copyright © 2015 [IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property) .

* [IHE Format Code set for use with Document Sharing](http://tx.fhir.org/r4/ValueSet/formatcode): [Bundle/66c8856b-ba11-4876-8aa8-467aad8c11a2](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md), [DocumentReference/episode-summary](DocumentReference-episode-summary.md), [Saint Luke's Hospital of Kansas City](Organization-saint-luke-w-endpoint.md), [USCoreADIDocumentReferenceProfile](StructureDefinition-us-core-adi-documentreference.md) and [USCoreDocumentReferenceProfile](StructureDefinition-us-core-documentreference.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html): [AUDIT_C](Questionnaire-AUDIT-C.md), [ExerciseVitalSign](Questionnaire-exercise-vital-sign.md)...Show 61 more,[MedicationDispense/medicationdispense-example](MedicationDispense-medicationdispense-example.md),[MedicationRequest/medicationrequest-coded-oral-axid](MedicationRequest-medicationrequest-coded-oral-axid.md),[MedicationRequest/medicationrequest-contained-oral-axid](MedicationRequest-medicationrequest-contained-oral-axid.md),[MedicationRequest/medicationrequest-referenced-oral-axid](MedicationRequest-medicationrequest-referenced-oral-axid.md),[Observation/10-minute-apgar-score](Observation-10-minute-apgar-score.md),[Observation/AUDIT-C-item-example-68517-2](Observation-AUDIT-C-item-example-68517-2.md),[Observation/AUDIT-C-item-example-75626-2](Observation-AUDIT-C-item-example-75626-2.md),[Observation/average-blood-pressure](Observation-average-blood-pressure.md),[Observation/blood-pressure](Observation-blood-pressure.md),[Observation/bmi](Observation-bmi.md),[Observation/bp-data-absent](Observation-bp-data-absent.md),[Observation/capillary-refill-time-nail-bed](Observation-capillary-refill-time-nail-bed.md),[Observation/cbc-erythrocytes](Observation-cbc-erythrocytes.md),[Observation/cbc-hematocrit](Observation-cbc-hematocrit.md),[Observation/cbc-hemoglobin](Observation-cbc-hemoglobin.md),[Observation/cbc-leukocytes](Observation-cbc-leukocytes.md),[Observation/cbc-mch](Observation-cbc-mch.md),[Observation/cbc-mchc](Observation-cbc-mchc.md),[Observation/cbc-mcv](Observation-cbc-mcv.md),[Observation/cbc-platelets](Observation-cbc-platelets.md),[Observation/dxa-femur-l-armass-bmd](Observation-dxa-femur-l-armass-bmd.md),[Observation/dxa-femur-l-t-score-bmd](Observation-dxa-femur-l-t-score-bmd.md),[Observation/dxa-femur-l-z-score-bmd](Observation-dxa-femur-l-z-score-bmd.md),[Observation/dxa-hip-l-armass-bmd](Observation-dxa-hip-l-armass-bmd.md),[Observation/dxa-hip-l-t-score-bmd](Observation-dxa-hip-l-t-score-bmd.md),[Observation/dxa-hip-l-z-score-bmd](Observation-dxa-hip-l-z-score-bmd.md),[Observation/exercise-per-day](Observation-exercise-per-day.md),[Observation/exercise-per-week](Observation-exercise-per-week.md),[Observation/head-circumference](Observation-head-circumference.md),[Observation/heart-rate](Observation-heart-rate.md),[Observation/height](Observation-height.md),[Observation/length](Observation-length.md),[Observation/ofc-percentile](Observation-ofc-percentile.md),[Observation/oxygen-saturation](Observation-oxygen-saturation.md),[Observation/p-r-interval-ekg-lead](Observation-p-r-interval-ekg-lead.md),[Observation/pack-years-example](Observation-pack-years-example.md),[Observation/pediatric-bmi-example](Observation-pediatric-bmi-example.md),[Observation/pediatric-wt-example](Observation-pediatric-wt-example.md),[Observation/q-t-interval-ekg-lead](Observation-q-t-interval-ekg-lead.md),[Observation/qrs-dur-ekg-lead](Observation-qrs-dur-ekg-lead.md),[Observation/respiratory-rate](Observation-respiratory-rate.md),[Observation/satO2-fiO2](Observation-satO2-fiO2.md),[Observation/serum-bun](Observation-serum-bun.md),[Observation/serum-calcium](Observation-serum-calcium.md),[Observation/serum-chloride](Observation-serum-chloride.md),[Observation/serum-co2](Observation-serum-co2.md),[Observation/serum-creatinine](Observation-serum-creatinine.md),[Observation/serum-glucose](Observation-serum-glucose.md),[Observation/serum-potassium](Observation-serum-potassium.md),[Observation/serum-sodium](Observation-serum-sodium.md),[Observation/temperature](Observation-temperature.md),[Observation/urobilinogen](Observation-urobilinogen.md),[Observation/weight](Observation-weight.md),[USCoreBodyHeightProfile](StructureDefinition-us-core-body-height.md),[USCoreBodyTemperatureProfile](StructureDefinition-us-core-body-temperature.md),[USCoreBodyWeightProfile](StructureDefinition-us-core-body-weight.md),[USCoreHeadCircumferenceProfile](StructureDefinition-us-core-head-circumference.md),[USCoreMedicationDispenseProfile](StructureDefinition-us-core-medicationdispense.md),[USCoreMedicationRequestProfile](StructureDefinition-us-core-medicationrequest.md),[USCoreSmokingStatusProfile](StructureDefinition-us-core-smokingstatus.md)and[USCoreVitalSignsProfile](StructureDefinition-us-core-vital-signs.md)


* The information in the various pages of the WHO web site is issued by the World Health Organization for general distribution. The information presented is protected under the Berne Convention for the Protection of Literature and Artistic works, under other international conventions and under national laws on copyright and neighbouring rights. Extracts of the information in the web site may be reviewed, reproduced or translated for research or private study but not for sale or for use in conjunction with commercial purposes. Any use of information in the web site should be accompanied by an acknowledgment of WHO as the source, citing the uniform resource locator (URL) of the article. Reproduction or translation of substantial portions of the web site, or any use other than for educational or other non-commercial purposes, require explicit, prior authorization in writing. Applications and enquiries should be addressed to the programme responsible for the page used. The designations employed and the presentation of the material in this publication do not imply the expression of any opinion whatsoever on the part of the World Health Organization concerning the legal status of any country, territory, city or area or of its authorities, or concerning the delimitation of its frontiers or boundaries. Dotted and dashed lines on maps represent approximate border lines for which there may not yet be full agreement. The mention of specific companies or of certain manufacturers' products does not imply that they are endorsed or recommended by the World Health Organization in preference to others of a similar nature that are not mentioned. Errors and omissions excepted, the names of proprietary products are distinguished by initial capital letters. The World Health Organization does not warrant that the information contained in the web site is complete and correct and shall not be liable whatsoever for any damages incurred as a result of its use.

* [ICD-9-CM](http://tx.fhir.org/r4/ValueSet/icd-9-cm): [USCoreConditionCodes](ValueSet-us-core-condition-code.md), [USCoreConditionEncounterDiagnosisProfile](StructureDefinition-us-core-condition-encounter-diagnosis.md)...Show 4 more,[USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md),[USCoreMedicationRequestProfile](StructureDefinition-us-core-medicationrequest.md),[USCoreProcedureProfile](StructureDefinition-us-core-procedure.md)and[USCoreServiceRequestProfile](StructureDefinition-us-core-servicerequest.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html): [AUDIT_C](Questionnaire-AUDIT-C.md), [Bundle/docref-example-1](Bundle-docref-example-1.md)...Show 201 more,[Bundle/docref-example-2](Bundle-docref-example-2.md),[DiagnosticReport/bone-density-report](DiagnosticReport-bone-density-report.md),[DiagnosticReport/cardiology-report](DiagnosticReport-cardiology-report.md),[DiagnosticReport/cbc](DiagnosticReport-cbc.md),[DiagnosticReport/chest-xray-report](DiagnosticReport-chest-xray-report.md),[DiagnosticReport/metabolic-panel](DiagnosticReport-metabolic-panel.md),[DocumentReference/adi-dnr](DocumentReference-adi-dnr.md),[DocumentReference/discharge-summary](DocumentReference-discharge-summary.md),[DocumentReference/episode-summary](DocumentReference-episode-summary.md),[DocumentReference/living-will](DocumentReference-living-will.md),[DocumentReference/polst](DocumentReference-polst.md),[ExerciseVitalSign](Questionnaire-exercise-vital-sign.md),[HungerVitalSignExample](Questionnaire-hunger-vital-sign-example.md),[Observation/10-minute-apgar-color](Observation-10-minute-apgar-color.md),[Observation/10-minute-apgar-heart-rate](Observation-10-minute-apgar-heart-rate.md),[Observation/10-minute-apgar-muscle-tone](Observation-10-minute-apgar-muscle-tone.md),[Observation/10-minute-apgar-reflex-irritability](Observation-10-minute-apgar-reflex-irritability.md),[Observation/10-minute-apgar-respiratory-effort](Observation-10-minute-apgar-respiratory-effort.md),[Observation/10-minute-apgar-score](Observation-10-minute-apgar-score.md),[Observation/10-minute-apgar-score-panel](Observation-10-minute-apgar-score-panel.md),[Observation/ADI-example](Observation-ADI-example.md),[Observation/AHC-HRSN-item-example-68517-2](Observation-AHC-HRSN-item-example-68517-2.md),[Observation/AUDIT-C-item-example-68517-2](Observation-AUDIT-C-item-example-68517-2.md),[Observation/AUDIT-C-item-example-68519-8](Observation-AUDIT-C-item-example-68519-8.md),[Observation/AUDIT-C-item-example-68520-6](Observation-AUDIT-C-item-example-68520-6.md),[Observation/AUDIT-C-item-example-75626-2](Observation-AUDIT-C-item-example-75626-2.md),[Observation/AUDIT-C-panel-example-72109-2](Observation-AUDIT-C-panel-example-72109-2.md),[Observation/EVS-item-example-68516-4](Observation-EVS-item-example-68516-4.md),[Observation/EVS-item-example-89555-7](Observation-EVS-item-example-89555-7.md),[Observation/EVS-panel-example-89574-8](Observation-EVS-panel-example-89574-8.md),[Observation/HVS-item-example-88122-7](Observation-HVS-item-example-88122-7.md),[Observation/HVS-item-example-88123-5](Observation-HVS-item-example-88123-5.md),[Observation/HVS-item-example-88124-3](Observation-HVS-item-example-88124-3.md),[Observation/HVS-panel-example-88121-9](Observation-HVS-panel-example-88121-9.md),[Observation/PHQ9-item-example-44250-9](Observation-PHQ9-item-example-44250-9.md),[Observation/PHQ9-item-example-44251-7](Observation-PHQ9-item-example-44251-7.md),[Observation/PHQ9-item-example-44252-5](Observation-PHQ9-item-example-44252-5.md),[Observation/PHQ9-item-example-44253-3](Observation-PHQ9-item-example-44253-3.md),[Observation/PHQ9-item-example-44254-1](Observation-PHQ9-item-example-44254-1.md),[Observation/PHQ9-item-example-44255-8](Observation-PHQ9-item-example-44255-8.md),[Observation/PHQ9-item-example-44258-2](Observation-PHQ9-item-example-44258-2.md),[Observation/PHQ9-item-example-44259-0](Observation-PHQ9-item-example-44259-0.md),[Observation/PHQ9-item-example-44260-8](Observation-PHQ9-item-example-44260-8.md),[Observation/PHQ9-item-example-44261-6](Observation-PHQ9-item-example-44261-6.md),[Observation/PHQ9-item-example-69722-7](Observation-PHQ9-item-example-69722-7.md),[Observation/PHQ9-panel-example-44249-1](Observation-PHQ9-panel-example-44249-1.md),[Observation/PRAPARE-item-example-54899-0](Observation-PRAPARE-item-example-54899-0.md),[Observation/PRAPARE-item-example-56051-6](Observation-PRAPARE-item-example-56051-6.md),[Observation/PRAPARE-item-example-56799-0](Observation-PRAPARE-item-example-56799-0.md),[Observation/PRAPARE-item-example-63512-8](Observation-PRAPARE-item-example-63512-8.md),[Observation/PRAPARE-item-example-63586-2](Observation-PRAPARE-item-example-63586-2.md),[Observation/PRAPARE-item-example-67875-5](Observation-PRAPARE-item-example-67875-5.md),[Observation/PRAPARE-item-example-71802-3](Observation-PRAPARE-item-example-71802-3.md),[Observation/PRAPARE-item-example-76437-3](Observation-PRAPARE-item-example-76437-3.md),[Observation/PRAPARE-item-example-76501-6](Observation-PRAPARE-item-example-76501-6.md),[Observation/PRAPARE-item-example-82589-3](Observation-PRAPARE-item-example-82589-3.md),[Observation/PRAPARE-item-example-93026-3](Observation-PRAPARE-item-example-93026-3.md),[Observation/PRAPARE-item-example-93027-1](Observation-PRAPARE-item-example-93027-1.md),[Observation/PRAPARE-item-example-93028-9](Observation-PRAPARE-item-example-93028-9.md),[Observation/PRAPARE-item-example-93029-7](Observation-PRAPARE-item-example-93029-7.md),[Observation/PRAPARE-item-example-93030-5](Observation-PRAPARE-item-example-93030-5.md),[Observation/PRAPARE-item-example-93033-9](Observation-PRAPARE-item-example-93033-9.md),[Observation/PRAPARE-item-example-93034-7](Observation-PRAPARE-item-example-93034-7.md),[Observation/PRAPARE-item-example-93035-4](Observation-PRAPARE-item-example-93035-4.md),[Observation/PRAPARE-item-example-93038-8](Observation-PRAPARE-item-example-93038-8.md),[Observation/PRAPARE-multiselect-item-example-32624-9-answer0](Observation-PRAPARE-multiselect-item-example-32624-9-answer0.md),[Observation/PRAPARE-multiselect-item-example-32624-9-answer1](Observation-PRAPARE-multiselect-item-example-32624-9-answer1.md),[Observation/PRAPARE-multiselect-item-example-93031-3-answer0](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md),[Observation/PRAPARE-multiselect-item-example-93031-3-answer1](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md),[Observation/PRAPARE-panel-example-93025-5](Observation-PRAPARE-panel-example-93025-5.md),[Observation/PRAPARE-panel-example-93039-6](Observation-PRAPARE-panel-example-93039-6.md),[Observation/PRAPARE-panel-example-93040-4](Observation-PRAPARE-panel-example-93040-4.md),[Observation/PRAPARE-panel-example-93041-2](Observation-PRAPARE-panel-example-93041-2.md),[Observation/PRAPARE-panel-example-93042-0](Observation-PRAPARE-panel-example-93042-0.md),[Observation/PRAPARE-panel-example-93043-8](Observation-PRAPARE-panel-example-93043-8.md),[Observation/TAPS-item-example-75889-6](Observation-TAPS-item-example-75889-6.md),[Observation/TAPS-item-example-88037-7](Observation-TAPS-item-example-88037-7.md),[Observation/TAPS-item-example-96842-0](Observation-TAPS-item-example-96842-0.md),[Observation/TAPS-item-example-96843-8](Observation-TAPS-item-example-96843-8.md),[Observation/TAPS-item-example-96844-6](Observation-TAPS-item-example-96844-6.md),[Observation/TAPS-panel-example-96841-2](Observation-TAPS-panel-example-96841-2.md),[Observation/alcohol-use-status](Observation-alcohol-use-status.md),[Observation/alcoholic-drinks-per-day](Observation-alcoholic-drinks-per-day.md),[Observation/at-home-in-vitro-test](Observation-at-home-in-vitro-test.md),[Observation/average-blood-pressure](Observation-average-blood-pressure.md),[Observation/blood-pressure](Observation-blood-pressure.md),[Observation/bmi](Observation-bmi.md),[Observation/bp-data-absent](Observation-bp-data-absent.md),[Observation/capillary-refill-time-nail-bed](Observation-capillary-refill-time-nail-bed.md),[Observation/care-experience-preference](Observation-care-experience-preference.md),[Observation/cbc-erythrocytes](Observation-cbc-erythrocytes.md),[Observation/cbc-hematocrit](Observation-cbc-hematocrit.md),[Observation/cbc-hemoglobin](Observation-cbc-hemoglobin.md),[Observation/cbc-leukocytes](Observation-cbc-leukocytes.md),[Observation/cbc-mch](Observation-cbc-mch.md),[Observation/cbc-mchc](Observation-cbc-mchc.md),[Observation/cbc-mcv](Observation-cbc-mcv.md),[Observation/cbc-platelets](Observation-cbc-platelets.md),[Observation/dxa-femur-l-armass-bmd](Observation-dxa-femur-l-armass-bmd.md),[Observation/dxa-femur-l-t-score-bmd](Observation-dxa-femur-l-t-score-bmd.md),[Observation/dxa-femur-l-z-score-bmd](Observation-dxa-femur-l-z-score-bmd.md),[Observation/dxa-hip-l-armass-bmd](Observation-dxa-hip-l-armass-bmd.md),[Observation/dxa-hip-l-t-score-bmd](Observation-dxa-hip-l-t-score-bmd.md),[Observation/dxa-hip-l-z-score-bmd](Observation-dxa-hip-l-z-score-bmd.md),[Observation/ekg-impression](Observation-ekg-impression.md),[Observation/ekg-lead](Observation-ekg-lead.md),[Observation/exercise-per-day](Observation-exercise-per-day.md),[Observation/exercise-per-week](Observation-exercise-per-week.md),[Observation/head-circumference](Observation-head-circumference.md),[Observation/heart-rate](Observation-heart-rate.md),[Observation/heart-rate-rhythm](Observation-heart-rate-rhythm.md),[Observation/height](Observation-height.md),[Observation/jugular-vein-distension](Observation-jugular-vein-distension.md),[Observation/length](Observation-length.md),[Observation/no-ADI-example](Observation-no-ADI-example.md),[Observation/observation-occupation](Observation-observation-occupation.md),[Observation/observation-occupation-industry-unknown](Observation-observation-occupation-industry-unknown.md),[Observation/observation-occupation-unknown](Observation-observation-occupation-unknown.md),[Observation/ofc-percentile](Observation-ofc-percentile.md),[Observation/oxygen-saturation](Observation-oxygen-saturation.md),[Observation/p-r-interval-ekg-lead](Observation-p-r-interval-ekg-lead.md),[Observation/pediatric-bmi-example](Observation-pediatric-bmi-example.md),[Observation/pediatric-wt-example](Observation-pediatric-wt-example.md),[Observation/pregnancy-intent](Observation-pregnancy-intent.md),[Observation/pregnancy-status](Observation-pregnancy-status.md),[Observation/pulse-intensity-palpation](Observation-pulse-intensity-palpation.md),[Observation/q-t-interval-ekg-lead](Observation-q-t-interval-ekg-lead.md),[Observation/qrs-dur-ekg-lead](Observation-qrs-dur-ekg-lead.md),[Observation/respiratory-rate](Observation-respiratory-rate.md),[Observation/satO2-fiO2](Observation-satO2-fiO2.md),[Observation/serum-bun](Observation-serum-bun.md),[Observation/serum-calcium](Observation-serum-calcium.md),[Observation/serum-chloride](Observation-serum-chloride.md),[Observation/serum-co2](Observation-serum-co2.md),[Observation/serum-creatinine](Observation-serum-creatinine.md),[Observation/serum-glucose](Observation-serum-glucose.md),[Observation/serum-potassium](Observation-serum-potassium.md),[Observation/serum-sodium](Observation-serum-sodium.md),[Observation/simple-observation-cognitive-status](Observation-simple-observation-cognitive-status.md),[Observation/simple-observation-disability-status](Observation-simple-observation-disability-status.md),[Observation/simple-observation-functional-status](Observation-simple-observation-functional-status.md),[Observation/some-day-smoker](Observation-some-day-smoker.md),[Observation/temperature](Observation-temperature.md),[Observation/treatment-intervention-preference](Observation-treatment-intervention-preference.md),[Observation/urobilinogen](Observation-urobilinogen.md),[Observation/weight](Observation-weight.md),[Observation/xray-chest-findings](Observation-xray-chest-findings.md),[Observation/xray-chest-impression](Observation-xray-chest-impression.md),[PHQ9Example](Questionnaire-phq-9-example.md),[PRAPAREExample](Questionnaire-prapare-example.md),[QuestionnaireResponse/AUDIT-C](QuestionnaireResponse-AUDIT-C.md),[QuestionnaireResponse/TAPS](QuestionnaireResponse-TAPS.md),[QuestionnaireResponse/hunger-vital-sign-example](QuestionnaireResponse-hunger-vital-sign-example.md),[QuestionnaireResponse/phq-9-example](QuestionnaireResponse-phq-9-example.md),[QuestionnaireResponse/prapare-example](QuestionnaireResponse-prapare-example.md),[ServiceRequest/bmp](ServiceRequest-bmp.md),[ServiceRequest/cbc](ServiceRequest-cbc.md),[ServiceRequest/chest-xray](ServiceRequest-chest-xray.md),[ServiceRequest/ekg](ServiceRequest-ekg.md),[TAPS](Questionnaire-TAPS.md),[USCoreADIDocumentReferenceProfile](StructureDefinition-us-core-adi-documentreference.md),[USCoreAverageBloodPressureProfile](StructureDefinition-us-core-average-blood-pressure.md),[USCoreBMIProfile](StructureDefinition-us-core-bmi.md),[USCoreBloodPressureProfile](StructureDefinition-us-core-blood-pressure.md),[USCoreBodyHeightProfile](StructureDefinition-us-core-body-height.md),[USCoreBodyTemperatureProfile](StructureDefinition-us-core-body-temperature.md),[USCoreBodyWeightProfile](StructureDefinition-us-core-body-weight.md),[USCoreCareExperiencePreferenceProfile](StructureDefinition-us-core-care-experience-preference.md),[USCoreClinicalNoteType](ValueSet-us-core-clinical-note-type.md),[USCoreDiagnosticReportCategory](ValueSet-us-core-diagnosticreport-category.md),[USCoreDiagnosticReportProfileLaboratoryReporting](StructureDefinition-us-core-diagnosticreport-lab.md),[USCoreDiagnosticReportProfileNoteExchange](StructureDefinition-us-core-diagnosticreport-note.md),[USCoreDocumentReferenceProfile](StructureDefinition-us-core-documentreference.md),[USCoreDocumentReferenceType](ValueSet-us-core-documentreference-type.md),[USCoreFetchDocumentReference](OperationDefinition-docref.md),[USCoreGoalCodes](ValueSet-us-core-goal-description.md),[USCoreGoalProfile](StructureDefinition-us-core-goal.md),[USCoreHeadCircumferenceProfile](StructureDefinition-us-core-head-circumference.md),[USCoreHeartRateProfile](StructureDefinition-us-core-heart-rate.md),[USCoreInterpreterNeededExtension](StructureDefinition-us-core-interpreter-needed.md),[USCoreLaboratoryResultObservationProfile](StructureDefinition-us-core-observation-lab.md),[USCoreLaboratoryTestCodes](ValueSet-us-core-laboratory-test-codes.md),[USCoreMedicationAdherenceExtension](StructureDefinition-us-core-medication-adherence.md),[USCoreNonLaboratoryCodes](ValueSet-us-core-diagnosticreport-report-and-note-codes.md),[USCoreObservationADIDocumentationProfile](StructureDefinition-us-core-observation-adi-documentation.md),[USCoreObservationOccupationProfile](StructureDefinition-us-core-observation-occupation.md),[USCoreObservationPregnancyIntentProfile](StructureDefinition-us-core-observation-pregnancyintent.md),[USCoreObservationPregnancyStatusProfile](StructureDefinition-us-core-observation-pregnancystatus.md),[USCoreObservationScreeningAssessmentProfile](StructureDefinition-us-core-observation-screening-assessment.md),[USCoreObservationSexualOrientationProfile](StructureDefinition-us-core-observation-sexual-orientation.md),[USCorePediatricBMIforAgeObservationProfile](StructureDefinition-pediatric-bmi-for-age.md),[USCorePediatricHeadOccipitalFrontalCircumferencePercentileProfile](StructureDefinition-head-occipital-frontal-circumference-percentile.md),[USCorePediatricWeightForHeightObservationProfile](StructureDefinition-pediatric-weight-for-height.md),[USCoreProcedureCodes](ValueSet-us-core-procedure-code.md),[USCoreProcedureProfile](StructureDefinition-us-core-procedure.md),[USCorePulseOximetryProfile](StructureDefinition-us-core-pulse-oximetry.md),[USCoreRespiratoryRateProfile](StructureDefinition-us-core-respiratory-rate.md),[USCoreServiceRequestProfile](StructureDefinition-us-core-servicerequest.md),[USCoreSmokingStatusProfile](StructureDefinition-us-core-smokingstatus.md),[USCoreTreatmentInterventionPreferenceProfile](StructureDefinition-us-core-treatment-intervention-preference.md)and[USCoreVitalSignsProfile](StructureDefinition-us-core-vital-signs.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [AllergyIntolerance/example](AllergyIntolerance-example.md), [AllergyIntolerance/non-pharmacologic-agent-example](AllergyIntolerance-non-pharmacologic-agent-example.md)...Show 78 more,[Bundle/allergyintolerance-provenance-example1](Bundle-allergyintolerance-provenance-example1.md),[Bundle/allergyintolerance-provenance-example2](Bundle-allergyintolerance-provenance-example2.md),[Condition/condition-SDOH-example](Condition-condition-SDOH-example.md),[Condition/condition-duodenal-ulcer](Condition-condition-duodenal-ulcer.md),[Condition/encounter-diagnosis-example1](Condition-encounter-diagnosis-example1.md),[Condition/encounter-diagnosis-example2](Condition-encounter-diagnosis-example2.md),[Condition/health-concern-example](Condition-health-concern-example.md),[Device/udi-1](Device-udi-1.md),[Device/udi-2](Device-udi-2.md),[Device/udi-3](Device-udi-3.md),[Encounter/1036](Encounter-1036.md),[Encounter/delivery](Encounter-delivery.md),[Encounter/example-1](Encounter-example-1.md),[Goal/goal-sdoh-2](Goal-goal-sdoh-2.md),[Holy Family Hospital](Location-hospital.md),[Media/chest-xray](Media-chest-xray.md),[MedicationRequest/medicationrequest-coded-oral-axid](MedicationRequest-medicationrequest-coded-oral-axid.md),[MedicationRequest/medicationrequest-contained-oral-axid](MedicationRequest-medicationrequest-contained-oral-axid.md),[MedicationRequest/medicationrequest-referenced-oral-axid](MedicationRequest-medicationrequest-referenced-oral-axid.md),[MedicationRequest/self-tylenol](MedicationRequest-self-tylenol.md),[Observation/10-minute-apgar-score-panel](Observation-10-minute-apgar-score-panel.md),[Observation/ADI-example](Observation-ADI-example.md),[Observation/alcohol-use-status](Observation-alcohol-use-status.md),[Observation/at-home-in-vitro-test](Observation-at-home-in-vitro-test.md),[Observation/average-blood-pressure](Observation-average-blood-pressure.md),[Observation/no-ADI-example](Observation-no-ADI-example.md),[Observation/pack-years-example](Observation-pack-years-example.md),[Observation/pregnancy-intent](Observation-pregnancy-intent.md),[Observation/pregnancy-status](Observation-pregnancy-status.md),[Observation/simple-observation-functional-status](Observation-simple-observation-functional-status.md),[Observation/simple-observation-sdoh](Observation-simple-observation-sdoh.md),[Observation/some-day-smoker](Observation-some-day-smoker.md),[Observation/substance-use-status](Observation-substance-use-status.md),[Patient/child-example](Patient-child-example.md),[Patient/deceased-example](Patient-deceased-example.md),[Patient/example](Patient-example.md),[Patient/infant-example](Patient-infant-example.md),[Procedure/rehab](Procedure-rehab.md),[ServiceRequest/bmp](ServiceRequest-bmp.md),[ServiceRequest/cbc](ServiceRequest-cbc.md),[ServiceRequest/chest-xray](ServiceRequest-chest-xray.md),[ServiceRequest/ekg](ServiceRequest-ekg.md),[ServiceRequest/foodpantry-referral](ServiceRequest-foodpantry-referral.md),[ServiceRequest/rehab](ServiceRequest-rehab.md),[Specimen/example-serum-lipemic](Specimen-example-serum-lipemic.md),[Specimen/specimen-example-serum](Specimen-specimen-example-serum.md),[Specimen/specimen-example-urine](Specimen-specimen-example-urine.md),[Specimen/specimen-example-whole-blood](Specimen-specimen-example-whole-blood.md),[US-Core example CareTeam](CareTeam-missing-coded-data-example.md),[USCoreAllergyIntolerance](StructureDefinition-us-core-allergyintolerance.md),[USCoreCareTeam](StructureDefinition-us-core-careteam.md),[USCoreConditionCodes](ValueSet-us-core-condition-code.md),[USCoreConditionCodesCurrent](ValueSet-us-core-condition-code-current.md),[USCoreConditionEncounterDiagnosisProfile](StructureDefinition-us-core-condition-encounter-diagnosis.md),[USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md),[USCoreEncounterProfile](StructureDefinition-us-core-encounter.md),[USCoreGenderIdentityExtension](StructureDefinition-us-core-genderIdentity.md),[USCoreGoalCodes](ValueSet-us-core-goal-description.md),[USCoreGoalProfile](StructureDefinition-us-core-goal.md),[USCoreImmunizationProfile](StructureDefinition-us-core-immunization.md),[USCoreImplantableDeviceProfile](StructureDefinition-us-core-implantable-device.md),[USCoreIndividualSexExtension](StructureDefinition-us-core-individual-sex.md),[USCoreInterpreterNeededExtension](StructureDefinition-us-core-interpreter-needed.md),[USCoreMedicationAdherenceExtension](StructureDefinition-us-core-medication-adherence.md),[USCoreMedicationDispenseProfile](StructureDefinition-us-core-medicationdispense.md),[USCoreMedicationRequestProfile](StructureDefinition-us-core-medicationrequest.md),[USCoreObservationADIDocumentationProfile](StructureDefinition-us-core-observation-adi-documentation.md),[USCoreObservationPregnancyIntentProfile](StructureDefinition-us-core-observation-pregnancyintent.md),[USCoreObservationPregnancyStatusProfile](StructureDefinition-us-core-observation-pregnancystatus.md),[USCoreObservationSexualOrientationProfile](StructureDefinition-us-core-observation-sexual-orientation.md),[USCorePractitionerRoleProfile](StructureDefinition-us-core-practitionerrole.md),[USCoreProcedureCodes](ValueSet-us-core-procedure-code.md),[USCoreProcedureProfile](StructureDefinition-us-core-procedure.md),[USCoreServiceRequestCategoryCodes](ValueSet-us-core-servicerequest-category.md),[USCoreServiceRequestProfile](StructureDefinition-us-core-servicerequest.md),[USCoreSexExtension](StructureDefinition-us-core-sex.md),[USCoreSmokingStatusProfile](StructureDefinition-us-core-smokingstatus.md)and[USCoreSpecimenProfile](StructureDefinition-us-core-specimen.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.0/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/example](AllergyIntolerance-example.md), [AllergyIntolerance/non-pharmacologic-agent-example](AllergyIntolerance-non-pharmacologic-agent-example.md), [Bundle/allergyintolerance-provenance-example1](Bundle-allergyintolerance-provenance-example1.md), [Bundle/allergyintolerance-provenance-example2](Bundle-allergyintolerance-provenance-example2.md) and [USCoreAllergyIntolerance](StructureDefinition-us-core-allergyintolerance.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.0/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/example](AllergyIntolerance-example.md), [AllergyIntolerance/non-pharmacologic-agent-example](AllergyIntolerance-non-pharmacologic-agent-example.md), [Bundle/allergyintolerance-provenance-example1](Bundle-allergyintolerance-provenance-example1.md), [Bundle/allergyintolerance-provenance-example2](Bundle-allergyintolerance-provenance-example2.md) and [USCoreAllergyIntolerance](StructureDefinition-us-core-allergyintolerance.md)
* [Condition Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-category.html): [Condition/condition-SDOH-example](Condition-condition-SDOH-example.md), [Condition/condition-duodenal-ulcer](Condition-condition-duodenal-ulcer.md)...Show 5 more,[Condition/encounter-diagnosis-example1](Condition-encounter-diagnosis-example1.md),[Condition/encounter-diagnosis-example2](Condition-encounter-diagnosis-example2.md),[USCoreConditionEncounterDiagnosisProfile](StructureDefinition-us-core-condition-encounter-diagnosis.md),[USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md)and[USCoreProblemOrHealthConcern](ValueSet-us-core-problem-or-health-concern.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-clinical.html): [Condition/condition-SDOH-example](Condition-condition-SDOH-example.md), [Condition/condition-duodenal-ulcer](Condition-condition-duodenal-ulcer.md), [Condition/health-concern-example](Condition-health-concern-example.md) and [USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.0/CodeSystem-condition-ver-status.html): [Condition/condition-SDOH-example](Condition-condition-SDOH-example.md), [Condition/condition-duodenal-ulcer](Condition-condition-duodenal-ulcer.md), [Condition/health-concern-example](Condition-health-concern-example.md) and [USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md)
* [Coverage Class Codes](http://terminology.hl7.org/7.0.0/CodeSystem-coverage-class.html): [Coverage/coverage-example](Coverage-coverage-example.md) and [USCoreCoverageProfile](StructureDefinition-us-core-coverage.md)
* [DataAbsentReason](http://terminology.hl7.org/7.0.0/CodeSystem-data-absent-reason.html): [Observation/bp-data-absent](Observation-bp-data-absent.md), [Observation/observation-occupation-unknown](Observation-observation-occupation-unknown.md)...Show 10 more,[US-Core example CareTeam](CareTeam-missing-coded-data-example.md),[USCoreBirthSexExtension](StructureDefinition-us-core-birthsex.md),[USCoreEthnicityExtension](StructureDefinition-us-core-ethnicity.md),[USCoreGenderIdentityExtension](StructureDefinition-us-core-genderIdentity.md),[USCoreInterpreterNeededExtension](StructureDefinition-us-core-interpreter-needed.md),[USCoreMedicationAdherenceExtension](StructureDefinition-us-core-medication-adherence.md),[USCoreObservationADIDocumentationProfile](StructureDefinition-us-core-observation-adi-documentation.md),[USCoreObservationSexualOrientationProfile](StructureDefinition-us-core-observation-sexual-orientation.md),[USCoreRaceExtension](StructureDefinition-us-core-race.md)and[USCoreSexExtension](StructureDefinition-us-core-sex.md)
* [Endpoint Connection Type](http://terminology.hl7.org/7.0.0/CodeSystem-endpoint-connection-type.html): [Bundle/66c8856b-ba11-4876-8aa8-467aad8c11a2](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md) and [Saint Luke's Hospital of Kansas City](Organization-saint-luke-w-endpoint.md)
* [LibraryType](http://terminology.hl7.org/7.0.0/CodeSystem-library-type.html): [USCoreVersion311ModelDefinition](Library-uscore-3.1.1-model-definition.md), [USCoreVersion400ModelDefinition](Library-uscore-4.0.0-model-definition.md)...Show 4 more,[USCoreVersion501ModelDefinition](Library-uscore-5.0.1-model-definition.md),[USCoreVersion610ModelDefinition](Library-uscore-6.1.0-model-definition.md),[USCoreVersion700ModelDefinition](Library-uscore-7.0.0-model-definition.md)and[USCoreVersion801ModelDefinition](Library-uscore-8.0.1-model-definition.md)
* [MedicationRequest Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-medicationrequest-category.html): [USCoreMedicationRequestProfile](StructureDefinition-us-core-medicationrequest.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Observation/10-minute-apgar-color](Observation-10-minute-apgar-color.md), [Observation/10-minute-apgar-heart-rate](Observation-10-minute-apgar-heart-rate.md)...Show 144 more,[Observation/10-minute-apgar-muscle-tone](Observation-10-minute-apgar-muscle-tone.md),[Observation/10-minute-apgar-reflex-irritability](Observation-10-minute-apgar-reflex-irritability.md),[Observation/10-minute-apgar-respiratory-effort](Observation-10-minute-apgar-respiratory-effort.md),[Observation/10-minute-apgar-score](Observation-10-minute-apgar-score.md),[Observation/10-minute-apgar-score-panel](Observation-10-minute-apgar-score-panel.md),[Observation/AHC-HRSN-item-example-68517-2](Observation-AHC-HRSN-item-example-68517-2.md),[Observation/AUDIT-C-item-example-68517-2](Observation-AUDIT-C-item-example-68517-2.md),[Observation/AUDIT-C-item-example-68519-8](Observation-AUDIT-C-item-example-68519-8.md),[Observation/AUDIT-C-item-example-68520-6](Observation-AUDIT-C-item-example-68520-6.md),[Observation/AUDIT-C-item-example-75626-2](Observation-AUDIT-C-item-example-75626-2.md),[Observation/AUDIT-C-panel-example-72109-2](Observation-AUDIT-C-panel-example-72109-2.md),[Observation/EVS-item-example-68516-4](Observation-EVS-item-example-68516-4.md),[Observation/EVS-item-example-89555-7](Observation-EVS-item-example-89555-7.md),[Observation/EVS-panel-example-89574-8](Observation-EVS-panel-example-89574-8.md),[Observation/HVS-item-example-88122-7](Observation-HVS-item-example-88122-7.md),[Observation/HVS-item-example-88123-5](Observation-HVS-item-example-88123-5.md),[Observation/HVS-item-example-88124-3](Observation-HVS-item-example-88124-3.md),[Observation/HVS-panel-example-88121-9](Observation-HVS-panel-example-88121-9.md),[Observation/PHQ9-item-example-44250-9](Observation-PHQ9-item-example-44250-9.md),[Observation/PHQ9-item-example-44251-7](Observation-PHQ9-item-example-44251-7.md),[Observation/PHQ9-item-example-44252-5](Observation-PHQ9-item-example-44252-5.md),[Observation/PHQ9-item-example-44253-3](Observation-PHQ9-item-example-44253-3.md),[Observation/PHQ9-item-example-44254-1](Observation-PHQ9-item-example-44254-1.md),[Observation/PHQ9-item-example-44255-8](Observation-PHQ9-item-example-44255-8.md),[Observation/PHQ9-item-example-44258-2](Observation-PHQ9-item-example-44258-2.md),[Observation/PHQ9-item-example-44259-0](Observation-PHQ9-item-example-44259-0.md),[Observation/PHQ9-item-example-44260-8](Observation-PHQ9-item-example-44260-8.md),[Observation/PHQ9-item-example-44261-6](Observation-PHQ9-item-example-44261-6.md),[Observation/PHQ9-item-example-69722-7](Observation-PHQ9-item-example-69722-7.md),[Observation/PHQ9-panel-example-44249-1](Observation-PHQ9-panel-example-44249-1.md),[Observation/PRAPARE-item-example-54899-0](Observation-PRAPARE-item-example-54899-0.md),[Observation/PRAPARE-item-example-56051-6](Observation-PRAPARE-item-example-56051-6.md),[Observation/PRAPARE-item-example-56799-0](Observation-PRAPARE-item-example-56799-0.md),[Observation/PRAPARE-item-example-63512-8](Observation-PRAPARE-item-example-63512-8.md),[Observation/PRAPARE-item-example-63586-2](Observation-PRAPARE-item-example-63586-2.md),[Observation/PRAPARE-item-example-67875-5](Observation-PRAPARE-item-example-67875-5.md),[Observation/PRAPARE-item-example-71802-3](Observation-PRAPARE-item-example-71802-3.md),[Observation/PRAPARE-item-example-76437-3](Observation-PRAPARE-item-example-76437-3.md),[Observation/PRAPARE-item-example-76501-6](Observation-PRAPARE-item-example-76501-6.md),[Observation/PRAPARE-item-example-82589-3](Observation-PRAPARE-item-example-82589-3.md),[Observation/PRAPARE-item-example-93026-3](Observation-PRAPARE-item-example-93026-3.md),[Observation/PRAPARE-item-example-93027-1](Observation-PRAPARE-item-example-93027-1.md),[Observation/PRAPARE-item-example-93028-9](Observation-PRAPARE-item-example-93028-9.md),[Observation/PRAPARE-item-example-93029-7](Observation-PRAPARE-item-example-93029-7.md),[Observation/PRAPARE-item-example-93030-5](Observation-PRAPARE-item-example-93030-5.md),[Observation/PRAPARE-item-example-93033-9](Observation-PRAPARE-item-example-93033-9.md),[Observation/PRAPARE-item-example-93034-7](Observation-PRAPARE-item-example-93034-7.md),[Observation/PRAPARE-item-example-93035-4](Observation-PRAPARE-item-example-93035-4.md),[Observation/PRAPARE-item-example-93038-8](Observation-PRAPARE-item-example-93038-8.md),[Observation/PRAPARE-multiselect-item-example-32624-9-answer0](Observation-PRAPARE-multiselect-item-example-32624-9-answer0.md),[Observation/PRAPARE-multiselect-item-example-32624-9-answer1](Observation-PRAPARE-multiselect-item-example-32624-9-answer1.md),[Observation/PRAPARE-multiselect-item-example-93031-3-answer0](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md),[Observation/PRAPARE-multiselect-item-example-93031-3-answer1](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md),[Observation/PRAPARE-panel-example-93025-5](Observation-PRAPARE-panel-example-93025-5.md),[Observation/PRAPARE-panel-example-93039-6](Observation-PRAPARE-panel-example-93039-6.md),[Observation/PRAPARE-panel-example-93040-4](Observation-PRAPARE-panel-example-93040-4.md),[Observation/PRAPARE-panel-example-93041-2](Observation-PRAPARE-panel-example-93041-2.md),[Observation/PRAPARE-panel-example-93042-0](Observation-PRAPARE-panel-example-93042-0.md),[Observation/PRAPARE-panel-example-93043-8](Observation-PRAPARE-panel-example-93043-8.md),[Observation/TAPS-item-example-75889-6](Observation-TAPS-item-example-75889-6.md),[Observation/TAPS-item-example-88037-7](Observation-TAPS-item-example-88037-7.md),[Observation/TAPS-item-example-96842-0](Observation-TAPS-item-example-96842-0.md),[Observation/TAPS-item-example-96843-8](Observation-TAPS-item-example-96843-8.md),[Observation/TAPS-item-example-96844-6](Observation-TAPS-item-example-96844-6.md),[Observation/TAPS-panel-example-96841-2](Observation-TAPS-panel-example-96841-2.md),[Observation/alcohol-use-status](Observation-alcohol-use-status.md),[Observation/alcoholic-drinks-per-day](Observation-alcoholic-drinks-per-day.md),[Observation/at-home-in-vitro-test](Observation-at-home-in-vitro-test.md),[Observation/average-blood-pressure](Observation-average-blood-pressure.md),[Observation/blood-pressure](Observation-blood-pressure.md),[Observation/bmi](Observation-bmi.md),[Observation/bp-data-absent](Observation-bp-data-absent.md),[Observation/capillary-refill-time-nail-bed](Observation-capillary-refill-time-nail-bed.md),[Observation/cbc-erythrocytes](Observation-cbc-erythrocytes.md),[Observation/cbc-hematocrit](Observation-cbc-hematocrit.md),[Observation/cbc-hemoglobin](Observation-cbc-hemoglobin.md),[Observation/cbc-leukocytes](Observation-cbc-leukocytes.md),[Observation/cbc-mch](Observation-cbc-mch.md),[Observation/cbc-mchc](Observation-cbc-mchc.md),[Observation/cbc-mcv](Observation-cbc-mcv.md),[Observation/cbc-platelets](Observation-cbc-platelets.md),[Observation/dxa-femur-l-armass-bmd](Observation-dxa-femur-l-armass-bmd.md),[Observation/dxa-femur-l-t-score-bmd](Observation-dxa-femur-l-t-score-bmd.md),[Observation/dxa-femur-l-z-score-bmd](Observation-dxa-femur-l-z-score-bmd.md),[Observation/dxa-hip-l-armass-bmd](Observation-dxa-hip-l-armass-bmd.md),[Observation/dxa-hip-l-t-score-bmd](Observation-dxa-hip-l-t-score-bmd.md),[Observation/dxa-hip-l-z-score-bmd](Observation-dxa-hip-l-z-score-bmd.md),[Observation/ekg-impression](Observation-ekg-impression.md),[Observation/ekg-lead](Observation-ekg-lead.md),[Observation/exercise-per-day](Observation-exercise-per-day.md),[Observation/exercise-per-week](Observation-exercise-per-week.md),[Observation/head-circumference](Observation-head-circumference.md),[Observation/heart-rate](Observation-heart-rate.md),[Observation/heart-rate-rhythm](Observation-heart-rate-rhythm.md),[Observation/height](Observation-height.md),[Observation/jugular-vein-distension](Observation-jugular-vein-distension.md),[Observation/length](Observation-length.md),[Observation/observation-occupation](Observation-observation-occupation.md),[Observation/observation-occupation-industry-unknown](Observation-observation-occupation-industry-unknown.md),[Observation/observation-occupation-unknown](Observation-observation-occupation-unknown.md),[Observation/ofc-percentile](Observation-ofc-percentile.md),[Observation/oxygen-saturation](Observation-oxygen-saturation.md),[Observation/p-r-interval-ekg-lead](Observation-p-r-interval-ekg-lead.md),[Observation/pack-years-example](Observation-pack-years-example.md),[Observation/pediatric-bmi-example](Observation-pediatric-bmi-example.md),[Observation/pediatric-wt-example](Observation-pediatric-wt-example.md),[Observation/pregnancy-intent](Observation-pregnancy-intent.md),[Observation/pregnancy-status](Observation-pregnancy-status.md),[Observation/pulse-intensity-palpation](Observation-pulse-intensity-palpation.md),[Observation/q-t-interval-ekg-lead](Observation-q-t-interval-ekg-lead.md),[Observation/qrs-dur-ekg-lead](Observation-qrs-dur-ekg-lead.md),[Observation/respiratory-rate](Observation-respiratory-rate.md),[Observation/satO2-fiO2](Observation-satO2-fiO2.md),[Observation/serum-bun](Observation-serum-bun.md),[Observation/serum-calcium](Observation-serum-calcium.md),[Observation/serum-chloride](Observation-serum-chloride.md),[Observation/serum-co2](Observation-serum-co2.md),[Observation/serum-creatinine](Observation-serum-creatinine.md),[Observation/serum-glucose](Observation-serum-glucose.md),[Observation/serum-potassium](Observation-serum-potassium.md),[Observation/serum-sodium](Observation-serum-sodium.md),[Observation/some-day-smoker](Observation-some-day-smoker.md),[Observation/substance-use-status](Observation-substance-use-status.md),[Observation/temperature](Observation-temperature.md),[Observation/urobilinogen](Observation-urobilinogen.md),[Observation/weight](Observation-weight.md),[Observation/xray-chest-findings](Observation-xray-chest-findings.md),[Observation/xray-chest-impression](Observation-xray-chest-impression.md),[USCoreCareExperiencePreferenceProfile](StructureDefinition-us-core-care-experience-preference.md),[USCoreClinicalResultObservationCategory](ValueSet-us-core-clinical-result-observation-category.md),[USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md),[USCoreLaboratoryResultObservationProfile](StructureDefinition-us-core-observation-lab.md),[USCoreObservationADIDocumentationProfile](StructureDefinition-us-core-observation-adi-documentation.md),[USCoreObservationClinicalResultProfile](StructureDefinition-us-core-observation-clinical-result.md),[USCoreObservationOccupationProfile](StructureDefinition-us-core-observation-occupation.md),[USCoreObservationPregnancyIntentProfile](StructureDefinition-us-core-observation-pregnancyintent.md),[USCoreObservationPregnancyStatusProfile](StructureDefinition-us-core-observation-pregnancystatus.md),[USCoreObservationScreeningAssessmentProfile](StructureDefinition-us-core-observation-screening-assessment.md),[USCoreScreeningAssessmentObservationCategory](ValueSet-us-core-screening-assessment-observation-category.md),[USCoreScreeningAssessmentObservationMaximumCategory](ValueSet-us-core-screening-assessment-observation-maximum-category.md),[USCoreSimpleObservationCategory](ValueSet-us-core-simple-observation-category.md),[USCoreSimpleObservationProfile](StructureDefinition-us-core-simple-observation.md),[USCoreSmokingStatusProfile](StructureDefinition-us-core-smokingstatus.md)and[USCoreTreatmentInterventionPreferenceProfile](StructureDefinition-us-core-treatment-intervention-preference.md)
* [Organization type](http://terminology.hl7.org/7.0.0/CodeSystem-organization-type.html): [Acme Clinic](Organization-example-organization-2.md), [Acme Health Plan](Organization-acme-payer.md), [Acme Labs](Organization-acme-lab.md) and [Holy Healthcare](Organization-holy-healthcare.md)
* [Observation Reference Range Meaning Codes](http://terminology.hl7.org/7.0.0/CodeSystem-referencerange-meaning.html): [Observation/cbc-erythrocytes](Observation-cbc-erythrocytes.md), [Observation/cbc-hematocrit](Observation-cbc-hematocrit.md)...Show 14 more,[Observation/cbc-hemoglobin](Observation-cbc-hemoglobin.md),[Observation/cbc-leukocytes](Observation-cbc-leukocytes.md),[Observation/cbc-mch](Observation-cbc-mch.md),[Observation/cbc-mchc](Observation-cbc-mchc.md),[Observation/cbc-mcv](Observation-cbc-mcv.md),[Observation/cbc-platelets](Observation-cbc-platelets.md),[Observation/serum-bun](Observation-serum-bun.md),[Observation/serum-calcium](Observation-serum-calcium.md),[Observation/serum-chloride](Observation-serum-chloride.md),[Observation/serum-co2](Observation-serum-co2.md),[Observation/serum-creatinine](Observation-serum-creatinine.md),[Observation/serum-glucose](Observation-serum-glucose.md),[Observation/serum-potassium](Observation-serum-potassium.md)and[Observation/serum-sodium](Observation-serum-sodium.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/7.0.0/CodeSystem-subscriber-relationship.html): [Coverage/coverage-example](Coverage-coverage-example.md) and [USCoreCoverageProfile](StructureDefinition-us-core-coverage.md)
* [UsageContextType](http://terminology.hl7.org/7.0.0/CodeSystem-usage-context-type.html): [PRAPAREExample](Questionnaire-prapare-example.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0074.html): [DiagnosticReport/cbc](DiagnosticReport-cbc.md), [DiagnosticReport/metabolic-panel](DiagnosticReport-metabolic-panel.md) and [USCoreDiagnosticReportProfileLaboratoryReporting](StructureDefinition-us-core-diagnosticreport-lab.md)
* [contactRole2](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0131.html): [USCoreRelatedPersonProfile](StructureDefinition-us-core-relatedperson.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [Bundle/66c8856b-ba11-4876-8aa8-467aad8c11a2](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md), [Coverage/coverage-example](Coverage-coverage-example.md)...Show 5 more,[Patient/child-example](Patient-child-example.md),[Patient/deceased-example](Patient-deceased-example.md),[Patient/example](Patient-example.md),[Patient/infant-example](Patient-infant-example.md)and[USCoreCoverageProfile](StructureDefinition-us-core-coverage.md)
* [specimenType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0487.html): [Specimen/example-serum-lipemic](Specimen-example-serum-lipemic.md), [Specimen/specimen-example-serum](Specimen-specimen-example-serum.md), [Specimen/specimen-example-urine](Specimen-specimen-example-urine.md) and [Specimen/specimen-example-whole-blood](Specimen-specimen-example-whole-blood.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Coverage/coverage-example](Coverage-coverage-example.md), [Encounter/1036](Encounter-1036.md)...Show 4 more,[Encounter/delivery](Encounter-delivery.md),[Encounter/example-1](Encounter-example-1.md),[MedicationDispense/medicationdispense-example](MedicationDispense-medicationdispense-example.md)and[USCoreMedicationDispenseProfile](StructureDefinition-us-core-medicationdispense.md)
* [ActReason](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActReason.html): [USCoreImmunizationProfile](StructureDefinition-us-core-immunization.md)
* [AdministrativeGender](http://terminology.hl7.org/7.0.0/CodeSystem-v3-AdministrativeGender.html): [USCoreBirthSexExtension](StructureDefinition-us-core-birthsex.md)
* [HL7 Document Format Codes](http://terminology.hl7.org/7.0.0/CodeSystem-v3-HL7DocumentFormatCodes.html): [Bundle/docref-example-1](Bundle-docref-example-1.md), [USCoreADIDocumentReferenceProfile](StructureDefinition-us-core-adi-documentreference.md) and [USCoreDocumentReferenceProfile](StructureDefinition-us-core-documentreference.md)
* [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html): [USCoreBirthSexExtension](StructureDefinition-us-core-birthsex.md), [USCoreDocumentReferenceProfile](StructureDefinition-us-core-documentreference.md)...Show 6 more,[USCoreDocumentReferenceType](ValueSet-us-core-documentreference-type.md),[USCoreEthnicityExtension](StructureDefinition-us-core-ethnicity.md),[USCoreGenderIdentityExtension](StructureDefinition-us-core-genderIdentity.md),[USCoreObservationPregnancyStatusProfile](StructureDefinition-us-core-observation-pregnancystatus.md),[USCoreObservationSexualOrientationProfile](StructureDefinition-us-core-observation-sexual-orientation.md)and[USCoreRaceExtension](StructureDefinition-us-core-race.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ObservationInterpretation.html): [Observation/cbc-erythrocytes](Observation-cbc-erythrocytes.md), [Observation/cbc-hematocrit](Observation-cbc-hematocrit.md)...Show 17 more,[Observation/cbc-hemoglobin](Observation-cbc-hemoglobin.md),[Observation/cbc-leukocytes](Observation-cbc-leukocytes.md),[Observation/cbc-mch](Observation-cbc-mch.md),[Observation/cbc-mchc](Observation-cbc-mchc.md),[Observation/cbc-mcv](Observation-cbc-mcv.md),[Observation/cbc-platelets](Observation-cbc-platelets.md),[Observation/satO2-fiO2](Observation-satO2-fiO2.md),[Observation/serum-bun](Observation-serum-bun.md),[Observation/serum-calcium](Observation-serum-calcium.md),[Observation/serum-chloride](Observation-serum-chloride.md),[Observation/serum-co2](Observation-serum-co2.md),[Observation/serum-creatinine](Observation-serum-creatinine.md),[Observation/serum-glucose](Observation-serum-glucose.md),[Observation/serum-potassium](Observation-serum-potassium.md),[Observation/serum-sodium](Observation-serum-sodium.md),[Observation/urobilinogen](Observation-urobilinogen.md)and[USCoreLaboratoryResultObservationProfile](StructureDefinition-us-core-observation-lab.md)
* [ParticipationFunction](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationFunction.html): [Bundle/66c8856b-ba11-4876-8aa8-467aad8c11a2](Bundle-66c8856b-ba11-4876-8aa8-467aad8c11a2.md), [USCoreCareTeam](StructureDefinition-us-core-careteam.md), [USCoreMedicationAdherenceExtension](StructureDefinition-us-core-medication-adherence.md) and [USCorePractitionerRoleProfile](StructureDefinition-us-core-practitionerrole.md)
* [RoleCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-RoleCode.html): [Holy Family Hospital](Location-hospital.md), [MedicationRequest/self-tylenol](MedicationRequest-self-tylenol.md)...Show 4 more,[RelatedPerson/shaw-niece](RelatedPerson-shaw-niece.md),[USCoreLocationProfile](StructureDefinition-us-core-location.md),[USCoreMedicationAdherenceExtension](StructureDefinition-us-core-medication-adherence.md)and[USCoreRelatedPersonProfile](StructureDefinition-us-core-relatedperson.md)
* [TribalEntityUS](http://terminology.hl7.org/7.0.0/CodeSystem-v3-TribalEntityUS.html): [Patient/example](Patient-example.md) and [USCoreTribalAffiliationExtension](StructureDefinition-us-core-tribal-affiliation.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core CarePlan Category Extension Codes](CodeSystem-careplan-category.md): [CarePlan/colonoscopy](CarePlan-colonoscopy.md) and [USCoreCarePlanProfile](StructureDefinition-us-core-careplan.md)
* [US Core Condition Category Extension Codes](CodeSystem-condition-category.md): [Condition/health-concern-example](Condition-health-concern-example.md), [USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md) and [USCoreProblemOrHealthConcern](ValueSet-us-core-problem-or-health-concern.md)
* [US Core Category](CodeSystem-us-core-category.md): [Condition/condition-SDOH-example](Condition-condition-SDOH-example.md), [Observation/ADI-example](Observation-ADI-example.md)...Show 68 more,[Observation/AHC-HRSN-item-example-68517-2](Observation-AHC-HRSN-item-example-68517-2.md),[Observation/HVS-item-example-88122-7](Observation-HVS-item-example-88122-7.md),[Observation/HVS-item-example-88123-5](Observation-HVS-item-example-88123-5.md),[Observation/HVS-item-example-88124-3](Observation-HVS-item-example-88124-3.md),[Observation/HVS-panel-example-88121-9](Observation-HVS-panel-example-88121-9.md),[Observation/PHQ9-item-example-44250-9](Observation-PHQ9-item-example-44250-9.md),[Observation/PHQ9-item-example-44251-7](Observation-PHQ9-item-example-44251-7.md),[Observation/PHQ9-item-example-44252-5](Observation-PHQ9-item-example-44252-5.md),[Observation/PHQ9-item-example-44253-3](Observation-PHQ9-item-example-44253-3.md),[Observation/PHQ9-item-example-44254-1](Observation-PHQ9-item-example-44254-1.md),[Observation/PHQ9-item-example-44255-8](Observation-PHQ9-item-example-44255-8.md),[Observation/PHQ9-item-example-44258-2](Observation-PHQ9-item-example-44258-2.md),[Observation/PHQ9-item-example-44259-0](Observation-PHQ9-item-example-44259-0.md),[Observation/PHQ9-item-example-44260-8](Observation-PHQ9-item-example-44260-8.md),[Observation/PHQ9-item-example-44261-6](Observation-PHQ9-item-example-44261-6.md),[Observation/PHQ9-item-example-69722-7](Observation-PHQ9-item-example-69722-7.md),[Observation/PHQ9-panel-example-44249-1](Observation-PHQ9-panel-example-44249-1.md),[Observation/PRAPARE-item-example-54899-0](Observation-PRAPARE-item-example-54899-0.md),[Observation/PRAPARE-item-example-56051-6](Observation-PRAPARE-item-example-56051-6.md),[Observation/PRAPARE-item-example-56799-0](Observation-PRAPARE-item-example-56799-0.md),[Observation/PRAPARE-item-example-63512-8](Observation-PRAPARE-item-example-63512-8.md),[Observation/PRAPARE-item-example-63586-2](Observation-PRAPARE-item-example-63586-2.md),[Observation/PRAPARE-item-example-67875-5](Observation-PRAPARE-item-example-67875-5.md),[Observation/PRAPARE-item-example-71802-3](Observation-PRAPARE-item-example-71802-3.md),[Observation/PRAPARE-item-example-76437-3](Observation-PRAPARE-item-example-76437-3.md),[Observation/PRAPARE-item-example-76501-6](Observation-PRAPARE-item-example-76501-6.md),[Observation/PRAPARE-item-example-82589-3](Observation-PRAPARE-item-example-82589-3.md),[Observation/PRAPARE-item-example-93026-3](Observation-PRAPARE-item-example-93026-3.md),[Observation/PRAPARE-item-example-93027-1](Observation-PRAPARE-item-example-93027-1.md),[Observation/PRAPARE-item-example-93028-9](Observation-PRAPARE-item-example-93028-9.md),[Observation/PRAPARE-item-example-93029-7](Observation-PRAPARE-item-example-93029-7.md),[Observation/PRAPARE-item-example-93030-5](Observation-PRAPARE-item-example-93030-5.md),[Observation/PRAPARE-item-example-93033-9](Observation-PRAPARE-item-example-93033-9.md),[Observation/PRAPARE-item-example-93034-7](Observation-PRAPARE-item-example-93034-7.md),[Observation/PRAPARE-item-example-93035-4](Observation-PRAPARE-item-example-93035-4.md),[Observation/PRAPARE-item-example-93038-8](Observation-PRAPARE-item-example-93038-8.md),[Observation/PRAPARE-multiselect-item-example-32624-9-answer0](Observation-PRAPARE-multiselect-item-example-32624-9-answer0.md),[Observation/PRAPARE-multiselect-item-example-32624-9-answer1](Observation-PRAPARE-multiselect-item-example-32624-9-answer1.md),[Observation/PRAPARE-multiselect-item-example-93031-3-answer0](Observation-PRAPARE-multiselect-item-example-93031-3-answer0.md),[Observation/PRAPARE-multiselect-item-example-93031-3-answer1](Observation-PRAPARE-multiselect-item-example-93031-3-answer1.md),[Observation/PRAPARE-panel-example-93025-5](Observation-PRAPARE-panel-example-93025-5.md),[Observation/PRAPARE-panel-example-93039-6](Observation-PRAPARE-panel-example-93039-6.md),[Observation/PRAPARE-panel-example-93040-4](Observation-PRAPARE-panel-example-93040-4.md),[Observation/PRAPARE-panel-example-93041-2](Observation-PRAPARE-panel-example-93041-2.md),[Observation/PRAPARE-panel-example-93042-0](Observation-PRAPARE-panel-example-93042-0.md),[Observation/PRAPARE-panel-example-93043-8](Observation-PRAPARE-panel-example-93043-8.md),[Observation/care-experience-preference](Observation-care-experience-preference.md),[Observation/no-ADI-example](Observation-no-ADI-example.md),[Observation/simple-observation-cognitive-status](Observation-simple-observation-cognitive-status.md),[Observation/simple-observation-disability-status](Observation-simple-observation-disability-status.md),[Observation/simple-observation-functional-status](Observation-simple-observation-functional-status.md),[Observation/simple-observation-sdoh](Observation-simple-observation-sdoh.md),[Observation/treatment-intervention-preference](Observation-treatment-intervention-preference.md),[PRAPAREExample](Questionnaire-prapare-example.md),[ServiceRequest/foodpantry-referral](ServiceRequest-foodpantry-referral.md),[ServiceRequest/rehab](ServiceRequest-rehab.md),[USCoreCareExperiencePreferenceProfile](StructureDefinition-us-core-care-experience-preference.md),[USCoreConditionProblemsHealthConcernsProfile](StructureDefinition-us-core-condition-problems-health-concerns.md),[USCoreObservationADIDocumentationProfile](StructureDefinition-us-core-observation-adi-documentation.md),[USCoreObservationScreeningAssessmentProfile](StructureDefinition-us-core-observation-screening-assessment.md),[USCoreScreeningAssessmentConditionCategory](ValueSet-us-core-screening-assessment-condition-category.md),[USCoreScreeningAssessmentObservationCategory](ValueSet-us-core-screening-assessment-observation-category.md),[USCoreScreeningAssessmentObservationMaximumCategory](ValueSet-us-core-screening-assessment-observation-maximum-category.md),[USCoreServiceRequestCategoryCodes](ValueSet-us-core-servicerequest-category.md),[USCoreServiceRequestProfile](StructureDefinition-us-core-servicerequest.md),[USCoreSimpleObservationCategory](ValueSet-us-core-simple-observation-category.md),[USCoreSimpleObservationProfile](StructureDefinition-us-core-simple-observation.md)and[USCoreTreatmentInterventionPreferenceProfile](StructureDefinition-us-core-treatment-intervention-preference.md)
* [US Core DocumentReferences Category Codes](CodeSystem-us-core-documentreference-category.md): [Bundle/docref-example-1](Bundle-docref-example-1.md), [Bundle/docref-example-2](Bundle-docref-example-2.md)...Show 4 more,[DocumentReference/discharge-summary](DocumentReference-discharge-summary.md),[DocumentReference/episode-summary](DocumentReference-episode-summary.md),[USCoreDocumentReferenceCategory](ValueSet-us-core-documentreference-category.md)and[USCoreDocumentReferenceProfile](StructureDefinition-us-core-documentreference.md)
* [US Core Provenance Participant Type Extension Codes](CodeSystem-us-core-provenance-participant-type.md): [USCoreProvenance](StructureDefinition-us-core-provenance.md) and [USCoreProvenancePaticipantTypeCodes](ValueSet-us-core-provenance-participant-type.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/5.5.0/CodeSystem-v3-rxNorm.html): [Medication/uscore-med1](Medication-uscore-med1.md), [Medication/uscore-med2](Medication-uscore-med2.md)...Show 8 more,[MedicationDispense/medicationdispense-example](MedicationDispense-medicationdispense-example.md),[MedicationRequest/medicationrequest-coded-oral-axid](MedicationRequest-medicationrequest-coded-oral-axid.md),[MedicationRequest/medicationrequest-contained-oral-axid](MedicationRequest-medicationrequest-contained-oral-axid.md),[MedicationRequest/self-tylenol](MedicationRequest-self-tylenol.md),[USCoreAllergyIntolerance](StructureDefinition-us-core-allergyintolerance.md),[USCoreMedicationDispenseProfile](StructureDefinition-us-core-medicationdispense.md),[USCoreMedicationProfile](StructureDefinition-us-core-medication.md)and[USCoreMedicationRequestProfile](StructureDefinition-us-core-medicationrequest.md)


### Expansion Parameters

In HL7 FHIR, expansion parameters are special query parameters that you can pass to a ValueSet $expand operation to control and customize how the ValueSet is expanded (i.e., how the full list of codes/concepts is generated from the ValueSet definition). US Core uses the following parameters.

* Parameter: system-version
  * Value: SNOMED CT[US]

### Parameter Settings

The following [IG Parameters](https://confluence.hl7.org/display/FHIR/Implementation+Guide+Parameters) are set for this Implementation Guide:

* code: copyrightyear
value: 2025+
* code: releaselabel
value: STU 8
* code: path-resource
value: input/resources
* code: path-resource
value: fsh-generated/resources
* code: path-pages
value: input/pagecontent
* code: path-pages
value: input/intro-notes
* code: path-pages
value: fsh-generated/includes
* code: path-expansion-params
value: ../../input/_resources/exp-params.json
* code: active-tables
value: false
* code: apply-contact
value: true
* code: apply-jurisdiction
value: true
* code: apply-publisher
value: true
* code: apply-version
value: true
* code: show-inherited-invariants
value: false
* code: usage-stats-opt-out
value: true
* code: suppressed-ids
value: DocumentReference/discharge-summary
* code: tabbed-snapshots
value: false
* code: no-narrative
value: DocumentReference/discharge-summary
* code: no-narrative
value: Bundle/docref-example-1
* code: no-narrative
value: Bundle/docref-example-2
* code: version-comparison-master
value: 7.0.0
* code: version-comparison
value: 7.0.0
* code: version-comparison
value: 6.1.0
* code: version-comparison
value: 5.0.1
* code: version-comparison
value: 4.0.0
* code: version-comparison
value: 3.1.1
* code: html-exempt
value: comparison-argo/vs-observation-status-us-core-observation-smoking-status-status.html
* code: html-exempt
value: comparison-argo/sd-argo-diagnosticreport-us-core-diagnosticreport-note.html
* code: html-exempt
value: comparison-argo/vs-c80-doc-typecodes-us-core-documentreference-type.html
* code: html-exempt
value: comparison-argo/sd-argo-procedure-us-core-procedure.html
* code: html-exempt
value: comparison-argo/vs-medication-codes-2.16.840.1.113762.1.4.1010.4.html
* code: html-exempt
value: comparison-argo/vs-condition-category-condition-category.html
* code: html-exempt
value: comparison-argo/index.html
* code: html-exempt
value: comparison-argo/vs-observation-ccdavitalsignresult-2.16.840.1.113883.3.88.12.80.62.html
* code: html-exempt
value: comparison-argo/sd-argo-patient-us-core-patient.html
* code: html-exempt
value: comparison-argo/vs-languages-Languages.html
* code: html-exempt
value: comparison-argo/sd-argo-goal-us-core-goal.html
* code: html-exempt
value: comparison-argo/vs-device-kind-device-kind.html
* code: html-exempt
value: comparison-argo/sd-argo-medication-us-core-medication.html
* code: html-exempt
value: comparison-argo/sd-argo-vitalsigns-us-core-vital-signs.html
* code: html-exempt
value: comparison-argo/sd-argo-allergyintolerance-us-core-allergyintolerance.html
* code: html-exempt
value: comparison-argo/sd-argo-condition-us-core-condition-encounter-diagnosis.html
* code: html-exempt
value: comparison-argo/sd-argo-observationresults-us-core-observation-clinical-result.html
* code: html-exempt
value: comparison-argo/sd-argo-documentreference-us-core-documentreference.html
* code: html-exempt
value: comparison-argo/vs-formatcodes-v3-HL7FormatCodes.html
* code: html-exempt
value: comparison-argo/sd-argo-birthsex-us-core-birthsex.html
* code: html-exempt
value: comparison-argo/sd-argo-smokingstatus-us-core-smokingstatus.html
* code: html-exempt
value: comparison-argo/sd-argo-immunization-us-core-immunization.html
* code: html-exempt
value: comparison-argo/sd-argo-diagnosticreport-us-core-diagnosticreport-lab.html
* code: html-exempt
value: comparison-argo/vs-report-codes-us-core-diagnosticreport-report-and-note-codes.html
* code: html-exempt
value: comparison-argo/sd-argo-condition-us-core-condition-problems-health-concerns.html
* code: html-exempt
value: comparison-argo/sd-argo-device-us-core-implantable-device.html
* code: html-exempt
value: comparison-argo/sd-argo-race-us-core-race.html
* code: html-exempt
value: comparison-argo/vs-observation-codes-us-core-laboratory-test-codes.html
* code: html-exempt
value: comparison-argo/vs-procedure-type-us-core-procedure-code.html
* code: html-exempt
value: comparison-argo/vs-observation-codes-2.16.840.1.113762.1.4.1267.6.html
* code: html-exempt
value: comparison-argo/sd-argo-careplan-us-core-careplan.html
* code: html-exempt
value: comparison-argo/vs-report-codes-us-core-laboratory-test-codes.html
* code: html-exempt
value: comparison-argo/vs-vacc-status-immunization-status.html
* code: html-exempt
value: comparison-argo/sd-argo-observationresults-us-core-observation-lab.html
* code: html-exempt
value: comparison-argo/sd-argo-ethnicity-us-core-ethnicity.html
* code: html-exempt
value: comparison-argo/vs-narrative-status-us-core-narrative-status.html
* code: ipa-comparison
value: {current}
* code: logging
value: tx
* code: logging
value: html
* code: logging
value: generate
* code: logging
value: init
* code: logging
value: progress
* code: auto-oid-root
value: 2.16.840.1.113883.4.642.40.2
* code: path-history
value: http://hl7.org/fhir/us/core/history.html

