# Immunization Example 1 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Example 1**

## Example Immunization: Immunization Example 1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Immunization Profileversion: null8.0.1)](StructureDefinition-us-core-immunization.md)

**status**: Completed

**vaccineCode**: Influenza, high-dose, quadrivalent, PF

**patient**: [Amy Shaw](Patient-example.md)

**encounter**: [Office Visit](Encounter-example-1.md)

**occurrence**: 2020-11-19 12:46:57-0800

**primarySource**: false

**location**: [Holy Family Hospital](Location-hospital.md)

**lotNumber**: AAJN11K

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Dr Ronald Bone](Practitioner-practitioner-1.md) |



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "imm-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|8.0.1"
    ]
  },
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/cvx",
        "code" : "197",
        "display" : "Influenza, high-dose, quadrivalent, PF"
      },
      {
        "system" : "http://hl7.org/fhir/sid/ndc",
        "code" : "49281012165",
        "display" : "FLUZONE High-Dose Quadrivalent Northern Hemisphere, 10 SYRINGE, GLASS in 1 PACKAGE (49281-121-65) > .7 mL in 1 SYRINGE, GLASS (49281-121-88) (package)"
      }
    ],
    "text" : "Influenza, high-dose, quadrivalent, PF"
  },
  "patient" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1",
    "display" : "Office Visit"
  },
  "occurrenceDateTime" : "2020-11-19T12:46:57-08:00",
  "primarySource" : false,
  "location" : {
    "reference" : "Location/hospital",
    "display" : "Holy Family Hospital"
  },
  "lotNumber" : "AAJN11K",
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/practitioner-1",
        "display" : "Dr Ronald Bone"
      }
    }
  ]
}

```
