# Goal 2 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Goal 2 Example**

## Example Goal: Goal 2 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Goal Profileversion: null8.0.1)](StructureDefinition-us-core-goal.md)

**lifecycleStatus**: Active

**description**: In paid employment

**subject**: [Amy Shaw](Patient-example.md)

### Targets

| | |
| :--- | :--- |
| - | **Due[x]** |
| * | 2022-02-01 |

**expressedBy**: [Amy Shaw](Patient-example.md)



## Resource Content

```json
{
  "resourceType" : "Goal",
  "id" : "goal-sdoh-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|8.0.1"
    ]
  },
  "lifecycleStatus" : "active",
  "description" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "406156006",
        "display" : "In paid employment"
      }
    ],
    "text" : "In paid employment"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "target" : [
    {
      "dueDate" : "2022-02-01"
    }
  ],
  "expressedBy" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  }
}

```
