# Goal 1 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Goal 1 Example**

## Example Goal: Goal 1 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Goal Profileversion: null8.0.1)](StructureDefinition-us-core-goal.md)

**lifecycleStatus**: Active

**description**: Patient is targeting a pulse oximetry of 92% and a weight of 195 lbs

**subject**: [Amy Shaw](Patient-example.md)

### Targets

| | |
| :--- | :--- |
| - | **Due[x]** |
| * | 2016-04-05 |

**expressedBy**: [Dr Ronald Bone](Practitioner-practitioner-1.md)



## Resource Content

```json
{
  "resourceType" : "Goal",
  "id" : "goal-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|8.0.1"
    ]
  },
  "lifecycleStatus" : "active",
  "description" : {
    "text" : "Patient is targeting a pulse oximetry of 92% and a weight of 195 lbs"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "target" : [
    {
      "dueDate" : "2016-04-05"
    }
  ],
  "expressedBy" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Dr Ronald Bone"
  }
}

```
