# Encounter 1 Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter 1 Example**

## Example Encounter: Encounter 1 Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2024-01-28 16:06:21-0800

Profile: [US Core Encounter Profileversion: null8.0.1)](StructureDefinition-us-core-encounter.md)

**US Core Interpreter Needed Extension**: [SNOMED CT: 373066001](http://snomed.info/id/373066001) (Yes (qualifier value))

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**type**: Office Visit

**subject**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**period**: 2015-11-01 17:00:14-0500 --> 2015-11-01 18:00:14-0500

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Holy Family Hospital](Location-hospital.md) |



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "example-1",
  "meta" : {
    "lastUpdated" : "2024-01-28T16:06:21-08:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|8.0.1"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-interpreter-needed",
      "valueCoding" : {
        "system" : "http://snomed.info/sct",
        "code" : "373066001"
      }
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://www.ama-assn.org/go/cpt",
          "code" : "99211"
        }
      ],
      "text" : "Office Visit"
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "period" : {
    "start" : "2015-11-01T17:00:14-05:00",
    "end" : "2015-11-01T18:00:14-05:00"
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/hospital",
        "display" : "Holy Family Hospital"
      }
    }
  ]
}

```
