# DiagnosticReport Cardiology Report Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DiagnosticReport Cardiology Report Example**

## Example DiagnosticReport: DiagnosticReport Cardiology Report Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core DiagnosticReport Profile for Report and Note Exchangeversion: null8.0.1)](StructureDefinition-us-core-diagnosticreport-note.md)

## Cardiovascular physiologic and EKG assessment panel (Cardiology ) 

| | |
| :--- | :--- |
| Subject | Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, )) |
| When For | 2021-11-10 21:39:30+0000 |

**Report Details**

* **Code**: [QRS dur {EKG lead}](Observation-qrs-dur-ekg-lead.md)
  * **Value**: 60 ms(Details: UCUM codems = 'ms')
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [Pulse intensity Palpation](Observation-pulse-intensity-palpation.md)
  * **Value**: 1+
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [P-R interval {EKG lead}](Observation-p-r-interval-ekg-lead.md)
  * **Value**: 0.2 s(Details: UCUM codes = 's')
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [Q-T interval {EKG lead}](Observation-q-t-interval-ekg-lead.md)
  * **Value**: 0.4 s(Details: UCUM codes = 's')
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [Jugular vein distension](Observation-jugular-vein-distension.md)
  * **Value**: Absent
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [Heart rate rhythm](Observation-heart-rate-rhythm.md)
  * **Value**: Regular (R)
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [EKG lead](Observation-ekg-lead.md)
  * **Value**: II
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [EKG impression](Observation-ekg-impression.md)
  * **Value**: Normal Sinus Rhythm (NSR)
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800
* **Code**: [Capillary refill Time Nail Bed](Observation-capillary-refill-time-nail-bed.md)
  * **Value**: 1 s(Details: UCUM codes = 's')
  * **Flags**: Final
  * **When For**: 2021-11-10 16:48:57-0800



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "cardiology-report",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "LP29708-2",
          "display" : "Cardiology"
        }
      ],
      "text" : "Cardiology"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "45033-8",
        "display" : "Cardiovascular physiologic and EKG assessment panel"
      }
    ],
    "text" : "Cardiovascular physiologic and EKG assessment panel"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2021-11-10T21:39:30.000Z",
  "resultsInterpreter" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/qrs-dur-ekg-lead"
    },
    {
      "reference" : "Observation/pulse-intensity-palpation"
    },
    {
      "reference" : "Observation/p-r-interval-ekg-lead"
    },
    {
      "reference" : "Observation/q-t-interval-ekg-lead"
    },
    {
      "reference" : "Observation/jugular-vein-distension"
    },
    {
      "reference" : "Observation/heart-rate-rhythm"
    },
    {
      "reference" : "Observation/ekg-lead"
    },
    {
      "reference" : "Observation/ekg-impression"
    },
    {
      "reference" : "Observation/capillary-refill-time-nail-bed"
    }
  ],
  "media" : [
    {
      "link" : {
        "reference" : "Media/ekg-strip",
        "display" : "EKG Strip"
      }
    }
  ],
  "presentedForm" : [
    {
      "contentType" : "application/pdf",
      "url" : "http://example.org/fhir/pdfdownloads/cardiopanel-report-123.pdf",
      "hash" : "RVFILy4uQWdNRQo="
    }
  ]
}

```
