# DXA Bone density quantitative measurement panel Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DXA Bone density quantitative measurement panel Example**

## Example DiagnosticReport: DXA Bone density quantitative measurement panel Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core DiagnosticReport Profile for Report and Note Exchangeversion: null8.0.1)](StructureDefinition-us-core-diagnosticreport-note.md)

## DXA Bone density quantitative measurement panel (Radiology ) 

| | |
| :--- | :--- |
| Subject | Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, )) |
| When For | 2021-11-10 19:30:46-0800 |

**Report Details**

* **Code**: [DXA Hip-L Z-score BMD](Observation-dxa-hip-l-z-score-bmd.md)
  * **Value**: -0.19 Z-Score(Details: UCUM code1 = '1')
  * **Flags**: Final
  * **When For**: 2021-11-10 19:14:41-0800
* **Code**: [DXA Hip-L T-score BMD](Observation-dxa-hip-l-t-score-bmd.md)
  * **Value**: -1.62 T-Score(Details: UCUM code1 = '1')
  * **Flags**: Final
  * **When For**: 2021-11-10 19:14:41-0800
* **Code**: [DXA Hip-L ArMass BMD](Observation-dxa-hip-l-armass-bmd.md)
  * **Value**: 0.734 g/cm2(Details: UCUM codeg/cm2 = 'g/cm2')
  * **Flags**: Final
  * **When For**: 2021-11-10 19:14:41-0800
* **Code**: [DXA Femur-L Z-score BMD](Observation-dxa-femur-l-z-score-bmd.md)
  * **Value**: 0.05 Z-Score(Details: UCUM code1 = '1')
  * **Flags**: Final
  * **When For**: 2021-11-10 19:14:41-0800
* **Code**: [DXA Femur-L T-score BMD](Observation-dxa-femur-l-t-score-bmd.md)
  * **Value**: -1.48 T-Score(Details: UCUM code1 = '1')
  * **Flags**: Final
  * **When For**: 2021-11-10 19:14:41-0800
* **Code**: [DXA Femur-L ArMass BMD](Observation-dxa-femur-l-armass-bmd.md)
  * **Value**: 0.631 g/cm2(Details: UCUM codeg/cm2 = 'g/cm2')
  * **Flags**: Final
  * **When For**: 2021-11-10 19:14:41-0800



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "bone-density-report",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|8.0.1"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "LP29684-5",
          "display" : "Radiology"
        }
      ],
      "text" : "Radiology"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "83311-1",
        "display" : "Bone density quantitative measurement by DXA panel"
      }
    ],
    "text" : "DXA Bone density quantitative measurement panel"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2021-11-10T19:30:46-08:00",
  "resultsInterpreter" : [
    {
      "reference" : "Practitioner/practitioner-1",
      "display" : "Dr Ronald Bone"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/dxa-hip-l-z-score-bmd"
    },
    {
      "reference" : "Observation/dxa-hip-l-t-score-bmd"
    },
    {
      "reference" : "Observation/dxa-hip-l-armass-bmd"
    },
    {
      "reference" : "Observation/dxa-femur-l-z-score-bmd"
    },
    {
      "reference" : "Observation/dxa-femur-l-t-score-bmd"
    },
    {
      "reference" : "Observation/dxa-femur-l-armass-bmd"
    }
  ],
  "presentedForm" : [
    {
      "contentType" : "application/pdf",
      "data" : "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"
    }
  ]
}

```
