# Device Knee Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Device Knee Example**

## Example Device: Device Knee Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

version: 2; Last updated: 2019-04-11 16:21:48+0000

Profile: [US Core Implantable Device Profileversion: null8.0.1)](StructureDefinition-us-core-implantable-device.md)

### UdiCarriers

| | | | |
| :--- | :--- | :--- | :--- |
| - | **DeviceIdentifier** | **CarrierHRF** | **EntryType** |
| * | 987979879879 | (01)987979879879(11)191015(17)220101(10)M320(21)AC221 | RFID |

**status**: Active

**manufacturer**: ACME Biomedical

**manufactureDate**: 2015-10-15

**expirationDate**: 2022-01-01

**lotNumber**: M320

**serialNumber**: AC221

### DeviceNames

| | | |
| :--- | :--- | :--- |
| - | **Name** | **Type** |
| * | ACME Knee Replacement Device | UDI Label name |

**modelNumber**: 1.0

**type**: Knee joint prosthesis

**patient**: [Amy V. Shaw](Patient-example.md)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "udi-3",
  "meta" : {
    "versionId" : "2",
    "lastUpdated" : "2019-04-11T16:21:48.921+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|8.0.1"
    ]
  },
  "udiCarrier" : [
    {
      "deviceIdentifier" : "987979879879",
      "carrierHRF" : "(01)987979879879(11)191015(17)220101(10)M320(21)AC221",
      "entryType" : "rfid"
    }
  ],
  "status" : "active",
  "manufacturer" : "ACME Biomedical",
  "manufactureDate" : "2015-10-15",
  "expirationDate" : "2022-01-01",
  "lotNumber" : "M320",
  "serialNumber" : "AC221",
  "deviceName" : [
    {
      "name" : "ACME Knee Replacement Device",
      "type" : "udi-label-name"
    }
  ],
  "modelNumber" : "1.0",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "109228008",
        "display" : "Knee joint prosthesis"
      }
    ],
    "text" : "Knee joint prosthesis"
  },
  "patient" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  }
}

```
