# Coverage Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage Example**

## Example Coverage: Coverage Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Coverage Profileversion: null8.0.1)](StructureDefinition-us-core-coverage.md)

**identifier**: Member Number/88800933501

**status**: Active

**type**: PPO

**subscriberId**: 888009335

**beneficiary**: [Amy V. Baxter (no stated gender), DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-example.md)

**relationship**: Self

**period**: 2020-01-01 --> (ongoing)

**payor**: [Acme Health Plan](Organization-acme-payer.md)

> **class****type**:An employee group**value**: xyz**name**: XYZ employee Group Plan

> **class****type**:A specific suite of benefits.**value**: gold**name**: Acme Gold Plan



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "coverage-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|8.0.1"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MB",
            "display" : "Member Number"
          }
        ]
      },
      "system" : "http://example.org/fhir/memberidentifier",
      "value" : "88800933501"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "https://nahdo.org/sopt",
        "code" : "3712",
        "display" : "PPO"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "code" : "PPO",
        "display" : "preferred provider organization policy"
      }
    ],
    "text" : "PPO"
  },
  "subscriberId" : "888009335",
  "beneficiary" : {
    "reference" : "Patient/example"
  },
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self"
      }
    ],
    "text" : "Self"
  },
  "period" : {
    "start" : "2020-01-01"
  },
  "payor" : [
    {
      "reference" : "Organization/acme-payer",
      "display" : "Acme Health Plan"
    }
  ],
  "class" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "group",
            "display" : "Group"
          }
        ],
        "text" : "An employee group"
      },
      "value" : "xyz",
      "name" : "XYZ employee Group Plan"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "plan",
            "display" : "Plan"
          }
        ],
        "text" : "A specific suite of benefits."
      },
      "value" : "gold",
      "name" : "Acme Gold Plan"
    }
  ]
}

```
