# Encounter Diagnosis Example 2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Diagnosis Example 2**

## Example Condition: Encounter Diagnosis Example 2

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Condition Encounter Diagnosis Profileversion: null8.0.1)](StructureDefinition-us-core-condition-encounter-diagnosis.md)

**category**: Encounter Diagnosis

**code**: Single live birth, born in hospital

**subject**: [Amy V. Shaw](Patient-example.md)

**encounter**: [Encounter: status = finished; class = inpatient encounter (ActCode#IMP); type = Normal delivery procedure (procedure)](Encounter-delivery.md)

**recordedDate**: 2016-08-10 07:15:07-0800

**recorder**: [Dr Ronald Bone](Practitioner-practitioner-1.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "encounter-diagnosis-example2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|8.0.1"
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "encounter-diagnosis",
          "display" : "Encounter Diagnosis"
        }
      ],
      "text" : "Encounter Diagnosis"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "442311008",
        "display" : "Liveborn born in hospital"
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "code" : "Z38.00",
        "display" : "Single liveborn infant, delivered vaginally"
      }
    ],
    "text" : "Single live birth, born in hospital"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/delivery"
  },
  "recordedDate" : "2016-08-10T07:15:07-08:00",
  "recorder" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Dr Ronald Bone"
  }
}

```
