# Encounter Diagnosis Example 1 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter Diagnosis Example 1**

## Example Condition: Encounter Diagnosis Example 1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core Condition Encounter Diagnosis Profileversion: null8.0.1)](StructureDefinition-us-core-condition-encounter-diagnosis.md)

**category**: Encounter Diagnosis

**code**: Burnt Ear

**subject**: [Amy Shaw](Patient-example.md)

**encounter**: [Encounter: extension = Yes (qualifier value) (SNOMED CT#373066001); status = finished; class = ambulatory (ActCode#AMB); type = Office or other outpatient visit for the evaluation and management of an established patient that may not require the presence of a physician or other qualified health care professional; period = 2015-11-01 17:00:14-0500 --> 2015-11-01 18:00:14-0500](Encounter-example-1.md)

**recordedDate**: 2015-11-01

**recorder**: [Dr Ronald Bone](Practitioner-practitioner-1.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "encounter-diagnosis-example1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|8.0.1"
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "encounter-diagnosis",
          "display" : "Encounter Diagnosis"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "39065001",
        "display" : "Burn of ear"
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "code" : "T20.21",
        "display" : "Burn of second degree of ear [any part, except ear drum]"
      }
    ],
    "text" : "Burnt Ear"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/example-1"
  },
  "recordedDate" : "2015-11-01",
  "recorder" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Dr Ronald Bone"
  }
}

```
