# SDOH Problem/Health Concern Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SDOH Problem/Health Concern Example**

## Example Condition: SDOH Problem/Health Concern Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2016-08-10 07:15:07-0800

Profile: [US Core Condition Problems and Health Concerns Profileversion: null8.0.1)](StructureDefinition-us-core-condition-problems-health-concerns.md)

**Condition Asserted Date**: 2016-08-10

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Problem List Item, Social Determinants Of Health

**code**: Nutrition impaired due to limited access to healthful foods (finding)

**subject**: [Amy V. Shaw](Patient-example.md)

**recordedDate**: 2016-08-10 07:15:07-0800

**recorder**: [Dr Ronald Bone](Practitioner-practitioner-1.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "condition-SDOH-example",
  "meta" : {
    "lastUpdated" : "2016-08-10T07:15:07-08:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|8.0.1"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2016-08-10"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "problem-list-item",
          "display" : "Problem List Item"
        }
      ],
      "text" : "Problem List Item"
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ],
      "text" : "Social Determinants Of Health"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "445281000124101",
        "display" : "Nutrition impaired due to limited access to healthful foods (finding)"
      }
    ],
    "text" : "Nutrition impaired due to limited access to healthful foods (finding)"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "recordedDate" : "2016-08-10T07:15:07-08:00",
  "recorder" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Dr Ronald Bone"
  }
}

```
