# US Core Condition Category Extension Codes - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core Condition Category Extension Codes**

## CodeSystem: US Core Condition Category Extension Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core/CodeSystem/condition-category | *Version*:8.0.1 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:USCoreConditionCategoryExtensionCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.2.16.2 | | |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
Set of codes that are needed for implementation of the US-Core Condition Profile. These codes are used as extensions to the FHIR and US Core value sets. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [USCoreProblemOrHealthConcern](ValueSet-us-core-problem-or-health-concern.md)

**Changes since version 7.0.0:**

* One or more text definitions/displays have changed



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "condition-category",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cgp"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.2.16.2"
    }
  ],
  "version" : "8.0.1",
  "name" : "USCoreConditionCategoryExtensionCodes",
  "title" : "US Core Condition Category Extension Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-09-29T14:59:24-07:00",
  "publisher" : "HL7 International / Cross-Group Projects",
  "contact" : [
    {
      "name" : "HL7 International / Cross-Group Projects",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cgp"
        },
        {
          "system" : "email",
          "value" : "cgp@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Set of codes that are needed for implementation of the US-Core Condition Profile. These codes are used as extensions to the FHIR and US Core value sets.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "caseSensitive" : true,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, retired",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "problem",
      "display" : "Problem",
      "definition" : "The patients problems as identified by the provider(s). Items on the provider's problem list. Note that this code has been deprecated and is replaced by the http://terminology.hl7.org/CodeSystem/condition-category concept \"problem-list-item\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "code" : "health-concern",
      "display" : "Health Concern",
      "definition" : "Additional health concerns from other stakeholders"
    }
  ]
}

```
