# Docref Example 2 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Docref Example 2**

## Example Bundle: Docref Example 2



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "docref-example-2",
  "type" : "searchset",
  "total" : 3,
  "link" : [
    {
      "relation" : "self",
      "url" : "http://example.org/fhir/DocumentReference/$docref?patient=123&start=2019-01-01&end=2019-01-01&type=http://terminology.hl7.org/CodeSystem/c80-doc-typecodes|18842-5,http://terminology.hl7.org/CodeSystem/c80-doc-typecodes|28570-0&ondemand=true"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/DocumentReference/procedure-note123",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "procedure-note123",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"
          ]
        },
        "identifier" : [
          {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:oid:2.16.840.1.113883.19.5.99999.1"
          }
        ],
        "status" : "current",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "28570-0",
              "display" : "Procedure Note"
            }
          ],
          "text" : "Procedure Note"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
                "code" : "clinical-note",
                "display" : "Clinical Note"
              }
            ],
            "text" : "Clinical Note"
          }
        ],
        "subject" : {
          "reference" : "Patient/example",
          "display" : "Amy Shaw"
        },
        "date" : "2022-11-18T20:45:05Z",
        "author" : [
          {
            "reference" : "Practitioner/practitioner-1",
            "display" : "Ronald Bone, MD"
          }
        ],
        "description" : "Ureteroscopy",
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "http://example.org/fhir/Binary/procedure-note123.pdf"
            }
          }
        ],
        "context" : {
          "period" : {
            "start" : "2019-03-01",
            "end" : "2019-03-02"
          }
        }
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/DocumentReference/procedure-note456",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "procedure-note456",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"
          ]
        },
        "status" : "current",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "28570-0",
              "display" : "Procedure Note"
            }
          ],
          "text" : "Procedure Note"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
                "code" : "clinical-note",
                "display" : "Clinical Note"
              }
            ],
            "text" : "Clinical Note"
          }
        ],
        "subject" : {
          "reference" : "Patient/example",
          "display" : "Amy Shaw"
        },
        "date" : "2022-11-18T20:45:05Z",
        "author" : [
          {
            "reference" : "Practitioner/practitioner-1",
            "display" : "Ronald Bone, MD"
          }
        ],
        "description" : "Ureteroscopy",
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "http://example.org/fhir/Binary/procedure-note456.pdf"
            }
          }
        ],
        "context" : {
          "period" : {
            "start" : "2019-06-01",
            "end" : "2019-06-01"
          }
        }
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/DocumentReference/discharge",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "discharge",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"
          ]
        },
        "status" : "current",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18842-5",
              "display" : "Discharge Summary"
            }
          ],
          "text" : "Discharge Summary"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
                "code" : "clinical-note",
                "display" : "Clinical Note"
              }
            ],
            "text" : "Clinical Note"
          }
        ],
        "subject" : {
          "reference" : "Patient/example",
          "display" : "Amy Shaw"
        },
        "date" : "2022-11-18T20:45:05Z",
        "author" : [
          {
            "reference" : "Practitioner/practitioner-1",
            "display" : "Ronald Bone, MD"
          }
        ],
        "description" : "Ureteroscopy",
        "content" : [
          {
            "attachment" : {
              "contentType" : "application/pdf",
              "url" : "http://example.org/fhir/Binary/discharge-summary789.pdf"
            }
          }
        ],
        "context" : {
          "period" : {
            "start" : "2019-03-01",
            "end" : "2019-03-03"
          }
        }
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
