# Docref Example 1 - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Docref Example 1**

## Example Bundle: Docref Example 1



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "docref-example-1",
  "type" : "searchset",
  "total" : 1,
  "link" : [
    {
      "relation" : "self",
      "url" : "http://example.org/fhir/DocumentReference/$docref?patient=123"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/DocumentReference/ccd123",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "ccd123",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"
          ]
        },
        "identifier" : [
          {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:oid:2.16.840.1.113883.19.5.99999.1"
          }
        ],
        "status" : "current",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34133-9",
              "display" : "Summary of episode note"
            }
          ],
          "text" : "CCD Document"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
                "code" : "clinical-note",
                "display" : "Clinical Note"
              }
            ],
            "text" : "Clinical Note"
          }
        ],
        "subject" : {
          "reference" : "Patient/example",
          "display" : "Amy Shaw"
        },
        "date" : "2016-03-09T15:29:46Z",
        "author" : [
          {
            "reference" : "Practitioner/practitioner-1",
            "display" : "Ronald Bone, MD"
          }
        ],
        "description" : "Pulmonology clinic acute visit",
        "content" : [
          {
            "attachment" : {
              "contentType" : "text/plain",
              "url" : "http://example.org/fhir/Binary/1-note",
              "title" : "URI where the data can be found: http://example.org/fhir/Binary/1-note"
            },
            "format" : {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes",
              "code" : "urn:hl7-org:sdwg:ccda-structuredBody:2.1",
              "display" : "ccda-structuredBody:2.1"
            }
          }
        ],
        "context" : {
          "period" : {
            "start" : "2004-12-23T08:00:00+11:00",
            "end" : "2004-12-23T08:01:00+11:00"
          }
        }
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
