# AllergyIntolerance Non-pharmacologic Agent Example - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntolerance Non-pharmacologic Agent Example**

## Example AllergyIntolerance: AllergyIntolerance Non-pharmacologic Agent Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Core AllergyIntolerance Profileversion: null8.0.1)](StructureDefinition-us-core-allergyintolerance.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Environment

**criticality**: High Risk

**code**: Latex

**patient**: [Amy V. Shaw](Patient-example.md)

**recorder**: [Dr Ronald Bone](Practitioner-practitioner-1.md)

### Reactions

| | | |
| :--- | :--- | :--- |
| - | **Manifestation** | **Severity** |
| * | skin rash | Mild |



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "non-pharmacologic-agent-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance|8.0.1"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed"
      }
    ]
  },
  "category" : ["environment"],
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "111088007",
        "display" : "Latex (substance)"
      }
    ],
    "text" : "Latex"
  },
  "patient" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "recorder" : {
    "reference" : "Practitioner/practitioner-1",
    "display" : "Dr Ronald Bone"
  },
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/731000124108",
              "code" : "271807003",
              "display" : "skin rash"
            }
          ],
          "text" : "skin rash"
        }
      ],
      "severity" : "mild"
    }
  ]
}

```
