# VSAC to FHIR Code System Mapping Table - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Terminology**](terminology.md)
* **VSAC to FHIR Code System Mapping Table**

## VSAC to FHIR Code System Mapping Table

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The following table maps the VSAC Code System Names to the FHIR Code System URIs. It is based off the [VSAC's FHIR Server Capability Statement](https://cts.nlm.nih.gov/fhir/metadata). This information is also available as a [csv](tables/vsacname-fhiruri-map.csv) or [excel](tables/vsacname-fhiruri-map.xlsx) file.

| | |
| :--- | :--- |
| ActMood | http://terminology.hl7.org/CodeSystem/v3-ActMood |
| ActPriority | http://terminology.hl7.org/CodeSystem/v3-ActPriority |
| ActReason | http://terminology.hl7.org/CodeSystem/v3-ActReason |
| ActRelationshipType | http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType |
| ActStatus | http://terminology.hl7.org/CodeSystem/v3-ActStatus |
| AddressUse | http://terminology.hl7.org/CodeSystem/v3-AddressUse |
| AdministrativeGender | http://terminology.hl7.org/CodeSystem/v3-AdministrativeGender |
| AdministrativeSex | http://terminology.hl7.org/CodeSystem/v2-0001 |
| CDCNHSN | https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/cdcnhsn.html |
| CDCREC | urn:oid:2.16.840.1.113883.6.238 |
| CDT | http://www.ada.org/cdt |
| CPT | http://www.ama-assn.org/go/cpt |
| CVX | http://hl7.org/fhir/sid/cvx |
| Confidentiality | http://terminology.hl7.org/CodeSystem/v3-Confidentiality |
| DataAbsentReason | http://terminology.hl7.org/CodeSystem/data-absent-reason |
| DischargeDisposition | http://terminology.hl7.org/CodeSystem/v2-0112 |
| EntityNamePartQualifier | http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifier |
| EntityNameUse | http://terminology.hl7.org/CodeSystem/v3-EntityNameUse |
| EventTiming | http://hl7.org/fhir/event-timing |
| HCPCS | http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets |
| HSLOC | https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html |
| HealthCareProviderTaxonomy | http://nucc.org/provider-taxonomy |
| ICD10CM | http://hl7.org/fhir/sid/icd-10-cm |
| ICD10PCS | http://www.cms.gov/Medicare/Coding/ICD10 |
| ICD9CM | http://hl7.org/fhir/sid/icd-9-cm |
| LOINC | http://loinc.org |
| LanguageAbilityMode | http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityMode |
| LanguageAbilityProficiency | http://terminology.hl7.org/CodeSystem/v3-LanguageAbilityProficiency |
| LivingArrangement | http://terminology.hl7.org/CodeSystem/v3-LivingArrangement |
| MED-RT | http://www.nlm.nih.gov/research/umls/MED-RT |
| MaritalStatus | http://terminology.hl7.org/CodeSystem/v3-MaritalStatus |
| MediaType | http://terminology.hl7.org/CodeSystem/v3-mediaType |
| NCI | http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl |
| NDFRT | http://hl7.org/fhir/ndfrt |
| NullFlavor | http://terminology.hl7.org/CodeSystem/v3-NullFlavor |
| ObservationInterpretation | http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation |
| ObservationValue | http://terminology.hl7.org/CodeSystem/v3-ObservationValue |
| ParticipationFunction | http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction |
| ParticipationMode | http://terminology.hl7.org/CodeSystem/v3-ParticipationMode |
| ParticipationType | http://terminology.hl7.org/CodeSystem/v3-ParticipationType |
| PresentOnAdmission | https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding |
| RXNORM | http://www.nlm.nih.gov/research/umls/rxnorm |
| ReligiousAffiliation | http://terminology.hl7.org/CodeSystem/v3-ReligiousAffiliation |
| RoleClass | http://terminology.hl7.org/CodeSystem/v3-RoleClass |
| RoleCode | http://terminology.hl7.org/CodeSystem/v3-RoleCode |
| RoleStatus | http://terminology.hl7.org/CodeSystem/v3-RoleStatus |
| SNOMEDCT | http://snomed.info/sct |
| SOP | https://nahdo.org/sopt |
| TimingEvent | http://terminology.hl7.org/CodeSystem/v3-TimingEvent |
| UCUM | http://unitsofmeasure.org |
| UMLS | http://www.nlm.nih.gov/research/umls |
| UNII | http://fdasis.nlm.nih.gov |

