# USCDI - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **USCDI**

## USCDI

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The US Core Profiles were initially designed to meet the 2015 Edition certification criterion for Patient Selection 170.315(g)(7) and Application Access – Data Category Request 170.315(g)(8). US Core Editors have updated the guide annually to meet subsequent [U.S. Core Data for Interoperability (USCDI)](https://www.healthit.gov/isa/united-states-core-data-interoperability-uscdi) requirements:

| | |
| :--- | :--- |
| [v1](https://www.healthit.gov/isa/sites/isa/files/2020-07/USCDI-Version-1-July-2020-Errata-Final.pdf) | 3.1.1 |
| [v1](https://www.healthit.gov/isa/sites/isa/files/2020-07/USCDI-Version-1-July-2020-Errata-Final.pdf) | 4.0.0 (improved Must support guidance) |
| [v2](https://www.healthit.gov/sites/default/files/page/2021-07/Standards_Bulletin_2021-3.pdf) | 5.0.1 |
| [v3](https://www.healthit.gov/sites/default/files/page/2022-07/Standards_Bulletin_2022-2.pdf) | 6.1.0 |
| [v4](https://www.healthit.gov/sites/default/files/page/2023-07/Standards_Bulletin_2023-2.pdf) | 7.0.0 |
| [v5](https://www.healthit.gov/topic/standardsbulletin_24-2) | 8.0.1 |

ASTP's USCDI and FHIR US Core are complementary initiatives, with USCDI defining high-level data requirements and FHIR US Core providing detailed FHIR-based profiles for meeting those requirements. Mapping between them is necessary for achieving interoperability and consistency in healthcare data exchange within the United States. However, to make USCDI implementable in FHIR, an interpretation of USCDI is necessary. For information about what US Core Profile elements and US Core transactions are in scope for ASTP Health IT Certification, see the US Core [Conformance](conformance.md) pages.

Note that:

* USCDI Data Classes and Element names may differ from the FHIR US Core resource names and element names.
* Not every USCDI Data Class and Element is mapped to a single profile.
* Many US Core Profile elements do not map to a USCDI Data Classes and Element because US Core's usage is broader than certification and because additional US Core elements are required to make FHIR implementable.

Updates to US Core depend upon community input, and we encourage our audience to submit questions and feedback to US Core specifications by clicking on the **Propose a change** link in the footer of every page. In addition, we encourage our audience to request any necessary clarifications to USCDI through the [USCDI ONDEC process](https://www.healthit.gov/isa/ONDEC) that will help inform future updates to FHIR US Core.

The table below defines the relationship between the USCDI Data Classes and Elements and USCore profiles. It lists the US Core Profile used for the corresponding Data Classes and Elements. This information and [FHIRPath](http://hl7.org/fhir/R4/fhirpath.html) expressions to USCDI Data Classes and Elements are available as a [csv](tables/uscdi-table.csv) or [excel](tables/uscdi-table.xlsx) file:

US Core Data for Interoperability USCDI

| | | |
| :--- | :--- | :--- |
|     •Substance (Medication) | [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) |  |
|     •Substance (Drug Class) | [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) |  |
|     •Substance (Non-Medication) | [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) |  |
|     •Reaction | [US Core AllergyIntolerance Profile](StructureDefinition-us-core-allergyintolerance.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Name | [US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md)[US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md) |  |
|     •Identifier | [US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md)[US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Location | [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md)[US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md)[US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md) |  |
|     •Telecom | [US Core PractitionerRole Profile](StructureDefinition-us-core-practitionerrole.md)[US Core Practitioner Profile](StructureDefinition-us-core-practitioner.md)[US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md) |  |
|     •Role | [US Core CareTeam Profile](StructureDefinition-us-core-careteam.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Consultation Note | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) |  |
|     •Discharge Summary Note | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) |  |
|     •History & Physical | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) |  |
|     •Imaging Narrative | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md)[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) |  |
|     •Procedure Note | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md)[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) |  |
|     •Progress Note | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) |  |
|     •Operative Note | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) |  |
|     •Emergency Department Note | [US Core DocumentReference Profile](StructureDefinition-us-core-documentreference.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Clinical Test | [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md)[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) |  |
|     •Clinical Test Result/Report | [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md)[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Diagnostic Imaging Test | [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md)[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) |  |
|     •Diagnostic Imaging Result/Report | [US Core Observation Clinical Result Profile](StructureDefinition-us-core-observation-clinical-result.md)[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Identifier | [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) |  |
|     •Type | [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) |  |
|     •Diagnosis | [US Core Condition Encounter Diagnosis Profile](StructureDefinition-us-core-condition-encounter-diagnosis.md) |  |
|     •Time | [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) |  |
|     •Location | [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) |  |
|     •Disposition | [US Core Encounter Profile](StructureDefinition-us-core-encounter.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Identifier | [US Core Location Profile](StructureDefinition-us-core-location.md) |  |
|     •Type | [US Core Location Profile](StructureDefinition-us-core-location.md) |  |
|     •Name | [US Core Location Profile](StructureDefinition-us-core-location.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Patient Goals | [US Core Goal Profile](StructureDefinition-us-core-goal.md) |  |
|     •SDOH Goals | [US Core Goal Profile](StructureDefinition-us-core-goal.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •Treatment Intervention Preference | [US Core Treatment Intervention Preference Profile](StructureDefinition-us-core-treatment-intervention-preference.md) |  |
|     •Care Experience Preference | [US Core Care Experience Preference Profile](StructureDefinition-us-core-care-experience-preference.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Coverage Status | [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) |  |
|     •Coverage Type | [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) |  |
|     •Relationship to Subscriber | [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) |  |
|     •Member Identifier | [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) |  |
|     •Subscriber Identifier | [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) |  |
|     •Group Number | [US Core Coverage Profile](StructureDefinition-us-core-coverage.md) |  |
|     •Payer Identifier | [US Core Coverage Profile](StructureDefinition-us-core-coverage.md)[US Core Organization Profile](StructureDefinition-us-core-organization.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Health Concerns | [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md) |  |
|     •Functional Status | [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •Disability Status | [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •Mental/Cognitive Status | [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •Pregnancy Status | [US Core Observation Pregnancy Status Profile](StructureDefinition-us-core-observation-pregnancystatus.md)[US Core Observation Pregnancy Intent Profile](StructureDefinition-us-core-observation-pregnancyintent.md) |  |
|     •Alcohol Use | [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •Substance Use | [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •Physical Activity | [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •SDOH Assessment | [US Core Simple Observation Profile](StructureDefinition-us-core-simple-observation.md)[US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[US Core Observation Screening Assessment Profile](StructureDefinition-us-core-observation-screening-assessment.md)[US Core QuestionnaireResponse Profile](StructureDefinition-us-core-questionnaireresponse.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |
|     •Smoking Status | [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Immunizations | [US Core Immunization Profile](StructureDefinition-us-core-immunization.md) |  |
|     •Lot Number | [US Core Immunization Profile](StructureDefinition-us-core-immunization.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Tests | [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md)[US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) |  |
|     •Values/Results | [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md)[US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) |  |
|     •Specimen Type | [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md)[US Core Specimen Profile](StructureDefinition-us-core-specimen.md) |  |
|     •Result Status | [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md)[US Core DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-us-core-diagnosticreport-lab.md) |  |
|     •Result Unit of Measure | [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md) |  |
|     •Result Reference Range | [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md) |  |
|     •Result Interpretation | [US Core Laboratory Result Observation Profile](StructureDefinition-us-core-observation-lab.md) |  |
|     •Specimen Identifier | [US Core Specimen Profile](StructureDefinition-us-core-specimen.md) |  |
|     •Specimen Source Site | [US Core Specimen Profile](StructureDefinition-us-core-specimen.md) |  |
|     •Specimen Condition Acceptability | [US Core Specimen Profile](StructureDefinition-us-core-specimen.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Unique Device Identifier(s) for a Patient's Implantable Device(s) | [US Core Implantable Device Profile](StructureDefinition-us-core-implantable-device.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Medications | [US Core Medication Profile](StructureDefinition-us-core-medication.md)[US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) |  |
|     •Dose | [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) |  |
|     •Dose Unit of Measure | [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) |  |
|     •Route of Administration | [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md)[US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md) |  |
|     •Indication | [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) |  |
|     •Medication Instructions | [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) |  |
|     •Medication Adherence | [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md)[US Core Medication Adherence Extension](StructureDefinition-us-core-medication-adherence.md) |  |
|     •Fill Status | [US Core MedicationDispense Profile](StructureDefinition-us-core-medicationdispense.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Advance Directive Observation | [US Core Observation ADI Documentation Profile](StructureDefinition-us-core-observation-adi-documentation.md)[US Core ADI DocumentReference Profile](StructureDefinition-us-core-adi-documentreference.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Medication Order | [US Core MedicationRequest Profile](StructureDefinition-us-core-medicationrequest.md) |  |
|     •Laboratory Order | [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) |  |
|     •Diagnostic Imaging Order | [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) |  |
|     •Clinical Test Order | [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) |  |
|     •Procedure Order | [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md) |  |

| | | |
| :--- | :--- | :--- |
|     •First Name | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Last Name | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Previous Name | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Middle Name (including middle initial) | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Suffix | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Sex | [US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core Individual Sex Extension](StructureDefinition-us-core-individual-sex.md) |  |
|     •Date of Birth | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Date of Death | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Race | [US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core Race Extension](StructureDefinition-us-core-race.md) |  |
|     •Ethnicity | [US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core Ethnicity Extension](StructureDefinition-us-core-ethnicity.md) |  |
|     •Tribal Affiliation | [US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core Tribal Affiliation Extension](StructureDefinition-us-core-tribal-affiliation.md) |  |
|     •Preferred Language | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Interpreter Needed | [US Core Patient Profile](StructureDefinition-us-core-patient.md)[US Core Encounter Profile](StructureDefinition-us-core-encounter.md)[US Core Interpreter Needed Extension](StructureDefinition-us-core-interpreter-needed.md) |  |
|     •Address | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Previous Address | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Email | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Phone Number | [US Core Patient Profile](StructureDefinition-us-core-patient.md) |  |
|     •Related Person's Name | [US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md) |  |
|     •Related Person's Relationship | [US Core RelatedPerson Profile](StructureDefinition-us-core-relatedperson.md) |  |
|     •Occupation | [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md) |  |
|     •Occupation Industry | [US Core Observation Occupation Profile](StructureDefinition-us-core-observation-occupation.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Assessment and Plan of Treatment | [US Core CarePlan Profile](StructureDefinition-us-core-careplan.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Date of Resolution | [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[assertedDate Extension](http://hl7.org/fhir/extensions/5.2.0/) |  |
|     •Date of Diagnosis | [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md)[assertedDate Extension](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-condition-assertedDate.html) |  |
|     •SDOH Problems/Health Concerns | [US Core Condition Problems and Health Concerns Profile](StructureDefinition-us-core-condition-problems-health-concerns.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |

| | | |
| :--- | :--- | :--- |
|     •Procedure | [US Core Procedure Profile](StructureDefinition-us-core-procedure.md) |  |
|     •Performance Time | [US Core Procedure Profile](StructureDefinition-us-core-procedure.md)[US Core DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-us-core-diagnosticreport-note.md)[US Core Immunization Profile](StructureDefinition-us-core-immunization.md) |  |
|     •Reason for Referral | [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md)[US Core Procedure Profile](StructureDefinition-us-core-procedure.md) |  |
|     •SDOH Interventions | [US Core ServiceRequest Profile](StructureDefinition-us-core-servicerequest.md)[US Core Procedure Profile](StructureDefinition-us-core-procedure.md) | [See Screening and Assessments Guidance](screening-and-assessments.md) |

| | | |
| :--- | :--- | :--- |
|     •Author | [Individual Provenance](basic-provenance.md#individual-level-provenance) |  |
|     •Author Role | [Individual Provenance](basic-provenance.md#individual-level-provenance) |  |
|     •Author Time Stamp | [US Core Provenance Profile](StructureDefinition-us-core-provenance.md) |  |
|     •Author Organization | [US Core Provenance Profile](StructureDefinition-us-core-provenance.md) |  |

| | | |
| :--- | :--- | :--- |
|     •Average Blood Pressure | [US Core Average Blood Pressure Profile](StructureDefinition-us-core-average-blood-pressure.md) |  |
|     •Diastolic blood pressure | [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md) |  |
|     •Systolic blood pressure | [US Core Blood Pressure Profile](StructureDefinition-us-core-blood-pressure.md) |  |
|     •Body height | [US Core Body Height Profile](StructureDefinition-us-core-body-height.md) |  |
|     •Body weight | [US Core Body Weight Profile](StructureDefinition-us-core-body-weight.md) |  |
|     •Heart rate | [US Core Heart Rate Profile](StructureDefinition-us-core-heart-rate.md) |  |
|     •Respiratory rate | [US Core Respiratory Rate Profile](StructureDefinition-us-core-respiratory-rate.md) |  |
|     •Body temperature | [US Core Body Temperature Profile](StructureDefinition-us-core-body-temperature.md) |  |
|     •Pulse oximetry | [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md) |  |
|     •Inhaled oxygen concentration | [US Core Pulse Oximetry Profile](StructureDefinition-us-core-pulse-oximetry.md) |  |
|     •BMI Percentile (2-20 years old) | [US Core Pediatric BMI for Age Observation Profile](StructureDefinition-pediatric-bmi-for-age.md) |  |
|     •Weight-for-length Percentile (Birth - 36 months) | [US Core Pediatric Weight for Height Observation Profile](StructureDefinition-pediatric-weight-for-height.md) |  |
|     •Occipital Frontal Head Circumference Percentile (Birth - 36 months) | [US Core Pediatric Head Occipital Frontal Circumference Percentile Profile](StructureDefinition-head-occipital-frontal-circumference-percentile.md) |  |

