# Terminology - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

This page lists all the ValueSets, CodeSystems, and ConceptMaps defined as part of the US Core Implementation Guide. For more information on using codes in US Core, see the [FHIR Terminology](http://hl7.org/fhir/R4/terminologies.html) section in the FHIR specification and the [Coded Elements](general-requirements.md#using-codes-in-us-core-profiles) section in this guide.

### Value Sets

Most value sets used in this guide are defined in the base FHIR specification, [HL7 Terminology (THO)](https://terminology.hl7.org), or Value Set Authority Center (VSAC)]. However, US Core also defines several value sets and they are listed below.

Value sets in US Core and C-CDA may retain inactive codes. These codes may be useful for historical queries but are not recommended for new data. Implementers should note that some code systems exclude inactive codes from current expansions; if needed, these codes may be accessible through prior expansions via terminology services. HL7 recommends validators allow non-active codes with note on their status.

* [US Core Narrative Status](ValueSet-us-core-narrative-status.md)
* [US Core Clinical Note Type](ValueSet-us-core-clinical-note-type.md)
* [US Core Clinical Result Observation Category](ValueSet-us-core-clinical-result-observation-category.md)
* [US Core Condition Codes](ValueSet-us-core-condition-code.md)
* [US Core Condition Codes Current](ValueSet-us-core-condition-code-current.md)
* [US Core Diagnostic Report Category Codes](ValueSet-us-core-diagnosticreport-category.md)
* [US Core DocumentReference Category](ValueSet-us-core-documentreference-category.md)
* [US Core DocumentReference Type](ValueSet-us-core-documentreference-type.md)
* [US Core Goal Codes](ValueSet-us-core-goal-description.md)
* [US Core Laboratory Test Codes](ValueSet-us-core-laboratory-test-codes.md)
* [US Core Non Laboratory Codes](ValueSet-us-core-diagnosticreport-report-and-note-codes.md)
* [US Core Status for Smoking Status Observation](ValueSet-us-core-observation-smoking-status-status.md)
* [US Core Problem or Health Concern](ValueSet-us-core-problem-or-health-concern.md)
* [US Core Procedure Codes](ValueSet-us-core-procedure-code.md)
* [US Core Provenance Participant Type Codes](ValueSet-us-core-provenance-participant-type.md)
* [US Core Screening Assessment Condition Category](ValueSet-us-core-screening-assessment-condition-category.md)
* [US Core Screening Assessment Observation Category](ValueSet-us-core-screening-assessment-observation-category.md)
* [US Core Screening Assessment Observation Maximum Category](ValueSet-us-core-screening-assessment-observation-maximum-category.md)
* [US Core ServiceRequest Category Codes](ValueSet-us-core-servicerequest-category.md)
* [US Core Simple Observation Category](ValueSet-us-core-simple-observation-category.md)
* [US Core Specimen Condition](ValueSet-us-core-specimen-condition.md)

#### Value Sets Used in US Core

The following table lists all the Value sets used in US Core and where they can be found. This information is also available as a [csv](tables/valueset-ref-all-list.csv) or [excel](tables/valueset-ref-all-list.xlsx) file.

Value Set Sources:

* [VSAC](http://cts.nlm.nih.gov/fhir/)
* [FHIR](http://hl7.org/fhir/R4/)
* [US CORE](terminology.md)
* [PHINVADS](https://phinvads.cdc.gov/)
* [THO](http://terminology.hl7.org/)

| | | | |
| :--- | :--- | :--- | :--- |
| 1 |  | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | FHIR |
| 2 | [ActEncounterCode](http://terminology.hl7.org/ValueSet/v3-ActEncounterCode) | StructureDefinition/us-core-encounter | THO |
| 3 | [ActPharmacySupplyType](http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType) | StructureDefinition/us-core-medicationdispense | THO |
| 4 | [ActPriority](http://terminology.hl7.org/ValueSet/v3-ActPriority) | StructureDefinition/us-core-encounter | THO |
| 5 | [ActSubstanceAdminSubstitutionCode](http://terminology.hl7.org/ValueSet/v3-ActSubstanceAdminSubstitutionCode) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | THO |
| 6 | [AddressType](http://hl7.org/fhir/R4/valueset-address-type.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-locationStructureDefinition/us-core-organization | FHIR |
| 7 | [AddressUse](http://hl7.org/fhir/R4/valueset-address-use.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-locationStructureDefinition/us-core-organization | FHIR |
| 8 | [AdministrativeGender](http://hl7.org/fhir/R4/valueset-administrative-gender.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-relatedperson | FHIR |
| 9 | [Admit source](http://hl7.org/fhir/R4/valueset-encounter-admit-source.html) | StructureDefinition/us-core-encounter | FHIR |
| 10 | [Advance Healthcare Directive Categories LOINC](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.69.4/expansion) | StructureDefinition/us-core-adi-documentreference | VSAC |
| 11 | [Advance Healthcare Directive Document Types Grouper](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1115.41/expansion) | StructureDefinition/us-core-adi-documentreference | VSAC |
| 12 | [AllergyIntolerance Clinical Status Codes](http://hl7.org/fhir/R4/valueset-allergyintolerance-clinical.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 13 | [AllergyIntolerance Verification Status Codes](http://hl7.org/fhir/R4/valueset-allergyintolerance-verification.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 14 | [AllergyIntoleranceCategory](http://hl7.org/fhir/R4/valueset-allergy-intolerance-category.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 15 | [AllergyIntoleranceCriticality](http://hl7.org/fhir/R4/valueset-allergy-intolerance-criticality.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 16 | [AllergyIntoleranceSeverity](http://hl7.org/fhir/R4/valueset-reaction-event-severity.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 17 | [AllergyIntoleranceType](http://hl7.org/fhir/R4/valueset-allergy-intolerance-type.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 18 | [Answer Set with Yes No and Unknowns](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.16/expansion) | StructureDefinition/us-core-interpreter-neededStructureDefinition/us-core-observation-adi-documentation | VSAC |
| 19 | [Birth Sex](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.24/expansion) | StructureDefinition/us-core-birthsex | VSAC |
| 20 | [Body Length Units](http://hl7.org/fhir/R4/valueset-ucum-bodylength.html) | StructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-body-height | FHIR |
| 21 | [Body Temperature Units](http://hl7.org/fhir/R4/valueset-ucum-bodytemp.html) | StructureDefinition/us-core-body-temperature | FHIR |
| 22 | [Body Weight Units](http://hl7.org/fhir/R4/valueset-ucum-bodyweight.html) | StructureDefinition/us-core-body-weight | FHIR |
| 23 | [CMS Place of Service Codes (POS)](http://terminology.hl7.org/ValueSet/CMSPlaceOfServiceCodes) | StructureDefinition/us-core-location | THO |
| 24 | [CVX Vaccines Administered Vaccine Set](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.6/expansion) | StructureDefinition/us-core-immunization | VSAC |
| 25 | [Care Plan Activity Kind](http://hl7.org/fhir/R4/valueset-care-plan-activity-kind.html) | StructureDefinition/us-core-careplan | FHIR |
| 26 | [Care Plan Activity Outcome](http://hl7.org/fhir/R4/valueset-care-plan-activity-outcome.html) | StructureDefinition/us-core-careplan | FHIR |
| 27 | [Care Plan Category](http://hl7.org/fhir/R4/valueset-care-plan-category.html) | StructureDefinition/us-core-careplan | FHIR |
| 28 | [Care Plan Intent](http://hl7.org/fhir/R4/valueset-care-plan-intent.html) | StructureDefinition/us-core-careplan | FHIR |
| 29 | [Care Team Member Function](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.30/expansion) | StructureDefinition/us-core-careteamStructureDefinition/us-core-practitionerrole | VSAC |
| 30 | [Care Team category](http://hl7.org/fhir/R4/valueset-care-team-category.html) | StructureDefinition/us-core-careteam | FHIR |
| 31 | [CarePlanActivityStatus](http://hl7.org/fhir/R4/valueset-care-plan-activity-status.html) | StructureDefinition/us-core-careplan | FHIR |
| 32 | [CareTeamStatus](http://hl7.org/fhir/R4/valueset-care-team-status.html) | StructureDefinition/us-core-careteam | FHIR |
| 33 | [Codes for Immunization Site of Administration](http://hl7.org/fhir/R4/valueset-immunization-site.html) | StructureDefinition/us-core-immunization | FHIR |
| 34 | [Common Languages](http://hl7.org/fhir/R4/valueset-languages.html) | StructureDefinition/us-core-specimenStructureDefinition/us-core-documentreferenceStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/us-core-procedureStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-careplanStructureDefinition/us-core-organizationStructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-practitionerStructureDefinition/us-core-heart-rateStructureDefinition/us-core-practitionerroleStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-patientStructureDefinition/us-core-provenanceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-questionnaireresponseStructureDefinition/us-core-condition-encounter-diagnosisStructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-implantable-deviceStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-medicationdispenseStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-diagnosticreport-labStructureDefinition/us-core-encounterStructureDefinition/us-core-bmiStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-coverageStructureDefinition/us-core-servicerequestStructureDefinition/us-core-simple-observationStructureDefinition/us-core-diagnosticreport-noteStructureDefinition/us-core-medicationrequestStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-medicationStructureDefinition/us-core-goalStructureDefinition/us-core-careteamStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/us-core-relatedpersonStructureDefinition/us-core-immunizationStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-locationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-allergyintoleranceStructureDefinition/us-core-blood-pressure | FHIR |
| 35 | [Common Tags](http://hl7.org/fhir/R4/valueset-common-tags.html) | StructureDefinition/us-core-diagnosticreport-labStructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-encounterStructureDefinition/us-core-observation-lab | FHIR |
| 36 | [Common substances for allergy and intolerance documentation including refutations](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1186.8/expansion) | StructureDefinition/us-core-allergyintolerance | VSAC |
| 37 | [CompositionStatus](http://hl7.org/fhir/R4/valueset-composition-status.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | FHIR |
| 38 | [Condition Category Codes](http://hl7.org/fhir/R4/valueset-condition-category.html) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | FHIR |
| 39 | [Condition Clinical Status Codes](http://hl7.org/fhir/R4/valueset-condition-clinical.html) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | FHIR |
| 40 | [Condition Stage](http://hl7.org/fhir/R4/valueset-condition-stage.html) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | FHIR |
| 41 | [Condition Stage Type](http://hl7.org/fhir/R4/valueset-condition-stage-type.html) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | FHIR |
| 42 | [Condition/Diagnosis Severity](http://hl7.org/fhir/R4/valueset-condition-severity.html) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | FHIR |
| 43 | [Condition/Problem/Diagnosis Codes](http://hl7.org/fhir/R4/valueset-condition-code.html) | StructureDefinition/us-core-procedure | FHIR |
| 44 | [ConditionVerificationStatus](http://hl7.org/fhir/R4/valueset-condition-ver-status.html) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | FHIR |
| 45 | [Contact entity type](http://hl7.org/fhir/R4/valueset-contactentity-type.html) | StructureDefinition/us-core-organization | FHIR |
| 46 | [ContactPointSystem](http://hl7.org/fhir/R4/valueset-contact-point-system.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-practitionerroleStructureDefinition/us-core-organization | FHIR |
| 47 | [ContactPointUse](http://hl7.org/fhir/R4/valueset-contact-point-use.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-practitionerroleStructureDefinition/us-core-organization | FHIR |
| 48 | [Coverage Class Codes](http://hl7.org/fhir/R4/valueset-coverage-class.html) | StructureDefinition/us-core-coverage | FHIR |
| 49 | [Coverage Copay Type Codes](http://hl7.org/fhir/R4/valueset-coverage-copay-type.html) | StructureDefinition/us-core-coverage | FHIR |
| 50 | [DataAbsentReason](http://hl7.org/fhir/R4/valueset-data-absent-reason.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-simple-observationStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-heart-rateStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-blood-pressure | FHIR |
| 51 | [DaysOfWeek](http://hl7.org/fhir/R4/valueset-days-of-week.html) | StructureDefinition/us-core-practitionerroleStructureDefinition/us-core-location | FHIR |
| 52 | [Detailed Ethnicity Including Absence Reasons](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.4.642.40.2.48.1/expansion) | StructureDefinition/us-core-ethnicity | VSAC |
| 53 | [Detailed race including absence reasons.](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.25/expansion) | StructureDefinition/us-core-race | VSAC |
| 54 | [DeviceNameType](http://hl7.org/fhir/R4/valueset-device-nametype.html) | StructureDefinition/us-core-implantable-device | FHIR |
| 55 | [DiagnosisRole](http://hl7.org/fhir/R4/valueset-diagnosis-role.html) | StructureDefinition/us-core-encounter | FHIR |
| 56 | [Diagnostic Service Section Codes](http://hl7.org/fhir/R4/valueset-diagnostic-service-sections.html) | StructureDefinition/us-core-diagnosticreport-noteStructureDefinition/us-core-diagnosticreport-lab | FHIR |
| 57 | [DiagnosticReportStatus](http://hl7.org/fhir/R4/valueset-diagnostic-report-status.html) | StructureDefinition/us-core-diagnosticreport-noteStructureDefinition/us-core-diagnosticreport-lab | FHIR |
| 58 | [Diet](http://hl7.org/fhir/R4/valueset-encounter-diet.html) | StructureDefinition/us-core-encounter | FHIR |
| 59 | [Document Class Value Set](http://hl7.org/fhir/R4/valueset-document-classcodes.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | FHIR |
| 60 | [Document Type Value Set](http://hl7.org/fhir/R4/valueset-c80-doc-typecodes.html) | OperationDefinition/docref | FHIR |
| 61 | [DocumentReferenceStatus](http://hl7.org/fhir/R4/valueset-document-reference-status.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | FHIR |
| 62 | [DocumentRelationshipType](http://hl7.org/fhir/R4/valueset-document-relationship-type.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | FHIR |
| 63 | [DoseAndRateType](http://hl7.org/fhir/R4/valueset-dose-rate-type.html) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | FHIR |
| 64 | [Encounter Reason Codes](http://hl7.org/fhir/R4/valueset-encounter-reason.html) | StructureDefinition/us-core-encounter | FHIR |
| 65 | [Encounter Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.23/expansion) | StructureDefinition/us-core-encounter | VSAC |
| 66 | [EncounterLocationStatus](http://hl7.org/fhir/R4/valueset-encounter-location-status.html) | StructureDefinition/us-core-encounter | FHIR |
| 67 | [EncounterStatus](http://hl7.org/fhir/R4/valueset-encounter-status.html) | StructureDefinition/us-core-encounter | FHIR |
| 68 | [Ethnicity Categories](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.4.642.40.2.48.3/expansion) | StructureDefinition/us-core-ethnicity | VSAC |
| 69 | [EventStatus](http://hl7.org/fhir/R4/valueset-event-status.html) | StructureDefinition/us-core-procedure | FHIR |
| 70 | [Example Coverage Financial Exception Codes](http://hl7.org/fhir/R4/valueset-coverage-financial-exception.html) | StructureDefinition/us-core-coverage | FHIR |
| 71 | [FHIR Device Types](http://hl7.org/fhir/R4/valueset-device-kind.html) | StructureDefinition/us-core-implantable-deviceStructureDefinition/us-core-procedure | FHIR |
| 72 | [FHIR Specimen Collection Method](http://hl7.org/fhir/R4/valueset-specimen-collection-method.html) | StructureDefinition/us-core-specimen | FHIR |
| 73 | [FHIRDeviceStatus](http://hl7.org/fhir/R4/valueset-device-status.html) | StructureDefinition/us-core-implantable-device | FHIR |
| 74 | [FHIRDeviceStatusReason](http://hl7.org/fhir/R4/valueset-device-status-reason.html) | StructureDefinition/us-core-implantable-device | FHIR |
| 75 | [Facility Type Code Value Set](http://hl7.org/fhir/R4/valueset-c80-facilitycodes.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | FHIR |
| 76 | [Federal Administrative Sex](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.121/expansion) | StructureDefinition/us-core-individual-sex | VSAC |
| 77 | [Financial Resource Status Codes](http://hl7.org/fhir/R4/valueset-fm-status.html) | StructureDefinition/us-core-coverage | FHIR |
| 78 | [Gender Identity](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1021.32/expansion) | StructureDefinition/us-core-genderIdentity | VSAC |
| 79 | [Goal achievement status](http://hl7.org/fhir/R4/valueset-goal-achievement.html) | StructureDefinition/us-core-goal | FHIR |
| 80 | [Goal category](http://hl7.org/fhir/R4/valueset-goal-category.html) | StructureDefinition/us-core-goal | FHIR |
| 81 | [Goal priority](http://hl7.org/fhir/R4/valueset-goal-priority.html) | StructureDefinition/us-core-goal | FHIR |
| 82 | [Goal start event](http://hl7.org/fhir/R4/valueset-goal-start-event.html) | StructureDefinition/us-core-goal | FHIR |
| 83 | [GoalLifecycleStatus](http://hl7.org/fhir/R4/valueset-goal-status.html) | StructureDefinition/us-core-goal | FHIR |
| 84 | [HL7 ValueSet of Format Codes for use with Document Sharing](http://terminology.hl7.org/ValueSet/v3-HL7FormatCodes) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | THO |
| 85 | [Healthcare Provider Taxonomy](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.1066/expansion) | StructureDefinition/us-core-practitionerrole | VSAC |
| 86 | [Healthcare Service Location Type Combined](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.31/expansion) | StructureDefinition/us-core-location | VSAC |
| 87 | [IdentifierType](http://hl7.org/fhir/R4/valueset-identifier-type.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-encounterStructureDefinition/us-core-coverageStructureDefinition/us-core-organization | FHIR |
| 88 | [IdentifierUse](http://hl7.org/fhir/R4/valueset-identifier-use.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-encounterStructureDefinition/us-core-coverageStructureDefinition/us-core-organization | FHIR |
| 89 | [Immunization Function Codes](http://hl7.org/fhir/R4/valueset-immunization-function.html) | StructureDefinition/us-core-immunization | FHIR |
| 90 | [Immunization Funding Source](http://hl7.org/fhir/R4/valueset-immunization-funding-source.html) | StructureDefinition/us-core-immunization | FHIR |
| 91 | [Immunization Origin Codes](http://hl7.org/fhir/R4/valueset-immunization-origin.html) | StructureDefinition/us-core-immunization | FHIR |
| 92 | [Immunization Program Eligibility](http://hl7.org/fhir/R4/valueset-immunization-program-eligibility.html) | StructureDefinition/us-core-immunization | FHIR |
| 93 | [Immunization Reason Codes](http://hl7.org/fhir/R4/valueset-immunization-reason.html) | StructureDefinition/us-core-immunization | FHIR |
| 94 | [Immunization Route Codes](http://hl7.org/fhir/R4/valueset-immunization-route.html) | StructureDefinition/us-core-immunization | FHIR |
| 95 | [Immunization Status Codes](http://hl7.org/fhir/R4/valueset-immunization-status.html) | StructureDefinition/us-core-immunization | FHIR |
| 96 | [Immunization Status Reason Codes](http://hl7.org/fhir/R4/valueset-immunization-status-reason.html) | StructureDefinition/us-core-immunization | FHIR |
| 97 | [Immunization Subpotent Reason](http://hl7.org/fhir/R4/valueset-immunization-subpotent-reason.html) | StructureDefinition/us-core-immunization | FHIR |
| 98 | [Immunization Target Disease Codes](http://hl7.org/fhir/R4/valueset-immunization-target-disease.html) | StructureDefinition/us-core-immunization | FHIR |
| 99 | [Industry NAICS Detail (ODH)](https://phinvads.cdc.gov/vads/ViewValueSet.action?oid=2.16.840.1.114222.4.11.7900) | StructureDefinition/us-core-observation-occupation | PHINVADS |
| 100 | [Information Source for Medication Adherence](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.11/expansion) | StructureDefinition/us-core-medication-adherence | VSAC |
| 101 | [LOINC Codes](http://hl7.org/fhir/R4/valueset-observation-codes.html) | StructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-goalStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-observation-labStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/us-core-simple-observationStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-observation-adi-documentation | FHIR |
| 102 | [Languages](http://terminology.hl7.org/ValueSet/Languages) | StructureDefinition/us-core-patient | THO |
| 103 | [LinkType](http://hl7.org/fhir/R4/valueset-link-type.html) | StructureDefinition/us-core-patient | FHIR |
| 104 | [Location type](http://hl7.org/fhir/R4/valueset-location-physical-type.html) | StructureDefinition/us-core-encounterStructureDefinition/us-core-location | FHIR |
| 105 | [LocationMode](http://hl7.org/fhir/R4/valueset-location-mode.html) | StructureDefinition/us-core-location | FHIR |
| 106 | [LocationStatus](http://hl7.org/fhir/R4/valueset-location-status.html) | StructureDefinition/us-core-location | FHIR |
| 107 | [Manifestation and Symptom Codes](http://hl7.org/fhir/R4/valueset-manifestation-or-symptom.html) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | FHIR |
| 108 | [MaritalStatus](http://hl7.org/fhir/R4/valueset-marital-status.html) | StructureDefinition/us-core-patient | FHIR |
| 109 | [Medication status codes](http://hl7.org/fhir/R4/valueset-medication-status.html) | StructureDefinition/us-core-medication | FHIR |
| 110 | [Medication Adherence](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.8/expansion) | StructureDefinition/us-core-medication-adherence | VSAC |
| 111 | [Medication Clinical Drug](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1010.4/expansion) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationStructureDefinition/us-core-medicationdispense | VSAC |
| 112 | [Medication dispense category codes](http://hl7.org/fhir/R4/valueset-medicationdispense-category.html) | StructureDefinition/us-core-medicationdispense | FHIR |
| 113 | [Medication dispense performer function codes](http://hl7.org/fhir/R4/valueset-medicationdispense-performer-function.html) | StructureDefinition/us-core-medicationdispense | FHIR |
| 114 | [Medication dispense status codes](http://hl7.org/fhir/R4/valueset-medicationdispense-status.html) | StructureDefinition/us-core-medicationdispense | FHIR |
| 115 | [Medication dispense status reason codes](http://hl7.org/fhir/R4/valueset-medicationdispense-status-reason.html) | StructureDefinition/us-core-medicationdispense | FHIR |
| 116 | [Medication request category codes](http://hl7.org/fhir/R4/valueset-medicationrequest-category.html) | StructureDefinition/us-core-medicationrequest | FHIR |
| 117 | [Medication request course of therapy codes](http://hl7.org/fhir/R4/valueset-medicationrequest-course-of-therapy.html) | StructureDefinition/us-core-medicationrequest | FHIR |
| 118 | [Medication request intent](http://hl7.org/fhir/R4/valueset-medicationrequest-intent.html) | StructureDefinition/us-core-medicationrequest | FHIR |
| 119 | [Medication request status reason codes](http://hl7.org/fhir/R4/valueset-medicationrequest-status-reason.html) | StructureDefinition/us-core-medicationrequest | FHIR |
| 120 | [Medicationrequest status](http://hl7.org/fhir/R4/valueset-medicationrequest-status.html) | StructureDefinition/us-core-medicationrequest | FHIR |
| 121 | [MimeType](http://hl7.org/fhir/R4/valueset-mimetypes.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | FHIR |
| 122 | [NameUse](http://hl7.org/fhir/R4/valueset-name-use.html) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patient | FHIR |
| 123 | [Observation Category Codes](http://hl7.org/fhir/R4/valueset-observation-category.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-observation-labStructureDefinition/us-core-bmiStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-vital-signsStructureDefinition/us-core-head-circumferenceStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-heart-rateStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-blood-pressure | FHIR |
| 124 | [Observation Interpretation Codes](http://hl7.org/fhir/R4/valueset-observation-interpretation.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-simple-observationStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-heart-rateStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-blood-pressure | FHIR |
| 125 | [Observation Methods](http://hl7.org/fhir/R4/valueset-observation-methods.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-simple-observationStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-heart-rateStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-blood-pressure | FHIR |
| 126 | [Observation Reference Range Applies To Codes](http://hl7.org/fhir/R4/valueset-referencerange-appliesto.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-simple-observationStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-heart-rateStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-blood-pressure | FHIR |
| 127 | [Observation Reference Range Meaning Codes](http://hl7.org/fhir/R4/valueset-referencerange-meaning.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-simple-observationStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-heart-rateStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-blood-pressure | FHIR |
| 128 | [ObservationStatus](http://hl7.org/fhir/R4/valueset-observation-status.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-simple-observationStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-heart-rateStructureDefinition/us-core-body-heightStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-blood-pressure | FHIR |
| 129 | [Occupation ONETSOC Detail (ODH)](https://phinvads.cdc.gov/vads/ViewValueSet.action?oid=2.16.840.1.114222.4.11.7901) | StructureDefinition/us-core-observation-occupation | PHINVADS |
| 130 | [Organization type](http://hl7.org/fhir/R4/valueset-organization-type.html) | StructureDefinition/us-core-organization | FHIR |
| 131 | [Participant Roles](http://hl7.org/fhir/R4/valueset-participant-role.html) | StructureDefinition/us-core-servicerequest | FHIR |
| 132 | [Participant type](http://hl7.org/fhir/R4/valueset-encounter-participant-type.html) | StructureDefinition/us-core-encounter | FHIR |
| 133 | [Patient Contact Relationship](http://hl7.org/fhir/R4/valueset-patient-contactrelationship.html) | StructureDefinition/us-core-patient | FHIR |
| 134 | [Patient relationship type](http://hl7.org/fhir/R4/valueset-relatedperson-relationshiptype.html) | StructureDefinition/us-core-relatedperson | FHIR |
| 135 | [Payer Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.114222.4.11.3591/expansion) | StructureDefinition/us-core-coverage | VSAC |
| 136 | [Practice Setting Code Value Set](http://hl7.org/fhir/R4/valueset-c80-practice-codes.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | FHIR |
| 137 | [Pregnancy Intention](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1166.22/expansion) | StructureDefinition/us-core-observation-pregnancyintent | VSAC |
| 138 | [Pregnancy Status Observation](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.12/expansion) | StructureDefinition/us-core-observation-pregnancystatus | VSAC |
| 139 | [Procedure Category Codes (SNOMED CT)](http://hl7.org/fhir/R4/valueset-procedure-category.html) | StructureDefinition/us-core-procedure | FHIR |
| 140 | [Procedure Codes (SNOMED CT)](http://hl7.org/fhir/R4/valueset-procedure-code.html) | StructureDefinition/us-core-careplan | FHIR |
| 141 | [Procedure Device Action Codes](http://hl7.org/fhir/R4/valueset-device-action.html) | StructureDefinition/us-core-procedure | FHIR |
| 142 | [Procedure Follow up Codes (SNOMED CT)](http://hl7.org/fhir/R4/valueset-procedure-followup.html) | StructureDefinition/us-core-procedure | FHIR |
| 143 | [Procedure Not Performed Reason (SNOMED-CT)](http://hl7.org/fhir/R4/valueset-procedure-not-performed-reason.html) | StructureDefinition/us-core-procedure | FHIR |
| 144 | [Procedure Outcome Codes (SNOMED CT)](http://hl7.org/fhir/R4/valueset-procedure-outcome.html) | StructureDefinition/us-core-procedure | FHIR |
| 145 | [Procedure Performer Role Codes](http://hl7.org/fhir/R4/valueset-performer-role.html) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-procedure | FHIR |
| 146 | [Provenance activity type](http://hl7.org/fhir/R4/valueset-provenance-activity-type.html) | StructureDefinition/us-core-provenance | FHIR |
| 147 | [ProvenanceEntityRole](http://hl7.org/fhir/R4/valueset-provenance-entity-role.html) | StructureDefinition/us-core-provenance | FHIR |
| 148 | [PurposeOfUse](http://terminology.hl7.org/ValueSet/v3-PurposeOfUse) | StructureDefinition/us-core-provenance | THO |
| 149 | [QuantityComparator](http://hl7.org/fhir/R4/valueset-quantity-comparator.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-head-circumferenceStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-heart-rateStructureDefinition/us-core-body-weightStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-body-heightStructureDefinition/us-core-blood-pressure | FHIR |
| 150 | [Questionnaire Answer Codes](http://hl7.org/fhir/R4/valueset-questionnaire-answers.html) | StructureDefinition/us-core-questionnaireresponse | FHIR |
| 151 | [QuestionnaireResponseStatus](http://hl7.org/fhir/R4/valueset-questionnaire-answers-status.html) | StructureDefinition/us-core-questionnaireresponse | FHIR |
| 152 | [Race Categories](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.4.642.2.575/expansion) | StructureDefinition/us-core-race | VSAC |
| 153 | [Request priority](http://hl7.org/fhir/R4/valueset-request-priority.html) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-servicerequest | FHIR |
| 154 | [RequestIntent](http://hl7.org/fhir/R4/valueset-request-intent.html) | StructureDefinition/us-core-servicerequest | FHIR |
| 155 | [RequestStatus](http://hl7.org/fhir/R4/valueset-request-status.html) | StructureDefinition/us-core-careplanStructureDefinition/us-core-servicerequest | FHIR |
| 156 | [ResourceType](http://hl7.org/fhir/R4/valueset-resource-types.html) | StructureDefinition/us-core-provenance | FHIR |
| 157 | [Route of Administration of Therapeutic Agents](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.22/expansion) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | VSAC |
| 158 | [SNOMED CT Additional Dosage Instructions](http://hl7.org/fhir/R4/valueset-additional-instruction-codes.html) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | FHIR |
| 159 | [SNOMED CT Administration Method Codes](http://hl7.org/fhir/R4/valueset-administration-method-codes.html) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | FHIR |
| 160 | [SNOMED CT Anatomical Structure for Administration Site Codes](http://hl7.org/fhir/R4/valueset-approach-site-codes.html) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | FHIR |
| 161 | [SNOMED CT Body Structures](http://hl7.org/fhir/R4/valueset-body-site.html) | StructureDefinition/us-core-specimenStructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/us-core-observation-pregnancyintentStructureDefinition/us-core-procedureStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-observation-labStructureDefinition/us-core-vital-signsStructureDefinition/us-core-servicerequestStructureDefinition/us-core-simple-observationStructureDefinition/us-core-head-circumferenceStructureDefinition/us-core-heart-rateStructureDefinition/us-core-smokingstatusStructureDefinition/us-core-body-heightStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-observation-screening-assessmentStructureDefinition/us-core-condition-encounter-diagnosisStructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-body-weightStructureDefinition/us-core-observation-pregnancystatusStructureDefinition/us-core-observation-occupationStructureDefinition/us-core-average-blood-pressureStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-sexual-orientationStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-blood-pressure | FHIR |
| 162 | [SNOMED CT Clinical Findings](http://hl7.org/fhir/R4/valueset-clinical-findings.html) | StructureDefinition/us-core-diagnosticreport-noteStructureDefinition/us-core-diagnosticreport-labStructureDefinition/us-core-careteamStructureDefinition/us-core-goalStructureDefinition/us-core-careplanStructureDefinition/us-core-allergyintolerance | FHIR |
| 163 | [SNOMED CT Form Codes](http://hl7.org/fhir/R4/valueset-medication-form-codes.html) | StructureDefinition/us-core-medication | FHIR |
| 164 | [SNOMED CT Medication As Needed Reason Codes](http://hl7.org/fhir/R4/valueset-medication-as-needed-reason.html) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispenseStructureDefinition/us-core-servicerequest | FHIR |
| 165 | [SNOMED CT Medication Codes](http://hl7.org/fhir/R4/valueset-medication-codes.html) | StructureDefinition/us-core-careplan | FHIR |
| 166 | [SNOMED CT Route Codes](http://hl7.org/fhir/R4/valueset-route-codes.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 167 | [Screening and Assessment Survey Codes](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.13/expansion) | StructureDefinition/us-core-observation-screening-assessment | VSAC |
| 168 | [SecurityLabels](http://hl7.org/fhir/R4/valueset-security-labels.html) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-diagnosticreport-labStructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-documentreferenceStructureDefinition/us-core-encounterStructureDefinition/us-core-observation-lab | FHIR |
| 169 | [SecurityRoleType](http://hl7.org/fhir/R4/valueset-security-role-type.html) | StructureDefinition/us-core-provenance | FHIR |
| 170 | [Service Request Category Codes](http://hl7.org/fhir/R4/valueset-servicerequest-category.html) | ValueSet/us-core-servicerequest-categoryStructureDefinition/us-core-servicerequest | FHIR |
| 171 | [Service Request Order Details Codes](http://hl7.org/fhir/R4/valueset-servicerequest-orderdetail.html) | StructureDefinition/us-core-servicerequest | FHIR |
| 172 | [Service type](http://hl7.org/fhir/R4/valueset-service-type.html) | StructureDefinition/us-core-encounter | FHIR |
| 173 | [ServiceDeliveryLocationRoleType](http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType) | StructureDefinition/us-core-locationStructureDefinition/us-core-servicerequest | THO |
| 174 | [Sex](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.3/expansion) | StructureDefinition/us-core-sex | VSAC |
| 175 | [Sexual Orientation Including nulls and Data Absent Reason](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1240.11/expansion) | StructureDefinition/us-core-observation-sexual-orientation | VSAC |
| 176 | [Smoking Status Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.6/expansion) | StructureDefinition/us-core-smokingstatus | VSAC |
| 177 | [Smoking status comprehensive](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.3/expansion) | StructureDefinition/us-core-smokingstatus | VSAC |
| 178 | [Social Determinants of Health Goals](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.71/expansion) | StructureDefinition/us-core-goal | VSAC |
| 179 | [Special arrangements](http://hl7.org/fhir/R4/valueset-encounter-special-arrangements.html) | StructureDefinition/us-core-encounter | FHIR |
| 180 | [Special courtesy](http://hl7.org/fhir/R4/valueset-encounter-special-courtesy.html) | StructureDefinition/us-core-encounter | FHIR |
| 181 | [Specimen Condition SCT](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1267.24/expansion) | ValueSet/us-core-specimen-condition | VSAC |
| 182 | [Specimen Container Type](http://hl7.org/fhir/R4/valueset-specimen-container-type.html) | StructureDefinition/us-core-specimen | FHIR |
| 183 | [Specimen processing procedure](http://hl7.org/fhir/R4/valueset-specimen-processing-procedure.html) | StructureDefinition/us-core-specimen | FHIR |
| 184 | [Specimen type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1099.54/expansion) | StructureDefinition/us-core-specimen | VSAC |
| 185 | [SpecimenStatus](http://hl7.org/fhir/R4/valueset-specimen-status.html) | StructureDefinition/us-core-specimen | FHIR |
| 186 | [SubscriberPolicyholder Relationship Codes](http://hl7.org/fhir/R4/valueset-subscriber-relationship.html) | StructureDefinition/us-core-coverage | FHIR |
| 187 | [Substance Code](http://hl7.org/fhir/R4/valueset-substance-code.html) | StructureDefinition/us-core-allergyintolerance | FHIR |
| 188 | [SubstanceAdminSubstitutionReason](http://terminology.hl7.org/ValueSet/v3-SubstanceAdminSubstitutionReason) | StructureDefinition/us-core-medicationrequestStructureDefinition/us-core-medicationdispense | THO |
| 189 | [TribalEntityUS](http://terminology.hl7.org/ValueSet/v3-TribalEntityUS) | StructureDefinition/us-core-tribal-affiliation | THO |
| 190 | [UDIEntryType](http://hl7.org/fhir/R4/valueset-udi-entry-type.html) | StructureDefinition/us-core-implantable-device | FHIR |
| 191 | [US Core Clinical Note Type](ValueSet-us-core-clinical-note-type.md) |  | US CORE |
| 192 | [US Core Clinical Result Observation Category](ValueSet-us-core-clinical-result-observation-category.md) | StructureDefinition/us-core-observation-clinical-resultStructureDefinition/us-core-observation-lab | US CORE |
| 193 | [US Core Condition Codes](ValueSet-us-core-condition-code.md) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-medicationrequestStructureDefinition/us-core-procedureStructureDefinition/us-core-servicerequestStructureDefinition/us-core-condition-encounter-diagnosis | US CORE |
| 194 | [US Core Condition Codes Current](ValueSet-us-core-condition-code-current.md) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-condition-encounter-diagnosis | US CORE |
| 195 | [US Core Diagnostic Report Category Codes](ValueSet-us-core-diagnosticreport-category.md) | StructureDefinition/us-core-diagnosticreport-note | US CORE |
| 196 | [US Core DocumentReference Category](ValueSet-us-core-documentreference-category.md) | StructureDefinition/us-core-documentreference | US CORE |
| 197 | [US Core DocumentReference Type](ValueSet-us-core-documentreference-type.md) | StructureDefinition/us-core-documentreference | US CORE |
| 198 | [US Core Goal Codes](ValueSet-us-core-goal-description.md) | StructureDefinition/us-core-goal | US CORE |
| 199 | [US Core Laboratory Test Codes](ValueSet-us-core-laboratory-test-codes.md) | StructureDefinition/us-core-diagnosticreport-labStructureDefinition/us-core-observation-lab | US CORE |
| 200 | [US Core Narrative Status](ValueSet-us-core-narrative-status.md) | StructureDefinition/us-core-careplan | US CORE |
| 201 | [US Core Non Laboratory Codes](ValueSet-us-core-diagnosticreport-report-and-note-codes.md) | StructureDefinition/us-core-diagnosticreport-note | US CORE |
| 202 | [US Core Problem or Health Concern](ValueSet-us-core-problem-or-health-concern.md) | StructureDefinition/us-core-condition-problems-health-concerns | US CORE |
| 203 | [US Core Procedure Codes](ValueSet-us-core-procedure-code.md) | StructureDefinition/us-core-procedureStructureDefinition/us-core-servicerequest | US CORE |
| 204 | [US Core Provenance Participant Type Codes](ValueSet-us-core-provenance-participant-type.md) | StructureDefinition/us-core-provenance | US CORE |
| 205 | [US Core Screening Assessment Condition Category](ValueSet-us-core-screening-assessment-condition-category.md) |  | US CORE |
| 206 | [US Core Screening Assessment Observation Category](ValueSet-us-core-screening-assessment-observation-category.md) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-observation-screening-assessment | US CORE |
| 207 | [US Core Screening Assessment Observation Maximum Category](ValueSet-us-core-screening-assessment-observation-maximum-category.md) | StructureDefinition/us-core-observation-screening-assessment | US CORE |
| 208 | [US Core ServiceRequest Category Codes](ValueSet-us-core-servicerequest-category.md) | StructureDefinition/us-core-servicerequest | US CORE |
| 209 | [US Core Simple Observation Category](ValueSet-us-core-simple-observation-category.md) | StructureDefinition/us-core-condition-problems-health-concernsStructureDefinition/us-core-care-experience-preferenceStructureDefinition/us-core-treatment-intervention-preferenceStructureDefinition/us-core-observation-adi-documentationStructureDefinition/us-core-simple-observation | US CORE |
| 210 | [US Core Specimen Condition](ValueSet-us-core-specimen-condition.md) | StructureDefinition/us-core-specimen | US CORE |
| 211 | [US Core Status for Smoking Status Observation](ValueSet-us-core-observation-smoking-status-status.md) | StructureDefinition/us-core-smokingstatus | US CORE |
| 212 | [USEncounterDischargeDisposition](http://terminology.hl7.org/ValueSet/v3-USEncounterDischargeDisposition) | StructureDefinition/us-core-encounter | THO |
| 213 | [USPS Two Letter Alphabetic Codes](http://terminology.hl7.org/ValueSet/USPS-State) | StructureDefinition/us-core-practitionerStructureDefinition/us-core-patientStructureDefinition/us-core-locationStructureDefinition/us-core-organizationStructureDefinition/us-core-jurisdiction | THO |
| 214 | [UnitsOfMeasureCaseSensitive](http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive) | StructureDefinition/us-core-smokingstatus | THO |
| 215 | [Vital Sign Result Type](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.62/expansion) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-vital-signsStructureDefinition/us-core-head-circumferenceStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-heart-rateStructureDefinition/us-core-body-weightStructureDefinition/us-core-body-heightStructureDefinition/us-core-blood-pressure | VSAC |
| 216 | [Vital Signs Units](http://hl7.org/fhir/R4/valueset-ucum-vitals-common.html) | StructureDefinition/pediatric-bmi-for-ageStructureDefinition/us-core-pulse-oximetryStructureDefinition/head-occipital-frontal-circumference-percentileStructureDefinition/us-core-bmiStructureDefinition/us-core-body-temperatureStructureDefinition/us-core-respiratory-rateStructureDefinition/us-core-vital-signsStructureDefinition/us-core-head-circumferenceStructureDefinition/pediatric-weight-for-heightStructureDefinition/us-core-heart-rateStructureDefinition/us-core-body-weightStructureDefinition/us-core-body-heightStructureDefinition/us-core-blood-pressure | FHIR |
| 217 | [hl7VS-additivePreservative](http://terminology.hl7.org/ValueSet/v2-0371) | StructureDefinition/us-core-specimen | THO |
| 218 | [hl7VS-bedStatus](http://terminology.hl7.org/ValueSet/v2-0116) | StructureDefinition/us-core-location | THO |
| 219 | [hl7VS-re-admissionIndicator](http://terminology.hl7.org/ValueSet/v2-0092) | StructureDefinition/us-core-encounter | THO |
| 220 | [hl7VS-relevantClincialInformation](http://terminology.hl7.org/ValueSet/v2-0916) | StructureDefinition/us-core-specimen | THO |
| 221 | [hl7VS-specimenCondition](http://terminology.hl7.org/ValueSet/v2-0493) | ValueSet/us-core-specimen-condition | THO |
| 222 | [v2 table 0360](http://terminology.hl7.org/ValueSet/v2-0360) | FHIR Value set/code system definition for HL7 v2 table 0360 ver 2.9 ( Degree/License/Certificate) | THO |
| 223 | [v3 Code System ActCode](http://terminology.hl7.org/ValueSet/v3-ActCode) | StructureDefinition/us-core-adi-documentreferenceStructureDefinition/us-core-documentreference | THO |

### Code Systems

See the [FHIR terminology section](http://hl7.org/fhir/R4/terminologies-systems.html) for a complete discussion on code systems and a list of code system names used in FHIR. Most code systems used in this guide are defined in the base FHIR specification. However, the following code systems are unique to this guide and not listed in the base FHIR specification. If a URI is listed here, it **SHALL** be used in the US Core profiles to identify the code system in preference to any other code system URI.

#### Code systems published in this IG*- Includes US Core defined code systems and externally defined code systems

* [US Core CarePlan Category Extension Codes](CodeSystem-careplan-category.md)
* [US Core Category](CodeSystem-us-core-category.md)
* [US Core Condition Category Extension Codes](CodeSystem-condition-category.md)
* [US Core DocumentReferences Category Codes](CodeSystem-us-core-documentreference-category.md)
* [US Core Provenance Participant Type Extension Codes](CodeSystem-us-core-provenance-participant-type.md)

#### Externally Published code systems

| | | | |
| :--- | :--- | :--- | :--- |
| `https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets` | [CMS](https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets) | **Healthcare Common Procedure Coding System (HCPCS) Level II alphanumeric codes** | 2.16.840.1.113883.6.285 |
| `http://www.cms.gov/Medicare/Coding/ICD10` | [CMS](http://www.cms.gov/Medicare/Coding/ICD10/) | **International Classification of Diseases, 10th Revision, Procedure Coding System (ICD-10-PCS)**- See[ICD-10 PCS Codes](http://www.icd10data.com/icd10pcs)for online access to codes for general information purposes. | 2.16.840.1.113883.6.4 |
| `http://www.ada.org/cdt` | [ADA](http://www.ada.org/en/publications/cdt) | **Code on Dental Procedures and Nomenclature** | 2.16.840.1.113883.6.13 |
| `https://www.usps.com` | [USPS](http://pe.usps.com/text/pub28/28apb.htm) | **United States Postal Service Two–Letter State and Possession Abbreviations** | 2.16.840.1.113883.6.92 |

#### Code System Used in US Core

The following table lists all the CodeSystems used in US Core and where they can be found. This information is also available as a [csv](tables/codesystem-ref-all-list.csv) or [excel](tables/codesystem-ref-all-list.xlsx) file.

Code System Sources:

* [FHIR](http://hl7.org/fhir/R4/)
* [US CORE](terminology.md) 
* [THO](http://terminology.hl7.org/)
* [SNOMED](http://snomed.info/sct)
* [LOINC](http://loinc.org)
* [UCUM](http://unitsofmeasure.org)
* [CDC](https://www.cdc.gov/index.htm)
* Code systems published by other standards organizations

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| 1 |  | `http://dicom.nema.org/resources/ontology/DCM` | ValueSet/security-role-type | Other |
| 2 | [AHA NUBC Patient Discharge Status Codes](https://www.nubc.org/CodeSystem/PatDischargeStatus) | `https://www.nubc.org/CodeSystem/PatDischargeStatus` | ValueSet/v3-USEncounterDischargeDisposition | Other |
| 3 | [ActCode](http://terminology.hl7.org/CodeSystem/v3-ActCode) | `http://terminology.hl7.org/CodeSystem/v3-ActCode` | ValueSet/v3-ActPharmacySupplyTypeValueSet/v3-ActCodeValueSet/provenance-activity-typeValueSet/v3-ActEncounterCode | THO |
| 4 | [ActPriority](http://terminology.hl7.org/CodeSystem/v3-ActPriority) | `http://terminology.hl7.org/CodeSystem/v3-ActPriority` | ValueSet/v3-ActPriority | THO |
| 5 | [ActReason](http://terminology.hl7.org/CodeSystem/v3-ActReason) | `http://terminology.hl7.org/CodeSystem/v3-ActReason` | ValueSet/v3-PurposeOfUseValueSet/immunization-status-reasonValueSet/v3-SubstanceAdminSubstitutionReason | THO |
| 6 | [ActSite](http://terminology.hl7.org/CodeSystem/v3-ActSite) | `http://terminology.hl7.org/CodeSystem/v3-ActSite` | ValueSet/immunization-site | THO |
| 7 | [AddressType](http://hl7.org/fhir/R4/codesystem-address-type.html) | `http://hl7.org/fhir/address-type` | ValueSet/address-type | FHIR |
| 8 | [AddressUse](http://hl7.org/fhir/R4/codesystem-address-use.html) | `http://hl7.org/fhir/address-use` | ValueSet/address-use | FHIR |
| 9 | [AdministrativeGender](http://hl7.org/fhir/R4/codesystem-administrative-gender.html) | `http://hl7.org/fhir/administrative-gender` | ValueSet/administrative-gender | FHIR |
| 10 | [Admit source](http://terminology.hl7.org/CodeSystem/admit-source) | `http://terminology.hl7.org/CodeSystem/admit-source` | ValueSet/encounter-admit-source | THO |
| 11 | [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical) | `http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical` | ValueSet/allergyintolerance-clinical | THO |
| 12 | [AllergyIntolerance Verification Status](http://terminology.hl7.org/CodeSystem/allergyintolerance-verification) | `http://terminology.hl7.org/CodeSystem/allergyintolerance-verification` | ValueSet/allergyintolerance-verification | THO |
| 13 | [AllergyIntoleranceCategory](http://hl7.org/fhir/R4/codesystem-allergy-intolerance-category.html) | `http://hl7.org/fhir/allergy-intolerance-category` | ValueSet/allergy-intolerance-category | FHIR |
| 14 | [AllergyIntoleranceCriticality](http://hl7.org/fhir/R4/codesystem-allergy-intolerance-criticality.html) | `http://hl7.org/fhir/allergy-intolerance-criticality` | ValueSet/allergy-intolerance-criticality | FHIR |
| 15 | [AllergyIntoleranceSeverity](http://hl7.org/fhir/R4/codesystem-reaction-event-severity.html) | `http://hl7.org/fhir/reaction-event-severity` | ValueSet/reaction-event-severity | FHIR |
| 16 | [AllergyIntoleranceType](http://hl7.org/fhir/R4/codesystem-allergy-intolerance-type.html) | `http://hl7.org/fhir/allergy-intolerance-type` | ValueSet/allergy-intolerance-type | FHIR |
| 17 | [CMS Place of Service Codes (POS)](https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set) | `https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set` | ValueSet/CMSPlaceOfServiceCodes | Other |
| 18 | [CarePlanActivityStatus](http://hl7.org/fhir/R4/codesystem-care-plan-activity-status.html) | `http://hl7.org/fhir/care-plan-activity-status` | ValueSet/care-plan-activity-status | FHIR |
| 19 | [CareTeamStatus](http://hl7.org/fhir/R4/codesystem-care-team-status.html) | `http://hl7.org/fhir/care-team-status` | ValueSet/care-team-status | FHIR |
| 20 | [Code on Dental Procedures and Nomenclature](http://www.ada.org/cdt) | `http://www.ada.org/cdt` | ValueSet/us-core-procedure-code | Other |
| 21 | [Common Tags](http://terminology.hl7.org/CodeSystem/common-tags) | `http://terminology.hl7.org/CodeSystem/common-tags` | ValueSet/common-tags | THO |
| 22 | [CompositionStatus](http://hl7.org/fhir/R4/codesystem-composition-status.html) | `http://hl7.org/fhir/composition-status` | ValueSet/composition-status | FHIR |
| 23 | [Condition Category Codes](http://terminology.hl7.org/CodeSystem/condition-category) | `http://terminology.hl7.org/CodeSystem/condition-category` | ValueSet/condition-categoryValueSet/us-core-problem-or-health-concern | THO |
| 24 | [Condition Clinical Status Codes](http://terminology.hl7.org/CodeSystem/condition-clinical) | `http://terminology.hl7.org/CodeSystem/condition-clinical` | ValueSet/condition-clinical | THO |
| 25 | [ConditionVerificationStatus](http://terminology.hl7.org/CodeSystem/condition-ver-status) | `http://terminology.hl7.org/CodeSystem/condition-ver-status` | ValueSet/condition-ver-status | THO |
| 26 | [Contact entity type](http://terminology.hl7.org/CodeSystem/contactentity-type) | `http://terminology.hl7.org/CodeSystem/contactentity-type` | ValueSet/contactentity-type | THO |
| 27 | [ContactPointSystem](http://hl7.org/fhir/R4/codesystem-contact-point-system.html) | `http://hl7.org/fhir/contact-point-system` | ValueSet/contact-point-system | FHIR |
| 28 | [ContactPointUse](http://hl7.org/fhir/R4/codesystem-contact-point-use.html) | `http://hl7.org/fhir/contact-point-use` | ValueSet/contact-point-use | FHIR |
| 29 | [Contract Signer Type Codes](http://terminology.hl7.org/CodeSystem/contractsignertypecodes) | `http://terminology.hl7.org/CodeSystem/contractsignertypecodes` | ValueSet/security-role-type | THO |
| 30 | [Coverage Class Codes](http://terminology.hl7.org/CodeSystem/coverage-class) | `http://terminology.hl7.org/CodeSystem/coverage-class` | ValueSet/coverage-class | THO |
| 31 | [Coverage Copay Type Codes](http://terminology.hl7.org/CodeSystem/coverage-copay-type) | `http://terminology.hl7.org/CodeSystem/coverage-copay-type` | ValueSet/coverage-copay-type | THO |
| 32 | [Current Procedural Terminology (CPT®)](http://www.ama-assn.org/go/cpt) | `http://www.ama-assn.org/go/cpt` | ValueSet/us-core-procedure-code | Other |
| 33 | [DataAbsentReason](http://terminology.hl7.org/CodeSystem/data-absent-reason) | `http://terminology.hl7.org/CodeSystem/data-absent-reason` | ValueSet/data-absent-reason | THO |
| 34 | [DataOperation](http://terminology.hl7.org/CodeSystem/v3-DataOperation) | `http://terminology.hl7.org/CodeSystem/v3-DataOperation` | ValueSet/provenance-activity-type | THO |
| 35 | [DaysOfWeek](http://hl7.org/fhir/R4/codesystem-days-of-week.html) | `http://hl7.org/fhir/days-of-week` | ValueSet/days-of-week | FHIR |
| 36 | [DeviceNameType](http://hl7.org/fhir/R4/codesystem-device-nametype.html) | `http://hl7.org/fhir/device-nametype` | ValueSet/device-nametype | FHIR |
| 37 | [Diagnosis Role](http://terminology.hl7.org/CodeSystem/diagnosis-role) | `http://terminology.hl7.org/CodeSystem/diagnosis-role` | ValueSet/diagnosis-role | THO |
| 38 | [DiagnosticReportStatus](http://hl7.org/fhir/R4/codesystem-diagnostic-report-status.html) | `http://hl7.org/fhir/diagnostic-report-status` | ValueSet/diagnostic-report-status | FHIR |
| 39 | [Diet](http://terminology.hl7.org/CodeSystem/diet) | `http://terminology.hl7.org/CodeSystem/diet` | ValueSet/encounter-diet | THO |
| 40 | [DocumentCompletion](http://terminology.hl7.org/CodeSystem/v3-DocumentCompletion) | `http://terminology.hl7.org/CodeSystem/v3-DocumentCompletion` | ValueSet/provenance-activity-type | THO |
| 41 | [DocumentReferenceStatus](http://hl7.org/fhir/R4/codesystem-document-reference-status.html) | `http://hl7.org/fhir/document-reference-status` | ValueSet/document-reference-status | FHIR |
| 42 | [DocumentRelationshipType](http://hl7.org/fhir/R4/codesystem-document-relationship-type.html) | `http://hl7.org/fhir/document-relationship-type` | ValueSet/document-relationship-type | FHIR |
| 43 | [DoseAndRateType](http://terminology.hl7.org/CodeSystem/dose-rate-type) | `http://terminology.hl7.org/CodeSystem/dose-rate-type` | ValueSet/dose-rate-type | THO |
| 44 | [EncounterLocationStatus](http://hl7.org/fhir/R4/codesystem-encounter-location-status.html) | `http://hl7.org/fhir/encounter-location-status` | ValueSet/encounter-location-status | FHIR |
| 45 | [EncounterSpecialCourtesy](http://terminology.hl7.org/CodeSystem/v3-EncounterSpecialCourtesy) | `http://terminology.hl7.org/CodeSystem/v3-EncounterSpecialCourtesy` | ValueSet/encounter-special-courtesy | THO |
| 46 | [EncounterStatus](http://hl7.org/fhir/R4/codesystem-encounter-status.html) | `http://hl7.org/fhir/encounter-status` | ValueSet/encounter-status | FHIR |
| 47 | [EventStatus](http://hl7.org/fhir/R4/codesystem-event-status.html) | `http://hl7.org/fhir/event-status` | ValueSet/immunization-statusValueSet/event-status | FHIR |
| 48 | [Example Coverage Financial Exception Codes](http://terminology.hl7.org/CodeSystem/ex-coverage-financial-exception) | `http://terminology.hl7.org/CodeSystem/ex-coverage-financial-exception` | ValueSet/coverage-financial-exception | THO |
| 49 | [FHIRDeviceStatus](http://hl7.org/fhir/R4/codesystem-device-status.html) | `http://hl7.org/fhir/device-status` | ValueSet/device-status | FHIR |
| 50 | [FHIRDeviceStatusReason](http://terminology.hl7.org/CodeSystem/device-status-reason) | `http://terminology.hl7.org/CodeSystem/device-status-reason` | ValueSet/device-status-reason | THO |
| 51 | [Financial Resource Status Codes](http://hl7.org/fhir/R4/codesystem-fm-status.html) | `http://hl7.org/fhir/fm-status` | ValueSet/fm-status | FHIR |
| 52 | [Goal achievement status](http://terminology.hl7.org/CodeSystem/goal-achievement) | `http://terminology.hl7.org/CodeSystem/goal-achievement` | ValueSet/goal-achievement | THO |
| 53 | [Goal category](http://terminology.hl7.org/CodeSystem/goal-category) | `http://terminology.hl7.org/CodeSystem/goal-category` | ValueSet/goal-category | THO |
| 54 | [Goal priority](http://terminology.hl7.org/CodeSystem/goal-priority) | `http://terminology.hl7.org/CodeSystem/goal-priority` | ValueSet/goal-priority | THO |
| 55 | [GoalLifecycleStatus](http://hl7.org/fhir/R4/codesystem-goal-status.html) | `http://hl7.org/fhir/goal-status` | ValueSet/goal-status | FHIR |
| 56 | [HL7 Document Format Codes](http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes) | `http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes` | ValueSet/v3-HL7FormatCodes | THO |
| 57 | [ICD-10 Procedure Codes](http://www.cms.gov/Medicare/Coding/ICD10) | `http://www.cms.gov/Medicare/Coding/ICD10` | ValueSet/us-core-procedure-code | Other |
| 58 | [ICD-9-CM](https://www.cms.gov/medicare/coding-billing/icd-10-codes/icd-9-cm-diagnosis-procedure-codes-abbreviated-and-full-code-titles) | `http://hl7.org/fhir/sid/icd-9-cm` | ValueSet/us-core-condition-code | CDC |
| 59 | [IHE Format Code set for use with Document Sharing](http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode) | `http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode` | ValueSet/v3-HL7FormatCodes | Other |
| 60 | [IdentifierUse](http://hl7.org/fhir/R4/codesystem-identifier-use.html) | `http://hl7.org/fhir/identifier-use` | ValueSet/identifier-use | FHIR |
| 61 | [Immunization Funding Source](http://terminology.hl7.org/CodeSystem/immunization-funding-source) | `http://terminology.hl7.org/CodeSystem/immunization-funding-source` | ValueSet/immunization-funding-source | THO |
| 62 | [Immunization Origin Codes](http://terminology.hl7.org/CodeSystem/immunization-origin) | `http://terminology.hl7.org/CodeSystem/immunization-origin` | ValueSet/immunization-origin | THO |
| 63 | [Immunization Program Eligibility](http://terminology.hl7.org/CodeSystem/immunization-program-eligibility) | `http://terminology.hl7.org/CodeSystem/immunization-program-eligibility` | ValueSet/immunization-program-eligibility | THO |
| 64 | [Immunization Subpotent Reason](http://terminology.hl7.org/CodeSystem/immunization-subpotent-reason) | `http://terminology.hl7.org/CodeSystem/immunization-subpotent-reason` | ValueSet/immunization-subpotent-reason | THO |
| 65 | [International Classification of Diseases](https://www.cdc.gov/nchs/icd/icd-10-cm.htm) | `http://hl7.org/fhir/sid/icd-10-cm` | Clinical Modification (ICD-10-CM) | CDC |
| 66 | [LinkType](http://hl7.org/fhir/R4/codesystem-link-type.html) | `http://hl7.org/fhir/link-type` | ValueSet/link-type | FHIR |
| 67 | [Location type](http://terminology.hl7.org/CodeSystem/location-physical-type) | `http://terminology.hl7.org/CodeSystem/location-physical-type` | ValueSet/location-physical-type | THO |
| 68 | [LocationMode](http://hl7.org/fhir/R4/codesystem-location-mode.html) | `http://hl7.org/fhir/location-mode` | ValueSet/location-mode | FHIR |
| 69 | [LocationStatus](http://hl7.org/fhir/R4/codesystem-location-status.html) | `http://hl7.org/fhir/location-status` | ValueSet/location-status | FHIR |
| 70 | [Logical Observation Identifiers](http://loinc.org) | `http://loinc.org` | LOINC provides a set of universal names and ID codes for identifying laboratory and clinical test results.12 LOINC facilitates the exchange and pooling of resultssuch as blood hemoglobinserum potassiumor vital signsfor clinical careoutcomes managementand research. LOINC's universal identifiers (names and codes) can be used in the context of order and observation exchanges between information systems that use syntax standards such as HL73CEN TC251ISO TC215ASTM4and DICOM. Specificallythe identifier can be used as the coded value for an observation in any other standard that uses the observation/observation value paradigmwhether messagesdocumentsapplication programming interface (API)etc. For exampleLOINC codes are used widely in the OBX segment Observation Identifier field (OBX-3) of an ORU HL7 (HL7 version 2.x or ASTM 1238-9410) message that may be sent between a Clinical Laboratory Information Management Systems (LIMS) and Electronic Health Record Systems (EHR).56 In this wayLOINC codes provide universal identifiers that allow the exchange of clinical data between heterogeneous computing environments. | LOINC |
| 71 | [MaritalStatus](http://terminology.hl7.org/CodeSystem/v3-MaritalStatus) | `http://terminology.hl7.org/CodeSystem/v3-MaritalStatus` | ValueSet/marital-status | THO |
| 72 | [Medication status codes](http://hl7.org/fhir/R4/codesystem-medication-status.html) | `http://hl7.org/fhir/CodeSystem/medication-status` | ValueSet/medication-status | FHIR |
| 73 | Medication dispense category codes | `http://terminology.hl7.org/fhir/CodeSystem/medicationdispense-category` | ValueSet/medicationdispense-category | THO |
| 74 | Medication dispense status codes | `http://terminology.hl7.org/CodeSystem/medicationdispense-status` | ValueSet/medicationdispense-status | THO |
| 75 | Medication dispense status reason codes | `http://terminology.hl7.org/fhir/CodeSystem/medicationdispense-status-reason` | ValueSet/medicationdispense-status-reason | THO |
| 76 | [Medication request intent](http://hl7.org/fhir/R4/codesystem-medicationrequest-intent.html) | `http://hl7.org/fhir/CodeSystem/medicationrequest-intent` | ValueSet/medicationrequest-intent | FHIR |
| 77 | [MedicationDispense Performer Function Codes](http://terminology.hl7.org/CodeSystem/medicationdispense-performer-function) | `http://terminology.hl7.org/CodeSystem/medicationdispense-performer-function` | ValueSet/medicationdispense-performer-function | THO |
| 78 | [MedicationRequest Category Codes](http://terminology.hl7.org/CodeSystem/medicationrequest-category) | `http://terminology.hl7.org/CodeSystem/medicationrequest-category` | ValueSet/medicationrequest-category | THO |
| 79 | [MedicationRequest Course of Therapy Codes](http://terminology.hl7.org/CodeSystem/medicationrequest-course-of-therapy) | `http://terminology.hl7.org/CodeSystem/medicationrequest-course-of-therapy` | ValueSet/medicationrequest-course-of-therapy | THO |
| 80 | [MedicationRequest Status Reason Codes](http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason) | `http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason` | ValueSet/medicationrequest-status-reason | THO |
| 81 | [Medicationrequest status](http://hl7.org/fhir/R4/codesystem-medicationrequest-status.html) | `http://hl7.org/fhir/CodeSystem/medicationrequest-status` | ValueSet/medicationrequest-status | FHIR |
| 82 | [NUCC Provider Taxonomy](http://nucc.org/provider-taxonomy) | `http://nucc.org/provider-taxonomy` | ValueSet/2.16.840.1.114222.4.11.1066 | Other |
| 83 | [NameUse](http://hl7.org/fhir/R4/codesystem-name-use.html) | `http://hl7.org/fhir/name-use` | ValueSet/name-use | FHIR |
| 84 | [NarrativeStatus](http://hl7.org/fhir/R4/codesystem-narrative-status.html) | `http://hl7.org/fhir/narrative-status` | ValueSet/us-core-narrative-status | FHIR |
| 85 | [NullFlavor](http://terminology.hl7.org/CodeSystem/v3-NullFlavor) | `http://terminology.hl7.org/CodeSystem/v3-NullFlavor` | ValueSet/us-core-documentreference-typeValueSet/marital-statusValueSet/encounter-special-courtesy | THO |
| 86 | [Observation Category Codes](http://terminology.hl7.org/CodeSystem/observation-category) | `http://terminology.hl7.org/CodeSystem/observation-category` | ValueSet/us-core-screening-assessment-observation-categoryValueSet/us-core-simple-observation-categoryValueSet/us-core-clinical-result-observation-categoryValueSet/observation-categoryValueSet/us-core-screening-assessment-observation-maximum-category | THO |
| 87 | [Observation Reference Range Meaning Codes](http://terminology.hl7.org/CodeSystem/referencerange-meaning) | `http://terminology.hl7.org/CodeSystem/referencerange-meaning` | ValueSet/referencerange-meaning | THO |
| 88 | [ObservationInterpretation](http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation) | `http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation` | ValueSet/observation-interpretation | THO |
| 89 | [ObservationStatus](http://hl7.org/fhir/R4/codesystem-observation-status.html) | `http://hl7.org/fhir/observation-status` | ValueSet/us-core-observation-smoking-status-statusValueSet/observation-status | FHIR |
| 90 | [Occupational Data for Health (ODH)](http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH) | `http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH` | ValueSet/2.16.840.1.114222.4.11.7900ValueSet/2.16.840.1.114222.4.11.7901 | THO |
| 91 | [Organization type](http://terminology.hl7.org/CodeSystem/organization-type) | `http://terminology.hl7.org/CodeSystem/organization-type` | ValueSet/organization-type | THO |
| 92 | [Participant type](http://terminology.hl7.org/CodeSystem/participant-type) | `http://terminology.hl7.org/CodeSystem/participant-type` | ValueSet/encounter-participant-type | THO |
| 93 | [ParticipationFunction](http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction) | `http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction` | ValueSet/security-role-type | THO |
| 94 | [ParticipationType](http://terminology.hl7.org/CodeSystem/v3-ParticipationType) | `http://terminology.hl7.org/CodeSystem/v3-ParticipationType` | ValueSet/security-role-typeValueSet/encounter-participant-typeValueSet/provenance-activity-type | THO |
| 95 | [Provenance participant type](http://terminology.hl7.org/CodeSystem/provenance-participant-type) | `http://terminology.hl7.org/CodeSystem/provenance-participant-type` | ValueSet/us-core-provenance-participant-type | THO |
| 96 | [ProvenanceEntityRole](http://hl7.org/fhir/R4/codesystem-provenance-entity-role.html) | `http://hl7.org/fhir/provenance-entity-role` | ValueSet/provenance-entity-role | FHIR |
| 97 | [QuantityComparator](http://hl7.org/fhir/R4/codesystem-quantity-comparator.html) | `http://hl7.org/fhir/quantity-comparator` | ValueSet/quantity-comparator | FHIR |
| 98 | [QuestionnaireResponseStatus](http://hl7.org/fhir/R4/codesystem-questionnaire-answers-status.html) | `http://hl7.org/fhir/questionnaire-answers-status` | ValueSet/questionnaire-answers-status | FHIR |
| 99 | [RequestIntent](http://hl7.org/fhir/R4/codesystem-request-intent.html) | `http://hl7.org/fhir/request-intent` | ValueSet/request-intentValueSet/care-plan-intent | FHIR |
| 100 | [RequestPriority](http://hl7.org/fhir/R4/codesystem-request-priority.html) | `http://hl7.org/fhir/request-priority` | ValueSet/request-priority | FHIR |
| 101 | [RequestStatus](http://hl7.org/fhir/R4/codesystem-request-status.html) | `http://hl7.org/fhir/request-status` | ValueSet/request-status | FHIR |
| 102 | [ResourceType](http://hl7.org/fhir/R4/codesystem-resource-types.html) | `http://hl7.org/fhir/resource-types` | ValueSet/resource-typesValueSet/care-plan-activity-kind | FHIR |
| 103 | [RoleClass](http://terminology.hl7.org/CodeSystem/v3-RoleClass) | `http://terminology.hl7.org/CodeSystem/v3-RoleClass` | ValueSet/security-role-type | THO |
| 104 | [RoleCode](http://terminology.hl7.org/CodeSystem/v3-RoleCode) | `http://terminology.hl7.org/CodeSystem/v3-RoleCode` | ValueSet/security-role-typeValueSet/relatedperson-relationshiptypeValueSet/v3-ServiceDeliveryLocationRoleType | THO |
| 105 | [RouteOfAdministration](http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration) | `http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration` | ValueSet/immunization-route | THO |
| 106 | [SNOMED CT (all versions)](http://snomed.info/sct) | `http://snomed.info/sct` | ValueSet/servicerequest-categoryValueSet/specimen-container-typeValueSet/2.16.840.1.113762.1.4.1099.54ValueSet/procedure-followupValueSet/us-core-goal-descriptionValueSet/specimen-collection-methodValueSet/us-core-condition-code-currentValueSet/medication-form-codesValueSet/body-siteValueSet/manifestation-or-symptomValueSet/goal-start-eventValueSet/procedure-codeValueSet/medication-as-needed-reasonValueSet/2.16.840.1.113762.1.4.1166.22ValueSet/c80-facilitycodesValueSet/2.16.840.1.113762.1.4.1267.3ValueSet/immunization-reasonValueSet/substance-codeValueSet/observation-methodsValueSet/us-core-procedure-codeValueSet/care-plan-categoryValueSet/questionnaire-answersValueSet/servicerequest-orderdetailValueSet/clinical-findingsValueSet/condition-stageValueSet/immunization-target-diseaseValueSet/encounter-reasonValueSet/participant-roleValueSet/additional-instruction-codesValueSet/approach-site-codesValueSet/device-actionValueSet/us-core-condition-codeValueSet/medication-codesValueSet/device-kindValueSet/performer-roleValueSet/us-core-servicerequest-categoryValueSet/c80-practice-codesValueSet/referencerange-appliestoValueSet/route-codesValueSet/procedure-outcomeValueSet/care-plan-activity-outcomeValueSet/2.16.840.1.113762.1.4.1021.121ValueSet/procedure-categoryValueSet/condition-codeValueSet/condition-stage-typeValueSet/procedure-not-performed-reasonValueSet/immunization-status-reasonValueSet/administration-method-codesValueSet/condition-severity | SNOMED |
| 107 | [Security Role Type](http://terminology.hl7.org/CodeSystem/extra-security-role-type) | `http://terminology.hl7.org/CodeSystem/extra-security-role-type` | ValueSet/security-role-type | THO |
| 108 | [Service type](http://terminology.hl7.org/CodeSystem/service-type) | `http://terminology.hl7.org/CodeSystem/service-type` | ValueSet/service-type | THO |
| 109 | [Source of Payment Typology](https://nahdo.org/sopt) | `https://nahdo.org/sopt` | ValueSet/2.16.840.1.114222.4.11.3591 | Other |
| 110 | [Special arrangements](http://terminology.hl7.org/CodeSystem/encounter-special-arrangements) | `http://terminology.hl7.org/CodeSystem/encounter-special-arrangements` | ValueSet/encounter-special-arrangements | THO |
| 111 | [SpecimenStatus](http://hl7.org/fhir/R4/codesystem-specimen-status.html) | `http://hl7.org/fhir/specimen-status` | ValueSet/specimen-status | FHIR |
| 112 | [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/CodeSystem/subscriber-relationship) | `http://terminology.hl7.org/CodeSystem/subscriber-relationship` | ValueSet/subscriber-relationship | THO |
| 113 | [Substance Admin Substitution](http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution) | `http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution` | ValueSet/v3-ActSubstanceAdminSubstitutionCode | THO |
| 114 | Tags for the Identification of Languages | `urn:ietf:bcp:47` | ValueSet/languagesValueSet/Languages | Other |
| 115 | [TribalEntityUS](http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS) | `http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS` | ValueSet/v3-TribalEntityUS | THO |
| 116 | [UDIEntryType](http://hl7.org/fhir/R4/codesystem-udi-entry-type.html) | `http://hl7.org/fhir/udi-entry-type` | ValueSet/udi-entry-type | FHIR |
| 117 | [US Core Category](CodeSystem-us-core-category.md) | `http://hl7.org/fhir/us/core/CodeSystem/us-core-category` | ValueSet/us-core-screening-assessment-observation-categoryValueSet/us-core-simple-observation-categoryValueSet/us-core-servicerequest-categoryValueSet/us-core-screening-assessment-condition-categoryValueSet/us-core-screening-assessment-observation-maximum-category | US CORE |
| 118 | [US Core Condition Category Extension Codes](CodeSystem-condition-category.md) | `http://hl7.org/fhir/us/core/CodeSystem/condition-category` | ValueSet/us-core-problem-or-health-concern | US CORE |
| 119 | [US Core DocumentReferences Category Codes](CodeSystem-us-core-documentreference-category.md) | `http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category` | ValueSet/us-core-documentreference-category | US CORE |
| 120 | [US Core Provenance Participant Type Extension Codes](CodeSystem-us-core-provenance-participant-type.md) | `http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type` | ValueSet/us-core-provenance-participant-type | US CORE |
| 121 | [US State Codes](https://www.usps.com/) | `https://www.usps.com/` | ValueSet/USPS-State | Other |
| 122 | [Unified Code for Units of Measure (UCUM)](http://unitsofmeasure.org) | `http://unitsofmeasure.org` | ValueSet/ucum-bodyweightValueSet/ucum-bodytempValueSet/ucum-commonValueSet/ucum-vitals-commonValueSet/v3-UnitsOfMeasureCaseSensitiveValueSet/ucum-bodylength | UCUM |
| 123 | [Vaccine Administered Code Set (CVX)](https://www2a.cdc.gov/vaccines/iis/iisstandards/vaccines.asp?rpt=cvx) | `http://hl7.org/fhir/sid/cvx` | ValueSet/2.16.840.1.113762.1.4.1010.6 | CDC |
| 124 | [additivePreservative](http://terminology.hl7.org/CodeSystem/v2-0371) | `http://terminology.hl7.org/CodeSystem/v2-0371` | ValueSet/v2-0371 | THO |
| 125 | [bedStatus](http://terminology.hl7.org/CodeSystem/v2-0116) | `http://terminology.hl7.org/CodeSystem/v2-0116` | ValueSet/v2-0116 | THO |
| 126 | [contactRole2](http://terminology.hl7.org/CodeSystem/v2-0131) | `http://terminology.hl7.org/CodeSystem/v2-0131` | ValueSet/relatedperson-relationshiptypeValueSet/patient-contactrelationship | THO |
| 127 | [diagnosticServiceSectionId](http://terminology.hl7.org/CodeSystem/v2-0074) | `http://terminology.hl7.org/CodeSystem/v2-0074` | ValueSet/diagnostic-service-sections | THO |
| 128 | [identifierType](http://terminology.hl7.org/CodeSystem/v2-0203) | `http://terminology.hl7.org/CodeSystem/v2-0203` | ValueSet/identifier-type | THO |
| 129 | [providerRole](http://terminology.hl7.org/CodeSystem/v2-0443) | `http://terminology.hl7.org/CodeSystem/v2-0443` | ValueSet/immunization-function | THO |
| 130 | [re-admissionIndicator](http://terminology.hl7.org/CodeSystem/v2-0092) | `http://terminology.hl7.org/CodeSystem/v2-0092` | ValueSet/v2-0092 | THO |
| 131 | [relevantClincialInformation](http://terminology.hl7.org/CodeSystem/v2-0916) | `http://terminology.hl7.org/CodeSystem/v2-0916` | ValueSet/v2-0916 | THO |
| 132 | [treatment](http://terminology.hl7.org/CodeSystem/v2-0373) | `http://terminology.hl7.org/CodeSystem/v2-0373` | ValueSet/specimen-processing-procedure | THO |

### The Value Set Authority Center (VSAC)

This guide links terminology directly to the FHIR® Terminology Service for VSAC Resources ([Value Set Authority Center (VSAC)](https://vsac.nlm.nih.gov/)), where applicable, using a RESTful API service to access the VSAC value sets and supported code systems. See the table above for a list of value sets used in US Core that VSAC defines.

#### How to Acess Value Sets in VSAC

* VSAC requires login using your own **UMLS API Key** to view the value sets. [VSAC UMLS Licensing information](https://www.nlm.nih.gov/vsac/support/usingvsac/requestumlslicense.html). (See the screenshots below)
* The value sets in VSAC are specified using a VSAC value set OID.
* To view the value set expansion in the VSAC user interface, use:


  `GET https://vsac.nlm.nih.gov/ValueSet/[VSAC OID]/expansion`


  An example of this is shown in the screenshots below.


  When viewing a ValueSet in the VSAC UI, the Code System OIDs and VSAC Code System names are displayed for each code. However, these code system identifiers **SHOULD NOT** be used. The FHIR URIs code systems are defined as part of FHIR and **SHOULD** be used instead. Unfortunately, the FHIR URI for the code system is not shown. As a convenience for the reader, a [VSAC to FHIR Code System Mapping Table](vsacname-fhiruri-map.md) is provided, which maps the VSAC Code System names to the corresponding FHIR URI. For more information, see this [documentation](https://www.nlm.nih.gov/vsac/support/usingvsac/vsacname-fhirname-fhirtitle.html) describing the relationships between the VSAC value set name, FHIR value set name, and FHIR value set title and how to access VSAC's FHIR API.
* To fetch the FHIR ValueSet resource (in other words, the value set definition), use:


  `GET https://cts.nlm.nih.gov/fhir/ValueSet/[VSAC OID]`
* To fetch the FHIR ValueSet resource expansion, use the FHIR `$expand` operation:


  `GET https://cts.nlm.nih.gov/fhir/ValueSet/[VSAC OID]/$expand`

For more information, refer to the [FHIR Terminology Service for VSAC Resources](https://www.nlm.nih.gov/vsac/support/usingvsac/vsacfhirapi.html)

##### Example

For example, the [US Core Smoking Status Observation Profile](StructureDefinition-us-core-smokingstatus.md) `valueCodeableConcept` element has a preferred binding to the Smoking Status value set. To access it in VSAC, click on the link to `https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.11.20.9.38/expansion`:

**Figure 1: VSAC link**
![](vsac-1.png)

The reader is redirected to the VSAC login page to enter an API Key (only one login is required per session):

**Figure 2: VSAC API-Key Login**
![](vsac-2.png)

After successfully entering the API Key, the value set can be inspected, downloaded, etc., using the VSAC User interface, as shown in the figure below. This FHIR ValueSet resource can also be fetched using the URL `https://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.38`, and the FHIR ValueSet expansion using the URL `https://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.38/$expand`.

**Figure 3: VSAC Smoking Status ValueSet**
![](vsac-3.png)

