# Search Parameters and Operations - US Core Implementation Guide v8.0.1

* [**Table of Contents**](toc.md)
* **Search Parameters and Operations**

## Search Parameters and Operations

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

### Operations

The following operation has been defined for the US Core Implementation Guide. For more information on [FHIR RESTful operations](http://hl7.org/fhir/R4/operations.html), see the FHIR specification.

* [US Core Fetch DocumentReference](OperationDefinition-docref.md)

### Search Parameters

The following search parameters have been defined for the US Core Implementation Guide. The FHIR specification provides more information on the [FHIR RESTful search API](http://hl7.org/fhir/R4/http.html#search) and the standard [Search Parameter Registry](http://hl7.org/fhir/R4/searchparameter-registry.html).

**SEE IMPLEMENTER NOTES BELOW**

#### Optional Search Parameters

The following search parameters have been defined as optional search parameters for search. US Core does not define any Server or Client expectations for their use.

* [race](SearchParameter-us-core-race.md)
* [ethnicity](SearchParameter-us-core-ethnicity.md)

#### Search Parameters defined by this Implementation Guide

The following search parameters have been defined by US Core. They are defined to be used for search and to document Server and Client expectations. Unlike the search parameter in the next section, they are not derived from the standard FHIR SearchParameters.

##### CareTeam

* [role](SearchParameter-us-core-careteam-role.md)

##### Condition

* [asserted-date](SearchParameter-us-core-condition-asserted-date.md)

##### Encounter

* [discharge-disposition](SearchParameter-us-core-encounter-discharge-disposition.md)

##### Goal

* [description](SearchParameter-us-core-goal-description.md)

##### Patient

#### Search Parameters derived from the Base FHIR Specification

These SearchParameter are used solely to document Server and Client expectations. Their definitions are derived from the standard FHIR SearchParameter and define additional expectations for the following SearchParameter elements:

* `multipleAnd`
* `multipleOr`
* `comparator`
* `modifier`
* `chain`

They **SHALL NOT** be interpreted as search parameters for search. Servers and Clients **SHOULD** use the standard FHIR SearchParameters.

##### AllergyIntolerance

* [clinical-status](SearchParameter-us-core-allergyintolerance-clinical-status.md)
* [patient](SearchParameter-us-core-allergyintolerance-patient.md)

##### CarePlan

* [category](SearchParameter-us-core-careplan-category.md)
* [date](SearchParameter-us-core-careplan-date.md)
* [patient](SearchParameter-us-core-careplan-patient.md)
* [status](SearchParameter-us-core-careplan-status.md)

##### CareTeam

* [patient](SearchParameter-us-core-careteam-patient.md)
* [status](SearchParameter-us-core-careteam-status.md)

##### Condition

* [_lastUpdated](SearchParameter-us-core-condition-lastupdated.md)
* [abatement-date](SearchParameter-us-core-condition-abatement-date.md)
* [category](SearchParameter-us-core-condition-category.md)
* [clinical-status](SearchParameter-us-core-condition-clinical-status.md)
* [code](SearchParameter-us-core-condition-code.md)
* [encounter](SearchParameter-us-core-condition-encounter.md)
* [onset-date](SearchParameter-us-core-condition-onset-date.md)
* [patient](SearchParameter-us-core-condition-patient.md)
* [recorded-date](SearchParameter-us-core-condition-recorded-date.md)

##### Coverage

* [patient](SearchParameter-us-core-coverage-patient.md)

##### Device

* [patient](SearchParameter-us-core-device-patient.md)
* [status](SearchParameter-us-core-device-status.md)
* [type](SearchParameter-us-core-device-type.md)

##### DiagnosticReport

* [_lastUpdated](SearchParameter-us-core-diagnosticreport-lastupdated.md)
* [category](SearchParameter-us-core-diagnosticreport-category.md)
* [code](SearchParameter-us-core-diagnosticreport-code.md)
* [date](SearchParameter-us-core-diagnosticreport-date.md)
* [patient](SearchParameter-us-core-diagnosticreport-patient.md)
* [status](SearchParameter-us-core-diagnosticreport-status.md)

##### DocumentReference

* [_id](SearchParameter-us-core-documentreference-id.md)
* [category](SearchParameter-us-core-documentreference-category.md)
* [date](SearchParameter-us-core-documentreference-date.md)
* [patient](SearchParameter-us-core-documentreference-patient.md)
* [period](SearchParameter-us-core-documentreference-period.md)
* [status](SearchParameter-us-core-documentreference-status.md)
* [type](SearchParameter-us-core-documentreference-type.md)

##### Encounter

* [_id](SearchParameter-us-core-encounter-id.md)
* [_lastUpdated](SearchParameter-us-core-encounter-lastupdated.md)
* [class](SearchParameter-us-core-encounter-class.md)
* [date](SearchParameter-us-core-encounter-date.md)
* [identifier](SearchParameter-us-core-encounter-identifier.md)
* [location](SearchParameter-us-core-encounter-location.md)
* [patient](SearchParameter-us-core-encounter-patient.md)
* [status](SearchParameter-us-core-encounter-status.md)
* [type](SearchParameter-us-core-encounter-type.md)

##### Goal

* [lifecycle-status](SearchParameter-us-core-goal-lifecycle-status.md)
* [patient](SearchParameter-us-core-goal-patient.md)
* [target-date](SearchParameter-us-core-goal-target-date.md)

##### Immunization

* [date](SearchParameter-us-core-immunization-date.md)
* [patient](SearchParameter-us-core-immunization-patient.md)
* [status](SearchParameter-us-core-immunization-status.md)

##### Location

* [address](SearchParameter-us-core-location-address.md)
* [address-city](SearchParameter-us-core-location-address-city.md)
* [address-postalcode](SearchParameter-us-core-location-address-postalcode.md)
* [address-state](SearchParameter-us-core-location-address-state.md)
* [name](SearchParameter-us-core-location-name.md)

##### MedicationDispense

* [patient](SearchParameter-us-core-medicationdispense-patient.md)
* [status](SearchParameter-us-core-medicationdispense-status.md)
* [type](SearchParameter-us-core-medicationdispense-type.md)

##### MedicationRequest

* [authoredon](SearchParameter-us-core-medicationrequest-authoredon.md)
* [encounter](SearchParameter-us-core-medicationrequest-encounter.md)
* [intent](SearchParameter-us-core-medicationrequest-intent.md)
* [patient](SearchParameter-us-core-medicationrequest-patient.md)
* [status](SearchParameter-us-core-medicationrequest-status.md)

##### Observation

* [_lastUpdated](SearchParameter-us-core-observation-lastupdated.md)
* [category](SearchParameter-us-core-observation-category.md)
* [code](SearchParameter-us-core-observation-code.md)
* [date](SearchParameter-us-core-observation-date.md)
* [patient](SearchParameter-us-core-observation-patient.md)
* [status](SearchParameter-us-core-observation-status.md)

##### Organization

* [address](SearchParameter-us-core-organization-address.md)
* [name](SearchParameter-us-core-organization-name.md)

##### Patient

* [_id](SearchParameter-us-core-patient-id.md)
* [birthdate](SearchParameter-us-core-patient-birthdate.md)
* [death-date](SearchParameter-us-core-patient-death-date.md)
* [family](SearchParameter-us-core-patient-family.md)
* [given](SearchParameter-us-core-patient-given.md)
* [identifier](SearchParameter-us-core-patient-identifier.md)
* [name](SearchParameter-us-core-patient-name.md)

##### Practitioner

* [_id](SearchParameter-us-core-practitioner-id.md)
* [identifier](SearchParameter-us-core-practitioner-identifier.md)
* [name](SearchParameter-us-core-practitioner-name.md)

##### PractitionerRole

* [practitioner](SearchParameter-us-core-practitionerrole-practitioner.md)
* [specialty](SearchParameter-us-core-practitionerrole-specialty.md)

##### Procedure

* [code](SearchParameter-us-core-procedure-code.md)
* [date](SearchParameter-us-core-procedure-date.md)
* [patient](SearchParameter-us-core-procedure-patient.md)
* [status](SearchParameter-us-core-procedure-status.md)

##### QuestionnaireResponse

* [_id](SearchParameter-us-core-questionnaireresponse-id.md)
* [authored](SearchParameter-us-core-questionnaireresponse-authored.md)
* [patient](SearchParameter-us-core-questionnaireresponse-patient.md)
* [questionnaire](SearchParameter-us-core-questionnaireresponse-questionnaire.md)
* [status](SearchParameter-us-core-questionnaireresponse-status.md)

##### RelatedPerson

* [_id](SearchParameter-us-core-relatedperson-id.md)
* [name](SearchParameter-us-core-relatedperson-name.md)
* [patient](SearchParameter-us-core-relatedperson-patient.md)

##### ServiceRequest

* [_id](SearchParameter-us-core-servicerequest-id.md)
* [authored](SearchParameter-us-core-servicerequest-authored.md)
* [category](SearchParameter-us-core-servicerequest-category.md)
* [code](SearchParameter-us-core-servicerequest-code.md)
* [patient](SearchParameter-us-core-servicerequest-patient.md)
* [status](SearchParameter-us-core-servicerequest-status.md)

##### Specimen

* [_id](SearchParameter-us-core-specimen-id.md)
* [patient](SearchParameter-us-core-specimen-patient.md)

